/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoHeapCommand
extends BaseJdmpviewCommand {
    public InfoHeapCommand() {
        this.addCommand("info heap", "[*|heap name]", "Displays information about Java heaps");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        out.print("\n");
        if (args.length == 0) {
            this.printHeapInfo(null, this.ctx.getRuntime(), out);
            out.print("\nUse \"info heap *\" or \"info heap <heap_name>\" for more information.\n");
            return;
        }
        if (args[0].equals("*") || args[0].equals("ALL")) {
            this.printHeapInfo(args[0], this.ctx.getRuntime(), out);
            return;
        }
        boolean foundHeap = this.searchForHeap(args[0], this.ctx.getRuntime(), out);
        if (!foundHeap) {
            out.print("Unable to locate heap: \"" + args[0] + "\".");
            out.print("\tAvailable heaps: \n");
            this.printHeapInfo(null, this.ctx.getRuntime(), out);
        }
    }

    private void printHeapInfo(String param, JavaRuntime runtime, PrintStream out) {
        Iterator itHeaps = runtime.getHeaps();
        int countheaps = 1;
        while (itHeaps.hasNext()) {
            Object heap = itHeaps.next();
            if (heap instanceof CorruptData) {
                out.println("[skipping corrupt heap");
                continue;
            }
            JavaHeap theHeap = (JavaHeap)heap;
            out.print("\t Heap #" + countheaps + ":  " + theHeap.getName() + "\n");
            if (param != null) {
                this.printSectionInfo(theHeap, out);
            }
            ++countheaps;
        }
    }

    private void printSectionInfo(JavaHeap theHeap, PrintStream out) {
        Iterator itSections = theHeap.getSections();
        int countSections = 1;
        while (itSections.hasNext()) {
            ImageSection theSection = (ImageSection)itSections.next();
            out.print("\t  Section #" + countSections + ":  " + theSection.getName() + "\n");
            out.print("\t   Size:        " + theSection.getSize() + " bytes\n");
            try {
                out.print("\t   Shared:      " + theSection.isShared() + "\n");
                out.print("\t   Executable:  " + theSection.isExecutable() + "\n");
                out.print("\t   Read Only:   " + theSection.isReadOnly() + "\n");
            }
            catch (DataUnavailable e) {
                out.print("\t   Shared:      <unknown>\n");
                out.print("\t   Executable:  <unknown>\n");
                out.print("\t   Read Only:   <unknown>\n");
            }
            ++countSections;
        }
    }

    private boolean searchForHeap(String param, JavaRuntime jr, PrintStream out) {
        boolean foundHeap = false;
        Iterator itHeaps = jr.getHeaps();
        int countheaps = 1;
        while (itHeaps.hasNext()) {
            JavaHeap theHeap = (JavaHeap)itHeaps.next();
            if (theHeap.getName().indexOf(param) == 0) {
                out.print("\t Heap #" + countheaps + ":  " + theHeap.getName() + "\n");
                this.printOccupancyInfo(theHeap, out);
                this.printSectionInfo(theHeap, out);
                foundHeap = true;
            }
            ++countheaps;
        }
        return foundHeap;
    }

    private void printOccupancyInfo(JavaHeap theHeap, PrintStream out) {
        long size = 0L;
        long totalObjectSize = 0L;
        long totalObjects = 0L;
        long totalCorruptObjects = 0L;
        Iterator itSections = theHeap.getSections();
        Object obj = null;
        CorruptData cdata = null;
        while (itSections.hasNext()) {
            obj = itSections.next();
            if (obj instanceof CorruptData) {
                cdata = obj;
                out.print("\t\t Warning - corrupt image section found");
                if (cdata.getAddress() != null) {
                    out.print(" at 0x" + cdata.getAddress().toString());
                }
                out.print("\n");
                continue;
            }
            ImageSection theSection = obj;
            size += theSection.getSize();
        }
        out.print("\t  Size of heap: " + size + " bytes\n");
        Iterator itObjects = theHeap.getObjects();
        try {
            while (itObjects.hasNext()) {
                obj = itObjects.next();
                ++totalObjects;
                if (obj instanceof CorruptData) {
                    ++totalCorruptObjects;
                    cdata = obj;
                    out.print("\t\t Warning - corrupt heap object found at position " + totalObjects);
                    if (cdata.getAddress() != null) {
                        out.print(" address 0x" + cdata.getAddress().toString());
                    }
                    out.print("\n");
                    continue;
                }
                JavaObject theObject = obj;
                totalObjectSize += theObject.getSize();
            }
            float percentage = (float)totalObjectSize / (float)size * 10000.0f;
            int trimmedPercent = (int)percentage;
            percentage = (float)trimmedPercent / 100.0f;
            out.print("\t  Occupancy               :   " + totalObjectSize + " bytes  (" + percentage + "%)\n");
            out.print("\t  Total objects           :   " + totalObjects + "\n");
            out.print("\t  Total corrupted objects :   " + totalCorruptObjects + "\n");
        }
        catch (CorruptDataException e) {
            out.print("\t  Occupancy :   <unknown>\n");
        }
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("displays information about Java heaps\n\nparameters: none, \"*\", or heap name\n\n none prints:\n - heap name\n - heap section\n \"*\" or heap name prints the following information\n about all heaps or the specified heap, respectively:\n - heap name\n - (heap size and occupancy)\n - heap sections\n  - section name\n  - section size\n  - whether the section is shared\n  - whether the section is executable\n  - whether the section is read only\n");
    }
}

