/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.JdmpviewContextManager;
import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.Version;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.spi.ISession;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "open";
    private static final String defaultFactoryName = "com.ibm.dtfj.image.j9.ImageFactory";
    private String factoryName = System.getProperty("com.ibm.dtfj.image.factoryclass", "com.ibm.dtfj.image.j9.ImageFactory");
    private int apiLevelMajor = 0;
    private int apiLevelMinor = 0;
    private ImageFactory factory = null;

    public OpenCommand() {
        this.addCommand(CMD_NAME, "[path to core or zip]", "opens the specified core or zip file");
        this.factory = this.getFactory();
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        switch (args.length) {
            case 0: {
                out.println(Version.getAllVersionInfo(this.factory));
                return;
            }
            case 1: 
            case 2: {
                this.imagesFromCommandLine(args);
                break;
            }
            default: {
                out.println("The open command requires at least one and at most two parameters. See 'help open'.");
                return;
            }
        }
    }

    private void imagesFromCommandLine(String[] args) {
        block8: {
            this.apiLevelMajor = this.factory.getDTFJMajorVersion();
            this.apiLevelMinor = this.factory.getDTFJMinorVersion();
            this.out.println(Version.getAllVersionInfo(this.factory));
            this.out.println("Loading image from DTFJ...\n");
            try {
                Image[] images = new Image[1];
                if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
                    Logger.getLogger("j9ddr.view.dtfj").setLevel(Level.WARNING);
                }
                long current = System.currentTimeMillis();
                File file1 = new File(args[0]);
                if (args.length == 1) {
                    if (FileManager.isArchive((File)file1) && !this.ctx.hasPropertyBeenSet("zip.mode.legacy")) {
                        images = this.factory.getImagesFromArchive(file1, this.ctx.hasPropertyBeenSet("extract.mode"));
                    } else {
                        images[0] = this.factory.getImage(file1);
                    }
                } else {
                    File file2 = new File(args[1]);
                    images[0] = this.factory.getImage(file1, file2);
                }
                this.logger.fine(String.format("Time taken to load image %d ms", System.currentTimeMillis() - current));
                for (Image image : images) {
                    this.createContexts(image, args[0]);
                }
            }
            catch (IOException e) {
                this.out.println("Could not load dump file and/or could not load XML file: " + e.getMessage());
                if (!this.ctx.hasPropertyBeenSet("verbose.mode")) break block8;
                e.printStackTrace();
            }
        }
    }

    private ImageFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        try {
            Class<?> factoryClass = Class.forName(this.factoryName);
            this.factory = (ImageFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.out.println("ClassNotFoundException while getting ImageFactory: " + e.getMessage());
            this.out.println("Use -Dcom.ibm.dtfj.image.factoryclass=<classname> to change the ImageFactory");
            System.exit(1);
        }
        catch (InstantiationException e) {
            this.out.println("InstantiationException while getting ImageFactory: " + e.getMessage());
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            this.out.println("IllegalAccessException while getting ImageFactory: " + e.getMessage());
            System.exit(1);
        }
        return this.factory;
    }

    private void createContexts(Image loadedImage, String coreFilePath) {
        if (loadedImage == null) {
            return;
        }
        boolean hasContexts = false;
        Iterator spaces = loadedImage.getAddressSpaces();
        while (spaces.hasNext()) {
            Object o = spaces.next();
            if (o instanceof ImageAddressSpace) {
                ImageAddressSpace space = (ImageAddressSpace)o;
                Iterator procs = space.getProcesses();
                if (procs.hasNext()) {
                    while (procs.hasNext()) {
                        o = procs.next();
                        if (!(o instanceof ImageProcess)) continue;
                        ImageProcess proc = (ImageProcess)o;
                        Iterator runtimes = proc.getRuntimes();
                        if (runtimes.hasNext()) {
                            while (runtimes.hasNext()) {
                                o = runtimes.next();
                                if (o instanceof JavaRuntime) {
                                    this.createCombinedContext(loadedImage, this.apiLevelMajor, this.apiLevelMinor, space, proc, (JavaRuntime)o, coreFilePath);
                                    hasContexts = true;
                                    continue;
                                }
                                if (o instanceof CorruptData) {
                                    this.logger.fine("CorruptData encountered in ImageProcess.getRuntimes(): " + ((CorruptData)o).toString());
                                    this.createCombinedContext(loadedImage, this.apiLevelMajor, this.apiLevelMinor, space, proc, null, coreFilePath);
                                    hasContexts = true;
                                    continue;
                                }
                                this.logger.fine("Unexpected class encountered in ImageProcess.getRuntimes()");
                                this.createCombinedContext(loadedImage, this.apiLevelMajor, this.apiLevelMinor, space, proc, null, coreFilePath);
                                hasContexts = true;
                            }
                            continue;
                        }
                        this.createCombinedContext(loadedImage, this.apiLevelMajor, this.apiLevelMinor, space, proc, null, coreFilePath);
                        hasContexts = true;
                    }
                    continue;
                }
                this.createCombinedContext(loadedImage, this.apiLevelMajor, this.apiLevelMinor, space, null, null, coreFilePath);
                hasContexts = true;
                continue;
            }
            this.logger.fine("Skipping corrupt ImageAddress space");
        }
        if (!hasContexts && this.ctx.hasPropertyBeenSet("verbose.mode")) {
            this.out.println("Warning : no contexts were found, is this a valid core file ?");
        }
    }

    private void createCombinedContext(Image loadedImage, int major, int minor, ImageAddressSpace space, ImageProcess proc, JavaRuntime rt, String coreFilePath) {
        Object obj = this.ctx.getProperties().get("session");
        if (obj == null) {
            this.logger.fine("Could not create a new context as the session property has not been set");
            return;
        }
        if (!(obj instanceof Session)) {
            this.logger.fine("Could not create a new context as the session type was not recognised [" + obj.getClass().getName() + "]");
            return;
        }
        JdmpviewContextManager mgr = (JdmpviewContextManager)((ISession)obj).getContextManager();
        CombinedContext cc = (CombinedContext)mgr.createContext(loadedImage, major, minor, space, proc, rt);
        cc.startDDRInteractiveSession(loadedImage, this.out);
        cc.getProperties().put("core_file_path", coreFilePath);
        cc.getProperties().put("image.factory", this.getFactory());
        if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
            cc.getProperties().put("verbose.mode", "true");
        }
        try {
            boolean hasLibError = true;
            String os = cc.getImage().getSystemType().toLowerCase();
            if (os.contains("linux") || os.contains("aix")) {
                Iterator modules;
                if (cc.getProcess() != null && (modules = cc.getProcess().getLibraries()).hasNext() && (obj = modules.next()) instanceof ImageModule) {
                    hasLibError = false;
                }
            } else {
                hasLibError = false;
            }
            if (hasLibError) {
                this.out.println("Warning : native libraries are not available for " + coreFilePath);
            }
        }
        catch (DataUnavailable e) {
            this.logger.log(Level.FINE, "Warning : native libraries are not available for " + coreFilePath);
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "Error determining if native libraries are required for " + coreFilePath, e);
        }
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("Opens a core file or zip file and loads it into jdmpview ready for further analysis. Any resultant contexts are added to the  list of currently available contexts");
    }
}

