/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@DTFJPlugin(version=".*", runtime=false, image=false)
public class LogCommand
extends BaseJdmpviewCommand {
    public LogCommand() {
        this.addCommand("log", "[name level]", "display and control instances of java.util.logging.Logger");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        switch (args.length) {
            case 0: {
                this.displayLoggers();
                break;
            }
            case 2: {
                this.configureLogger(args[0], args[1]);
                break;
            }
            default: {
                out.println("Incorrect number of parameters supplied. See 'help log' for more details");
            }
        }
    }

    private void displayLoggers() {
        LogManager lm = LogManager.getLogManager();
        TreeSet<String> names = new TreeSet<String>();
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            Logger logger = lm.getLogger(e.nextElement());
            StringBuilder output = new StringBuilder();
            if (logger.getName().length() == 0) {
                output.append("<<default logger>>");
            } else {
                output.append(logger.getName());
            }
            if (logger.getHandlers().length == 0) {
                output.append(" : disabled");
            } else {
                output.append(" : enabled");
                output.append(" (");
                Level level = logger.getLevel();
                if (level != null) {
                    String name = level.getName();
                    output.append(name);
                }
                output.append(") ");
            }
            names.add(output.toString());
        }
        this.out.println("Currently installed loggers :-");
        for (String name : names) {
            this.out.print("\t");
            this.out.println(name);
        }
    }

    private void configureLogger(String name, String level) {
        LogManager lm = LogManager.getLogManager();
        Logger logger = lm.getLogger(name);
        if (name == null) {
            this.out.println("The logger name " + name + " was not recognised");
            return;
        }
        Level lvl = null;
        try {
            lvl = Level.parse(level);
        }
        catch (IllegalArgumentException e) {
            this.out.println("The level " + level + " was not recognised");
            return;
        }
        if (logger.getHandlers().length != 0) {
            for (Handler handler : logger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                logger.setLevel(lvl);
                handler.setLevel(lvl);
                return;
            }
        }
        ConsoleHandler handler = new ConsoleHandler();
        logger.setLevel(lvl);
        handler.setLevel(lvl);
        logger.addHandler(handler);
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("Command 'log' displays all the currently installed Java util loggers. \n'log <logname> <log level> allows you to selectively enable a logger and set its level.\nValid log levels are SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST\nUse 'log <logname> OFF' to disable a logger");
    }
}

