/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.DTFJClass;
import com.ibm.jvm.dtfjview.commands.DTFJMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandler {
    static final int UNKNOWN = 0;
    private static final int WORKS = 1;
    private static final int CAN_FAIL = 2;
    private static final int FAILS = 3;
    private static HashMap<String, DTFJClass> methodTable = new HashMap();
    private static IDTFJContext ctx;
    private static final Logger logger;

    public static String handleException(BaseJdmpviewCommand cmd, Throwable cause) {
        ctx = cmd.ctx;
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] myStack = cause.getStackTrace();
        BaseJdmpviewCommand.ArtifactType artifactType = cmd.getArtifactType();
        String artifactTypeName = null;
        switch (artifactType) {
            case core: {
                artifactTypeName = "core";
                break;
            }
            case javacore: {
                artifactTypeName = "javacore";
                break;
            }
            case phd: {
                artifactTypeName = "phd";
                break;
            }
            default: {
                artifactTypeName = "Unknown artifact type";
            }
        }
        DTFJMethod dMethod = ExceptionHandler.getDTFJMethod(myStack, cmd);
        if (cause instanceof DataUnavailable) {
            if (dMethod == null) {
                sb.append("Could not determine DTFJ class/method that caused this exception: ");
                sb.append(cause.getLocalizedMessage());
            } else if (dMethod.isSupported(artifactType) == 1) {
                sb.append(dMethod.getClassName());
                sb.append(".");
                sb.append(dMethod.getMethodname());
                sb.append(" should have worked for a ");
                sb.append(artifactTypeName);
                sb.append(" but returned: ");
                sb.append(cause.getLocalizedMessage());
            } else if (dMethod.isSupported(artifactType) == 2) {
                sb.append(dMethod.getClassName());
                sb.append(".");
                sb.append(dMethod.getMethodname());
                sb.append(" can fail for a ");
                sb.append(artifactTypeName);
                sb.append(" which is why it returned: ");
                sb.append(cause.getLocalizedMessage());
            } else if (dMethod.isSupported(artifactType) == 3) {
                sb.append(dMethod.getClassName());
                sb.append(".");
                sb.append(dMethod.getMethodname());
                sb.append(" is not supported for a ");
                sb.append(artifactTypeName);
                String s = cause.getLocalizedMessage();
                if (s != null) {
                    sb.append(" causing: ");
                    sb.append(s);
                }
            }
        } else if (cause instanceof CorruptDataException) {
            CorruptData corruptData = ((CorruptDataException)cause).getCorruptData();
            ImagePointer ip = corruptData.getAddress();
            if (ip == null) {
                sb.append("CorruptData found in dump at unknown address executing ");
                if (dMethod == null) {
                    sb.append("an unknown class/method that caused this exception: ");
                    sb.append(cause.getLocalizedMessage());
                } else {
                    sb.append(dMethod.getClassName());
                    sb.append(".");
                    sb.append(dMethod.getMethodname());
                }
            } else {
                String addr = cmd.toHexStringAddr(ip.getAddress());
                sb.append("CorruptData found in dump at address: ");
                sb.append(addr);
                sb.append(" causing: ");
                sb.append(cause.getLocalizedMessage());
                if (dMethod != null) {
                    sb.append(" executing ");
                    sb.append(dMethod.getClassName());
                    sb.append(".");
                    sb.append(dMethod.getMethodname());
                }
            }
        } else if (cause instanceof MemoryAccessException) {
            sb.append(cause.getLocalizedMessage());
        } else if (cause instanceof IllegalArgumentException) {
            sb.append(cause.getLocalizedMessage());
        } else {
            sb.append("==========> Unexpected exception " + cause.getClass().getName() + " thrown: " + cause.getLocalizedMessage());
            StringWriter st = new StringWriter();
            cause.printStackTrace(new PrintWriter(st));
            sb.append(st.toString());
        }
        return sb.toString();
    }

    private static DTFJMethod getDTFJMethod(StackTraceElement[] myStack, BaseJdmpviewCommand cmd) {
        for (int s = 0; s < 3; ++s) {
            String className = myStack[s].getClassName();
            String methodName = myStack[s].getMethodName();
            try {
                Class<?> c = Class.forName(className, true, ((Object)((Object)cmd)).getClass().getClassLoader());
                do {
                    DTFJMethod method;
                    if ((method = ExceptionHandler.checkInterfaces(c, methodName)) == null) continue;
                    return method;
                } while ((c = c.getSuperclass()) != null);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error examining stack trace to determine failing method.", e);
            }
        }
        return null;
    }

    private static DTFJMethod checkInterfaces(Class<?> c, String methodName) {
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            DTFJClass classDefinition;
            DTFJMethod om;
            String name;
            DTFJClass oc;
            String interfaceName = interfaces[i].getName();
            int index = interfaceName.lastIndexOf(46);
            if ((oc = methodTable.get(name = interfaceName.substring(++index))) != null && (om = (classDefinition = oc).getMethod(methodName)) != null) {
                return om;
            }
            try {
                Class<?> ic = Class.forName(interfaceName, true, ctx.getAddressSpace().getClass().getClassLoader());
                om = ExceptionHandler.checkInterfaces(ic, methodName);
                if (om == null) continue;
                return om;
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINE, "Error checking interfaces.", e);
            }
        }
        return null;
    }

    private static void init() {
        DTFJClass c1 = new DTFJClass("JavaClass");
        c1.addMethod("getClassLoader", 1, 1, 1);
        c1.addMethod("getComponentType", 1, 3, 1);
        c1.addMethod("getConstantPoolReference", 1, 3, 1);
        c1.addMethod("getDeclaredFields", 1, 3, 1);
        c1.addMethod("getDeclaredMethods", 1, 3, 1);
        c1.addMethod("getInterfaces", 1, 3, 1);
        c1.addMethod("getModifiers", 1, 3, 1);
        c1.addMethod("getName", 1, 1, 1);
        c1.addMethod("getObject", 1, 1, 1);
        c1.addMethod("getReferences", 1, 3, 1);
        c1.addMethod("getSuperclass", 1, 3, 1);
        methodTable.put("JavaClass", c1);
        DTFJClass c2 = new DTFJClass("JavaClassLoader");
        c2.addMethod("findClass", 1, 1, 1);
        c2.addMethod("getCachedClasses", 1, 1, 1);
        c2.addMethod("getDefinedClasses", 1, 1, 1);
        c2.addMethod("getObject", 1, 1, 1);
        methodTable.put("JavaClassLoader", c2);
        DTFJClass c3 = new DTFJClass("JavaField");
        c3.addMethod("get", 1, 3, 3);
        c3.addMethod("getBoolean", 1, 3, 3);
        c3.addMethod("getByte", 1, 3, 3);
        c3.addMethod("getChar", 1, 3, 3);
        c3.addMethod("getDouble", 1, 3, 3);
        c3.addMethod("getFloat", 1, 3, 3);
        c3.addMethod("getInt", 1, 3, 3);
        c3.addMethod("getLong", 1, 3, 3);
        c3.addMethod("getShort", 1, 3, 3);
        c3.addMethod("getString", 1, 3, 3);
        methodTable.put("JavaField", c3);
        DTFJClass c4 = new DTFJClass("JavaHeap");
        c3.addMethod("getName", 1, 3, 1);
        c3.addMethod("getObject", 1, 3, 1);
        c3.addMethod("getSections", 1, 1, 1);
        methodTable.put("JavaHeap", c4);
        DTFJClass c5 = new DTFJClass("JavaLocation");
        c5.addMethod("getAddress", 1, 3, 3);
        c5.addMethod("getCompilationLevel", 1, 3, 3);
        c5.addMethod("getFilename", 1, 3, 3);
        c5.addMethod("getLineNumber", 2, 3, 3);
        c5.addMethod("getMethod", 1, 3, 3);
        methodTable.put("JavaLocation", c5);
        DTFJClass c6 = new DTFJClass("JavaMember");
        c6.addMethod("getDeclaringClass", 1, 3, 3);
        c6.addMethod("getModifiers", 1, 3, 3);
        c6.addMethod("getName", 1, 3, 3);
        c6.addMethod("getSignature", 1, 3, 3);
        methodTable.put("JavaMember", c6);
        DTFJClass c7 = new DTFJClass("JavaMethod");
        c7.addMethod("getBytecodeSections", 1, 3, 3);
        c7.addMethod("getCompiledSections", 1, 3, 3);
        methodTable.put("JavaMethod", c7);
        DTFJClass c8 = new DTFJClass("JavaMonitor");
        c8.addMethod("getEnterWaiters", 1, 1, 3);
        c8.addMethod("getName", 1, 1, 3);
        c8.addMethod("getNotifyWaiters", 1, 1, 3);
        c8.addMethod("getOwner", 1, 1, 3);
        methodTable.put("JavaMonitor", c8);
        DTFJClass c9 = new DTFJClass("JavaObject");
        c9.addMethod("arrayCopy", 1, 3, 1);
        c9.addMethod("getArraySize", 1, 3, 1);
        c9.addMethod("getHashcode", 1, 3, 1);
        c9.addMethod("getHeap", 1, 3, 1);
        c9.addMethod("getJavaClass", 1, 3, 1);
        c9.addMethod("getPersistentHashcode", 1, 3, 1);
        c9.addMethod("getReferences", 1, 3, 1);
        c9.addMethod("getSections", 1, 3, 1);
        c9.addMethod("getSize", 1, 3, 1);
        c9.addMethod("isArray", 1, 3, 1);
        methodTable.put("JavaObject", c9);
        DTFJClass c10 = new DTFJClass("JavaReference");
        c10.addMethod("getReachability", 1, 3, 1);
        c10.addMethod("getReferenceType", 1, 3, 1);
        c10.addMethod("getRootType", 1, 3, 1);
        c10.addMethod("getSource", 1, 3, 1);
        c10.addMethod("getTarget", 1, 3, 1);
        c10.addMethod("isClassReference", 1, 3, 1);
        c10.addMethod("isObjectReference", 1, 3, 1);
        methodTable.put("JavaReference", c10);
        DTFJClass c11 = new DTFJClass("JavaRuntime");
        c11.addMethod("getJavaVM", 1, 3, 1);
        c11.addMethod("getJavaVMInitArgs", 1, 1, 3);
        c11.addMethod("getObjectAtAddress", 1, 3, 1);
        c11.addMethod("getTraceBuffer", 3, 3, 3);
        methodTable.put("JavaRuntime", c11);
        DTFJClass c12 = new DTFJClass("JavaStackFrame");
        c12.addMethod("getBasePointer", 1, 1, 3);
        c12.addMethod("getLocation", 1, 1, 3);
        methodTable.put("JavaStackFrame", c12);
        DTFJClass c13 = new DTFJClass("JavaThread");
        c13.addMethod("getImageThread", 1, 1, 3);
        c13.addMethod("getJNIEnv", 1, 1, 3);
        c13.addMethod("getName", 1, 1, 3);
        c13.addMethod("getObject", 1, 1, 3);
        c13.addMethod("getPriority", 1, 1, 3);
        c13.addMethod("getState", 1, 1, 3);
        methodTable.put("JavaThread", c13);
        DTFJClass c14 = new DTFJClass("JavaVMInitArgs");
        c14.addMethod("getIgnoreUnrecognized", 1, 1, 3);
        c14.addMethod("getOptions", 1, 1, 3);
        c14.addMethod("getVersion", 1, 3, 3);
        methodTable.put("JavaVMInitArgs", c14);
        DTFJClass c15 = new DTFJClass("JavaVMOptions");
        c15.addMethod("getExtraInfo", 1, 1, 3);
        c15.addMethod("getOptionString", 1, 1, 3);
        methodTable.put("JavaVMOptions", c15);
        DTFJClass c16 = new DTFJClass("Image");
        c16.addMethod("getCreationTime", 2, 1, 1);
        c16.addMethod("getHostName", 1, 3, 3);
        c16.addMethod("getInstalledMemory", 1, 3, 3);
        c16.addMethod("getIPAddresses", 1, 1, 3);
        c16.addMethod("getProcessorCount", 1, 1, 3);
        c16.addMethod("getProcessorSubType", 1, 1, 3);
        c16.addMethod("getProcessorType", 1, 3, 3);
        c16.addMethod("getSystemSubType", 1, 1, 3);
        c16.addMethod("getSystemType", 1, 1, 3);
        methodTable.put("Image", c16);
        DTFJClass c17 = new DTFJClass("ImageModule");
        c17.addMethod("getName", 1, 1, 3);
        c17.addMethod("getProperties", 1, 1, 3);
        c17.addMethod("getLoadAddress", 1, 3, 3);
        c17.addMethod("getExecutable", 1, 3, 3);
        methodTable.put("ImageModule", c17);
        DTFJClass c18 = new DTFJClass("ImagePointer");
        c18.addMethod("getByteAt", 1, 3, 3);
        c18.addMethod("getDoubleAt", 1, 3, 3);
        c18.addMethod("getFloatAt", 1, 3, 3);
        c18.addMethod("getIntAt", 1, 3, 3);
        c18.addMethod("getLongAt", 1, 3, 3);
        c18.addMethod("getPointerAt", 1, 3, 3);
        c18.addMethod("getShortAt", 1, 3, 3);
        c18.addMethod("isExecutable", 1, 3, 3);
        c18.addMethod("isReadOnly", 1, 3, 3);
        c18.addMethod("isShared", 1, 3, 3);
        methodTable.put("ImagePointer", c18);
        DTFJClass c19 = new DTFJClass("ImageProcess");
        c19.addMethod("getCommandLine", 1, 1, 3);
        c19.addMethod("getCurrentThread", 1, 3, 3);
        c19.addMethod("getEnvironment", 1, 1, 3);
        c19.addMethod("getExecutable", 1, 3, 3);
        c19.addMethod("getID", 1, 3, 3);
        c19.addMethod("getLibraries", 1, 3, 3);
        c19.addMethod("getSignalName", 1, 1, 3);
        c19.addMethod("getSignalNumber", 1, 1, 3);
        methodTable.put("ImageProcess", c19);
        DTFJClass c20 = new DTFJClass("ImageRegister");
        c20.addMethod("getValue", 1, 3, 3);
        methodTable.put("ImageRegister", c20);
        DTFJClass c21 = new DTFJClass("ImageSection");
        c21.addMethod("isExecutable", 1, 3, 3);
        c21.addMethod("isReadOnly", 1, 3, 3);
        c21.addMethod("isShared", 1, 3, 3);
        methodTable.put("ImageSection", c21);
        DTFJClass c22 = new DTFJClass("ImageStackFrame");
        c22.addMethod("getBasePointer", 1, 1, 3);
        c22.addMethod("getProcedureAddress", 1, 1, 3);
        c22.addMethod("getProcedureName", 1, 1, 3);
        methodTable.put("ImageStackFrame", c22);
        DTFJClass c23 = new DTFJClass("ImageThread");
        c23.addMethod("getID", 1, 1, 3);
        c23.addMethod("getStackFrames", 1, 1, 3);
        methodTable.put("ImageThread", c23);
    }

    static {
        logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger.command");
        ExceptionHandler.init();
    }
}

