/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

class xc
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private static final String[] z;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        byte[] byArray = this.encodeECParameters();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName(z[7]);
            if (clazz2.isAssignableFrom(clazz)) {
                return new ECParameterSpec(this.b, this.c, this.d, this.a);
            }
            throw new InvalidParameterSpecException(z[8]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[2] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidParameterSpecException(z[12]);
        }
        this.b = ((ECParameterSpec)algorithmParameterSpec).getCurve();
        this.c = ((ECParameterSpec)algorithmParameterSpec).getGenerator();
        this.d = ((ECParameterSpec)algorithmParameterSpec).getOrder();
        this.a = ((ECParameterSpec)algorithmParameterSpec).getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = xc.decodeECParameters(byArray);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        return z[20] + this.b.getA() + z[19] + this.b.getB() + z[18] + this.b.getField().getFieldSize() + z[21] + ECUtils.a(this.c) + z[16] + this.d.toString() + z[17] + this.a + "\n";
    }

    protected static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[1], z[0]);
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[2] + generalSecurityException);
        }
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n2 = ellipticCurve.getField().getFieldSize();
        int n3 = n2 + 7 >> 3;
        byte[] byArray = xc.a(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = xc.a(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n3 || byArray2.length > n3) {
            throw new RuntimeException(z[13]);
        }
        byte[] byArray3 = new byte[1 + (n3 << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, n3 - byArray.length + 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[15]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[14]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    static byte[] a(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static DerValue encodeEllipticCurve(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = xc.a(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = xc.a(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[24] + iOException);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[5]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = byArray3 == null ? new EllipticCurve(eCField, bigInteger, bigInteger2) : new EllipticCurve(eCField, bigInteger, bigInteger2, byArray3);
            return ellipticCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[6] + iOException);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[9] + iOException);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[5]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[4]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[3] + iOException);
        }
    }

    public byte[] encodeECParameters() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            ECNamedCurve eCNamedCurve = xc.getNamedCurve(eCParameterSpec);
            if (eCNamedCurve != null) {
                return eCNamedCurve.a();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[23]);
            }
            DerValue derValue = xc.encodePrimeFieldType((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = xc.encodeEllipticCurve(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = xc.encodePoint(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[22] + iOException);
        }
    }

    public static ECParameterSpec decodeECParameters(byte[] byArray) throws IOException {
        boolean bl = false;
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                if (derValue.getTag() == 6) {
                    String string = derValue.getOID().toString();
                    return ECNamedCurve.getECParameterSpec(string);
                }
                throw new IOException(z[10]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            int n2 = derInputStream2.getInteger().intValue();
            DerValue derValue2 = derInputStream2.getDerValue();
            ECFieldFp eCFieldFp = xc.decodePrimeFieldType(derValue2);
            DerValue derValue3 = derInputStream2.getDerValue();
            EllipticCurve ellipticCurve = xc.decodeEllipticCurve(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream2.getOctetString();
            ECPoint eCPoint = xc.decodePoint(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream2.getBigInteger();
            int n3 = 0;
            if (derInputStream2.available() != 0) {
                bl = true;
                n3 = derInputStream2.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[11] + iOException);
        }
    }

    public static ECNamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = ECNamedCurve.b();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                String string = entry.getKey();
                ECParameterSpec eCParameterSpec2 = entry.getValue();
                BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                byte[] byArray = eCParameterSpec2.getCurve().getSeed();
                byte[] byArray2 = eCParameterSpec.getCurve().getSeed();
                if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4) || n2 != n3) continue;
                if (byArray != null || byArray2 != null) {
                    if (byArray == null && byArray2 != null || byArray != null && byArray2 == null) continue;
                    if (byArray != null && byArray2 != null) {
                        if (byArray.length != byArray2.length) continue;
                        boolean bl = true;
                        for (int i2 = 0; i2 < byArray.length; ++i2) {
                            if (byArray[i2] == byArray2[i2]) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator()) || !eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder()) || eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) continue;
                ECNamedCurve eCNamedCurve = new ECNamedCurve(string);
                return eCNamedCurve;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0019f\u0002fp\u0015";
        int n3 = -1;
        block32: while (true) {
            char[] cArray;
            block36: {
                int n4;
                int n5;
                block35: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block35;
                    n5 = n5;
                    if (n5 <= n4) break block36;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 80;
                            break;
                        }
                        case 1: {
                            n6 = 36;
                            break;
                        }
                        case 2: {
                            n6 = 79;
                            break;
                        }
                        case 3: {
                            n6 = 44;
                            break;
                        }
                        default: {
                            n6 = 51;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0015g";
                    n3 = 0;
                    continue block32;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0005J<YC K=XV4\u0004?MA1I*XV\"\u0004<\\V3M)EP1P&C]j\u0004";
                    n3 = 1;
                    continue block32;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0015\\,IC$M B\u00139JoHV3K+Ic\"M\"Iu9A#Hg)T*\u0004\u001aj\u0004";
                    n3 = 2;
                    continue block32;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0019J,CA\"A,X\u0013\u001fm\u000b\fV>G Y]$A=IWp@:^Z>CoHV3K+Ic\"M\"Iu9A#Hg)T*\u0002";
                    n3 = 3;
                    continue block32;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001eK;\fRpw\n}f\u0015j\fi";
                    n3 = 4;
                    continue block32;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0015\\,IC$M B\u00139JoHV3K+Iv<H&\\G9G\fYA&Ag\u0005\tp";
                    n3 = 5;
                    continue block32;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ":E9M\u001d#A,YA9P6\u0002@ A,\u0002v\u0013t.^R=A;IA\u0003T*O";
                    n3 = 6;
                    continue block32;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0019J.\\C\"K?^Z1P*\fC1V.AV$A=\f` A,EU9G.XZ?J";
                    n3 = 7;
                    continue block32;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0015\\,IC$M B\u00139JoI]3K+Ic\"M\"Iu9A#Hg)T*\u0004\u001aj\u0004";
                    n3 = 8;
                    continue block32;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001eK;\fRpw\n}f\u0015j\fi\u0013?VoM]pk\u0006h";
                    n3 = 9;
                    continue block32;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0015\\,IC$M B\u00139JoHV3K+Iv\u0013t.^R=A;IA#\ff\u0016\u0013";
                    n3 = 10;
                    continue block32;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0019J.\\C\"K?^Z1P*\fC1V.AV$A=\f@ A,EU9G.XZ?J";
                    n3 = 11;
                    continue block32;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0000K&BGpG CA4M!MG5WoH\\pJ X\u0013=E;O[pB&I_4\u0004<EI5";
                    n3 = 12;
                    continue block32;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0000K&BGp@ I@pJ X\u0013=E;O[pB&I_4\u0004<EI5";
                    n3 = 13;
                    continue block32;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u001fJ#U\u0013%J,C^ V*_@5@o\\\\9J;\fU?V\"MGpW:\\C?V;IW";
                    n3 = 14;
                    continue block32;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "Z- ^W5Vu\f9Y-";
                    n3 = 15;
                    continue block32;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "Z-,CU1G;CAj\u0004";
                    n3 = 16;
                    continue block32;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "Z-F_Z*Au\f";
                    n3 = 17;
                    continue block32;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "Z-FN\tp";
                    n3 = 18;
                    continue block32;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "Z-,YA&Au\f9Y-.\u0016\u0013";
                    n3 = 19;
                    continue block32;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "Z-(I]5V.X\\\"\u001eo&:Y";
                    n3 = 20;
                    continue block32;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\u0015\\,IC$M B\u00139JoI]3K+Iv\u0013t.^R=A;IA#\ff\u0016\u0013";
                    n3 = 21;
                    continue block32;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\u0015g\tEV<@\t\u001e^pA!O\\%J;IA5@oE]pA!O\\4A\noc1V.AV$A=_\u001by\no\fv\u0013b&I_4b}A\u00139WoB\\$\u0004,YA\"A!X_)\u0004<YC K=XV4\n";
                    n3 = 22;
                    continue block32;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\u0015\\,IC$M B\u00139JoI]3K+Iv<H&\\G9G\fYA&Ag\u0005\tp";
                    n3 = 23;
                    continue block32;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

