/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.ByteSequenceXorFactory;
import com.ibm.security.cmskeystore.DatabaseHashGenerator;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordHashGeneratorFactory;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class DatabaseHashGeneratorFactory {
    private DatabaseHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static DatabaseHashGenerator newDatabaseHashGenerator(FileHeader header) {
        if (header.getMajorVersionNumber().equals(VersionNumber.THREE)) {
            return new DatabaseHashGeneratorV3Impl();
        }
        return new DatabaseHashGeneratorV4Impl();
    }

    private static final class DatabaseHashGeneratorV3Impl
    implements DatabaseHashGenerator {
        private DatabaseHashGeneratorV3Impl() {
        }

        public ByteSequence generateHash(KeyDatabase database, String password) throws NullPointerException, NoSuchAlgorithmException, IOException {
            if (database == null || password == null) {
                throw new NullPointerException();
            }
            FileHeader header = database.getHeader();
            Sequence<Record> records = database.getRecords();
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordHeaderHash().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            ByteSequence pwd = ByteSequenceFactory.newByteSequence(password.getBytes("UTF-8"));
            i = pwd.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            ByteSequence digest = ByteSequenceFactory.newByteSequence(md.digest());
            for (Record record : records) {
                ByteSequence recordHash = RecordHashGeneratorFactory.newRecordHashGenerator(database.getHeader()).generateHash(header, record, password);
                digest = ByteSequenceXorFactory.newByteSequenceXor().xor(digest, recordHash);
            }
            return digest;
        }
    }

    private static final class DatabaseHashGeneratorV4Impl
    implements DatabaseHashGenerator {
        private DatabaseHashGeneratorV4Impl() {
        }

        public ByteSequence generateHash(KeyDatabase database, String password) throws NullPointerException, NoSuchAlgorithmException, IOException {
            if (database == null || password == null) {
                throw new NullPointerException();
            }
            FileHeader header = database.getHeader();
            Sequence<Record> records = database.getRecords();
            Mac md = Mac.getInstance("HmacSHA1");
            try {
                md.init(new NonPrintableAsciiPBEKey(new PBEKeySpec(password.toCharArray())));
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordHeaderHash().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            for (Record record : records) {
                i = record.getIterator();
                while (i.hasNextByte()) {
                    md.update(i.getNextByte());
                }
            }
            ByteSequence digest = ByteSequenceFactory.newByteSequence(md.doFinal());
            return digest;
        }
    }
}

