/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.sac;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.css.core.sac.SACParserFactory;
import org.w3c.css.sac.Parser;

public class SACParserFactoryImpl
extends SACParserFactory {
    private static Map parsers = new HashMap();

    static {
        SACParserFactoryImpl.registerSACParser("org.w3c.flute.parser.Parser");
        SACParserFactoryImpl.registerSACParser("org.w3c.flute.parser.CSS3Parser");
        SACParserFactoryImpl.registerSACParser("com.steadystate.css.parser.SACParser");
        SACParserFactoryImpl.registerSACParser("org.apache.batik.css.parser.Parser");
    }

    public SACParserFactoryImpl() {
        super.setPreferredParserName("org.apache.batik.css.parser.Parser");
    }

    public Parser makeParser(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NullPointerException, ClassCastException {
        String classNameParser = (String)parsers.get(name);
        if (classNameParser != null) {
            Class<?> classParser = super.getClass().getClassLoader().loadClass(classNameParser);
            return (Parser)classParser.newInstance();
        }
        throw new IllegalAccessException("SAC parser with name=" + name + " was not registered into SAC parser factory.");
    }

    public static void registerSACParser(String parser) {
        SACParserFactoryImpl.registerSACParser(parser, parser);
    }

    public static void registerSACParser(String name, String classNameParser) {
        parsers.put(name, classNameParser);
    }
}

