/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gpu;

import com.ibm.gpu.CUDADevice;
import com.ibm.gpu.GPUConfigurationException;
import com.ibm.gpu.GPUSortException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CUDAManager {
    private static final String VERSION = "0.8";
    private static CUDADevice[] devices;
    private static final String IBM_GPU_OUTPUT_HEADER = "[IBM GPU]: ";
    private boolean doSortOnGPU = false;
    private boolean enforceGPUSort = false;
    private static final String enablePropName = "com.ibm.gpu.enable";
    private static final String enforcePropName = "com.ibm.gpu.enforce";
    private static final String disablePropName = "com.ibm.gpu.disable";
    private static final String verboseGPUOutputPropName = "com.ibm.gpu.verbose";
    private int DEFAULT_DEVICE = 0;
    private static String testArg;
    private boolean verboseGPUOutput = false;
    private boolean onPower = false;
    private final boolean TEST_BUILD = false;
    private static CUDAManager singleton;
    private ConcurrentHashMap<Integer, Boolean> deviceBusyMapping = new ConcurrentHashMap();

    private void throwGPUConfigurationException(String string) throws GPUConfigurationException {
        this.outputIfVerbose(string);
        throw new GPUConfigurationException(IBM_GPU_OUTPUT_HEADER + string);
    }

    private void throwSortException(String string) throws GPUSortException {
        this.outputIfVerbose(string);
        throw new GPUSortException(IBM_GPU_OUTPUT_HEADER + string);
    }

    private void checkSupportedPlatform() throws GPUConfigurationException {
        String[] stringArray = new String[]{"ppc64le"};
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.arch", "");
            }
        });
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            if (string.startsWith("ppc64le")) {
                this.onPower = true;
            }
            return;
        }
        this.throwGPUConfigurationException("Unsupported platform detected");
    }

    private void checkStackSize() throws GPUConfigurationException {
        List list = (List)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public List<String> run() {
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                return runtimeMXBean.getInputArguments();
            }
        });
        for (String string : list) {
            if (!string.startsWith("-Xmso")) continue;
            Pattern pattern = Pattern.compile("(\\d+)([kMG]?)", 2);
            Matcher matcher = pattern.matcher(string.substring(5));
            if (!matcher.matches()) break;
            long l = Integer.parseInt(matcher.group(1));
            String string2 = matcher.group(2);
            if (string2.equalsIgnoreCase("k")) {
                l *= 1024L;
            } else if (string2.equalsIgnoreCase("M")) {
                l *= 0x100000L;
            } else if (string2.equalsIgnoreCase("G")) {
                l *= 0x40000000L;
            }
            if (l < 307200L) continue;
            return;
        }
        this.throwGPUConfigurationException("Warning: native thread stack size not set: please set a minimum size of 300k bytes (use -Xmso300k or more), CUDA functionality not enabled");
    }

    private CUDAManager() throws GPUConfigurationException {
        this.handleVerboseProperty();
        this.doSortOnGPU = false;
        this.checkSupportedPlatform();
        if (this.onPower) {
            this.checkStackSize();
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Void run() throws Exception {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            CUDAManager.doGPUSyncAndReset();
                        }
                    });
                    return null;
                }
            });
            this.handleProps();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized CUDAManager getInstance() throws GPUConfigurationException {
        if (singleton == null) {
            singleton = new CUDAManager();
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        System.loadLibrary("ibmgpu");
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                singleton.outputIfVerbose("A problem occurred when loading the required library for IBM GPU support: " + throwable.getLocalizedMessage());
                throw throwable;
            }
            if (CUDAManager.singleton.doSortOnGPU) {
                singleton.checkCUDASupportAndSetUp();
            }
        }
        return singleton;
    }

    private void checkCUDASupportAndSetUp() throws GPUConfigurationException {
        try {
            this.populate();
        }
        catch (Exception exception) {
            this.throwGPUConfigurationException("Warning: could not determine how many CUDA devices available - CUDA functionality not enabled");
        }
        if (!this.hasCUDASupport()) {
            this.throwGPUConfigurationException("Warning: no CUDA driver or CUDA devices could be detected - CUDA functionality not enabled");
        }
        try {
            this.getIdentifiersOfAllDiscoverableCUDADevices();
        }
        catch (NullPointerException nullPointerException) {
            this.throwGPUConfigurationException("Warning: no CUDA devices discovered, CUDA functionality not enabled");
        }
        this.setDefaultDeviceBusyMapping();
    }

    public static void tearDown() {
        singleton = null;
    }

    private boolean getVerboseGPUOutput() {
        return this.verboseGPUOutput;
    }

    public void setVerboseGPU(boolean bl) {
        this.verboseGPUOutput = bl;
    }

    public static final String getVersion() {
        return VERSION;
    }

    public void printAllDeviceInfo() {
        System.out.println("Number of devices: " + this.getDeviceCount());
        for (CUDADevice cUDADevice : devices) {
            System.out.println(cUDADevice);
        }
    }

    private void populate() {
        int n = CUDAManager.getDeviceCountNative();
        devices = new CUDADevice[n];
        for (int i = 0; i < n; ++i) {
            CUDAManager.devices[i] = new CUDADevice(i);
        }
        this.outputIfVerbose("Discovered " + n + " devices");
    }

    public CUDADevice getDevice(int n) throws GPUConfigurationException {
        for (int i = 0; i < this.getDeviceCount(); ++i) {
            this.outputIfVerbose("Found device, ID: " + devices[i].getDeviceID());
        }
        if (n >= this.getDeviceCount()) {
            throw new GPUConfigurationException("Invalid device");
        }
        return devices[n];
    }

    public boolean hasCUDASupport() {
        return this.getDeviceCount() > 0;
    }

    private final synchronized void setDeviceBusy(int n, boolean bl) {
        this.deviceBusyMapping.put(n, bl);
    }

    private final synchronized Boolean getDeviceBusy(int n) {
        return this.deviceBusyMapping.get(n);
    }

    public CUDADevice[] getEnabledCUDADevices() {
        return devices;
    }

    public boolean isSortEnabledOnGPU() {
        return this.doSortOnGPU;
    }

    public boolean isSortEnforcedOnGPU() {
        return this.enforceGPUSort;
    }

    public int getNextAvailableDevice() {
        if (this.getEnabledCUDADevices() != null) {
            for (int i = 0; i < this.getEnabledCUDADevices().length; ++i) {
                int n = this.getEnabledCUDADevices()[i].getDeviceID();
                if (this.getDeviceBusy(n).booleanValue()) continue;
                this.outputIfVerbose("Device " + n + " was free");
                return n;
            }
        }
        this.outputIfVerbose("No free devices!");
        return -1;
    }

    private void setDefaultDeviceBusyMapping() {
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                this.setDeviceBusy(i, false);
            }
        }
    }

    public void setDevice(int n) throws GPUConfigurationException {
        int n2 = CUDAManager.setDeviceNative(n);
        if (n2 < 0 || n2 != n) {
            throw new GPUConfigurationException("Couldn't set the device to: " + n + ", invalid device (unavailable or in use)");
        }
        this.setDefaultDevice(n);
    }

    private int[] getIdentifiersOfAllDiscoverableCUDADevices() {
        int[] nArray = null;
        nArray = new int[devices.length];
        this.outputIfVerbose("Providing identifiers of discovered CUDA devices, found: " + devices.length + " devices");
        for (int i = 0; i < devices.length; ++i) {
            nArray[i] = devices[i].getDeviceID();
        }
        this.outputIfVerbose("Discovered devices have the following identifier(s): ");
        if (this.verboseGPUOutput) {
            this.printIntArray(nArray);
        }
        return nArray;
    }

    private void printIntArray(int[] nArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (i == nArray.length - 1) {
                    System.out.print(nArray[i]);
                    continue;
                }
                System.out.print(nArray[i] + ", ");
            }
        } else {
            System.out.print("No devices discovered");
        }
        System.out.println();
    }

    private void handleVerboseProperty() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(CUDAManager.verboseGPUOutputPropName);
            }
        });
        if (string != null) {
            this.setVerboseGPU(true);
        }
    }

    private void handleProps() throws GPUConfigurationException {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(CUDAManager.enablePropName);
            }
        });
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(CUDAManager.enforcePropName);
            }
        });
        String string3 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(CUDAManager.disablePropName);
            }
        });
        if (string != null) {
            this.outputIfVerbose("System property com.ibm.gpu.enable=" + string);
            if (string.equalsIgnoreCase("all") || string.equals("")) {
                this.outputIfVerbose("Enabling sort on the GPU");
                this.doSortOnGPU = true;
            } else if (string.equalsIgnoreCase("sort")) {
                this.outputIfVerbose("Enabling sort on the GPU");
                this.doSortOnGPU = true;
            } else {
                throw new GPUConfigurationException("Invalid value \"" + string + "\" given on system property " + enablePropName);
            }
        }
        if (string2 != null) {
            this.outputIfVerbose("System property com.ibm.gpu.enforce=" + string2);
            if (string2.equalsIgnoreCase("all") || string2.equals("")) {
                this.outputIfVerbose("Enforcing sort on the GPU");
                this.doSortOnGPU = true;
                this.enforceGPUSort = true;
            } else if (string2.equalsIgnoreCase("sort")) {
                this.outputIfVerbose("Enforcing sort on the GPU");
                this.doSortOnGPU = true;
                this.enforceGPUSort = true;
            } else {
                throw new GPUConfigurationException("Invalid value \"" + string2 + "\" given on system property " + enforcePropName);
            }
        }
        if (string3 != null) {
            this.outputIfVerbose("System property com.ibm.gpu.disable=" + string3);
            if (string3.equalsIgnoreCase("all") || string3.equals("")) {
                this.outputIfVerbose("Disabling sort on the GPU");
                this.doSortOnGPU = false;
            } else if (string3.equalsIgnoreCase("sort")) {
                this.outputIfVerbose("Disabling sort on the GPU");
                this.doSortOnGPU = false;
            } else {
                throw new GPUConfigurationException("Invalid value \"" + string3 + "\" given on system property " + disablePropName);
            }
        }
    }

    public synchronized int acquireFreeDevice() {
        if (this.getEnabledCUDADevices() != null) {
            for (int i = 0; i < this.getEnabledCUDADevices().length; ++i) {
                int n = this.getEnabledCUDADevices()[i].getDeviceID();
                if (!this.deviceBusyMapping.get(n).booleanValue()) {
                    this.outputIfVerbose("Acquired device: " + n);
                    this.deviceBusyMapping.put(n, true);
                    return n;
                }
                this.outputIfVerbose(n + " is busy");
            }
        }
        this.outputIfVerbose("No available devices found");
        return -1;
    }

    public synchronized void releaseDevice(int n) {
        this.deviceBusyMapping.put(n, false);
        this.outputIfVerbose("Released device: " + n);
    }

    public int getDeviceCount() {
        if (devices == null) {
            return 0;
        }
        int n = devices.length;
        return n;
    }

    public CUDADevice getDeviceWithMostAvailableMemory() throws GPUConfigurationException {
        long l = 0L;
        CUDADevice cUDADevice = null;
        CUDADevice cUDADevice2 = null;
        for (int i = 0; i < this.getDeviceCount(); ++i) {
            cUDADevice2 = this.getDevice(i);
            try {
                long l2 = CUDAManager.getCUDADeviceFreeMemory(cUDADevice2.getDeviceID());
                if (l >= l2) continue;
                l = l2;
                cUDADevice = cUDADevice2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cUDADevice;
    }

    public ArrayList<CUDADevice> getCUDADevices() {
        ArrayList<CUDADevice> arrayList = new ArrayList<CUDADevice>();
        for (int i = 0; i < this.getDeviceCount(); ++i) {
            arrayList.add(devices[i]);
        }
        return arrayList;
    }

    protected void outputIfVerbose(String string) {
        if (this.getVerboseGPUOutput()) {
            System.out.println("[IBM GPU]: [time.ms=" + System.currentTimeMillis() + "]: " + string);
        }
    }

    public int getDefaultDevice() {
        return this.DEFAULT_DEVICE;
    }

    public void setDefaultDevice(int n) {
        this.DEFAULT_DEVICE = n;
    }

    private static native void doGPUSyncAndReset();

    private static native int getDeviceCountNative();

    private static native int setDeviceNative(int var0);

    public long getFreeMemoryForDevice(int n) throws GPUConfigurationException {
        long l = CUDAManager.getCUDADeviceFreeMemory(n);
        switch ((int)l) {
            case -1: {
                CUDAManager.getInstance().throwGPUConfigurationException("Couldn't get a handle to the requested GPU (id: " + n + ", unable to get free memory amount");
            }
            case -2: {
                CUDAManager.getInstance().throwGPUConfigurationException("cuMemGetInfo function failed, unable to get free memory amount");
            }
        }
        return l;
    }

    private static native long getCUDADeviceFreeMemory(int var0);

    static {
        testArg = null;
        singleton = null;
    }
}

