/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.wizardry;

import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.KeepDownloadedArtifactDlg;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.listeners.CancelButtonStateEvent;
import com.ibm.cic.common.ui.listeners.CancelEvent;
import com.ibm.cic.common.ui.listeners.ICancelButtonStateListener;
import com.ibm.cic.common.ui.listeners.ICancelStatusListener;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractCicWizard
extends Wizard
implements UserFeedbackProvider {
    protected FormToolkit toolkit;
    private final String finishReturnViewId;
    private final String defaultPageTitle;
    private boolean hasDownloadActivities = true;
    private boolean allowExit = true;
    private boolean displaySuspend = true;
    private final List cancelStatusListeners = new ArrayList();
    private final List cancelButtonStateListeners = new ArrayList();
    protected boolean isKeepFetchedFilesInvoked = false;

    public AbstractCicWizard(String finishReturnViewId, String defaultTitle, ImageDescriptor titleImageDescriptor) {
        this.finishReturnViewId = finishReturnViewId;
        this.defaultPageTitle = defaultTitle;
        if (titleImageDescriptor != null) {
            this.setDefaultPageImageDescriptor(titleImageDescriptor);
        }
        this.setForcePreviousAndNextButtons(true);
    }

    public void setToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public String getReturnViewId() {
        return this.finishReturnViewId;
    }

    public IWizardPage[] getPrimaryPages() {
        return null;
    }

    public abstract IWizardPage getCompletionPage(IStatus var1);

    public String getCompletionPageFinishLabel() {
        return Messages.AbstractCicWizardView_button_done;
    }

    public String getFinishLabel() {
        return com.ibm.cic.common.ui.internal.licensePanel.Messages.Wizard_FinishButtonLabel;
    }

    public String getDefaultPageTitle() {
        return this.defaultPageTitle;
    }

    public boolean performDone() {
        return true;
    }

    public boolean performFinish() {
        return false;
    }

    public boolean hasDownloadActivities() {
        return this.hasDownloadActivities;
    }

    public void setHasDownloadActivites(boolean hasDownload) {
        this.hasDownloadActivities = hasDownload;
    }

    protected String getUserFeedbackTitle() {
        return Messages.CicWizard_warningTitle;
    }

    protected String getDefaultUserFeedbackMessage() {
        return Messages.CicWizard_warningMessage;
    }

    public boolean confirmWithUser(final IStatus status, final boolean statusHasConfirmMessage) {
        final boolean[] result = new boolean[1];
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (status.matches(2)) {
                    String msg;
                    String string = msg = statusHasConfirmMessage ? null : AbstractCicWizard.this.getDefaultUserFeedbackMessage();
                    if (status.getCode() == Integer.MAX_VALUE) {
                        WrapDetailUIDErrorDialog dialog = new WrapDetailUIDErrorDialog(AbstractCicWizard.this.getShell(), Messages.CicWizard_warningTitle, msg, status, 2);
                        dialog.open();
                        result[0] = true;
                    } else {
                        YesNoErrorDialog dialog = new YesNoErrorDialog(AbstractCicWizard.this.getShell(), AbstractCicWizard.this.getUserFeedbackTitle(), msg, status, 2);
                        result[0] = dialog.open() == 2;
                    }
                }
            }
        });
        return result[0];
    }

    public boolean confirmCancelWithUser(final String msg) {
        final boolean[] result = new boolean[1];
        final Shell shell = this.getShell();
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)Messages.ConfirmCancelDlgTitle, (String)(msg != null ? msg : Messages.ConfirmCancelDlgMsg));
            }
        });
        this.notifyCancelStatusEvent(new CancelEvent(result[0]));
        return result[0];
    }

    protected String getStatusMessage(IStatus status) {
        if (status.matches(8)) {
            return Messages.ActionCanceledMsg;
        }
        return Messages.ActionFailedMsg;
    }

    protected String getKeepDownloadedMessage() {
        return Messages.KeepDownloadedDlgMsg;
    }

    protected String getKeepDownloadedDlgTitle(IStatus status) {
        if (status.matches(8)) {
            return Messages.ActionCanceledTitle;
        }
        return Messages.ActionFailedTitle;
    }

    public boolean keepDownloadedArtifacts(IStatus status, int downloadedCount, long downloadedSize) {
        String size = FormatUtil.formatBytes((long)downloadedSize);
        final boolean[] result = new boolean[1];
        final Shell shell = this.getShell();
        final String title = this.getKeepDownloadedDlgTitle(status);
        String message = this.getStatusMessage(status);
        final String keepDownloadedFilesMsg = NLS.bind((String)this.getKeepDownloadedMessage(), (Object[])new Object[]{downloadedCount, size});
        final CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(CicCommonUiPlugin.getPluginId(), 0, 0, null, null, message);
        multiStatus.add(status);
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                KeepDownloadedArtifactDlg dlg = new KeepDownloadedArtifactDlg(shell, title, null, (IStatus)multiStatus, 14, keepDownloadedFilesMsg);
                dlg.open();
                result[0] = dlg.keepDownloadedFiles();
            }
        });
        this.isKeepFetchedFilesInvoked = true;
        return result[0];
    }

    public boolean isKeepFetchedFilesInvoked() {
        return this.isKeepFetchedFilesInvoked;
    }

    public void setCheating(boolean cheating) {
    }

    public boolean isAllowExit() {
        return this.allowExit;
    }

    public void setAllowExit(boolean allowExit) {
        this.allowExit = allowExit;
    }

    public boolean isDisplaySuspend() {
        return this.displaySuspend;
    }

    public void setDisplaySuspend(boolean displaySuspend) {
        this.displaySuspend = displaySuspend;
    }

    public void dispose() {
        this.cancelStatusListeners.clear();
        this.cancelButtonStateListeners.clear();
        super.dispose();
    }

    public void addCancelStatusListener(ICancelStatusListener listener) {
        if (!this.cancelStatusListeners.contains(listener)) {
            this.cancelStatusListeners.add(listener);
        }
    }

    public void removeCancelStatusListener(ICancelStatusListener listener) {
        this.cancelStatusListeners.remove(listener);
    }

    private void notifyCancelStatusEvent(CancelEvent event) {
        int i = 0;
        while (i < this.cancelStatusListeners.size()) {
            ICancelStatusListener listener = (ICancelStatusListener)this.cancelStatusListeners.get(i);
            listener.notify(event);
            ++i;
        }
    }

    public void addCancelButtonStateListener(ICancelButtonStateListener listener) {
        if (!this.cancelButtonStateListeners.contains(listener)) {
            this.cancelButtonStateListeners.add(listener);
        }
    }

    public void removeCancelButtonStateListener(ICancelButtonStateListener listener) {
        this.cancelButtonStateListeners.remove(listener);
    }

    protected Boolean notifyCancelButtonStateChanged(CancelButtonStateEvent event) {
        if (this.cancelButtonStateListeners.size() > 0) {
            ICancelButtonStateListener listener = (ICancelButtonStateListener)this.cancelButtonStateListeners.get(0);
            return listener.notifyCancelButtonState(event);
        }
        return Boolean.TRUE;
    }
}

