/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.views;

import com.ibm.cic.common.ui.internal.CommonImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BackgroundHandler
implements DisposeListener,
ControlListener,
Listener {
    private Composite parent;
    private Image backgroundImage;
    private Image adornmentImage;
    private Image image;
    private Point parentSize;
    private Point adornmentSize;

    public BackgroundHandler(Composite parent, ImageDescriptor bg, ImageDescriptor ad) {
        if (bg != null) {
            this.parent = parent;
            this.parentSize = new Point(0, 0);
            this.backgroundImage = CommonImages.createBackgroundImage(bg);
            parent.addDisposeListener((DisposeListener)this);
            if (ad == null) {
                parent.setBackgroundImage(this.backgroundImage);
            } else {
                this.adornmentImage = ad.createImage();
                Rectangle bounds = this.adornmentImage.getBounds();
                this.adornmentSize = new Point(bounds.width, bounds.height);
                parent.getShell().addControlListener((ControlListener)this);
                parent.addListener(9, (Listener)this);
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.disposeImage(this.backgroundImage);
        this.disposeImage(this.adornmentImage);
        this.disposeImage(this.image);
    }

    private void disposeImage(Image im) {
        if (im != null && !im.isDisposed()) {
            im.dispose();
        }
    }

    public void controlResized(ControlEvent e) {
        ((Composite)e.widget).redraw();
    }

    public void controlMoved(ControlEvent e) {
    }

    public void paintControl(Event e) {
        Control ctrl = (Control)e.widget;
        Point ctrlSize = ctrl.getSize();
        if (this.parentSize.x == ctrlSize.x && this.parentSize.y == ctrlSize.y) {
            return;
        }
        this.parentSize = ctrlSize;
        int x = this.parentSize.x - this.adornmentSize.x;
        int y = this.parentSize.y - this.adornmentSize.y;
        this.disposeImage(this.image);
        this.image = new Image((Device)e.display, this.backgroundImage, 0);
        GC imageGC = new GC((Drawable)this.parent);
        imageGC.drawImage(this.adornmentImage, x, y);
        imageGC.dispose();
        this.parent.setBackgroundImage(this.image);
    }

    public void handleEvent(Event event) {
        if (event.type == 9) {
            this.paintControl(event);
        }
    }
}

