/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.parts;

import com.ibm.icu.text.BreakIterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ImageDesHyperlink
extends Hyperlink {
    public int textSpacing = 5;
    private Image image;
    private Image hoverImage;
    private Image activeImage;
    private Image disabledImage;
    private int state;
    private static final int HOVER = 2;
    private static final int ACTIVE = 4;
    private int verticalAlignment = 0x1000000;
    private int horizontalAlignment = 16384;
    private String description;
    private Font descriptionFont;
    private Color descriptionColor;
    private static final int descriptionIndent = 2;

    public ImageDesHyperlink(Composite parent, int style) {
        super(parent, ImageDesHyperlink.removeAlignment(style));
        this.extractAlignment(style);
    }

    protected void paintHyperlink(GC gc) {
        this.paintHyperlink(gc, this.getClientArea());
    }

    protected void paintHyperlink(GC gc, Rectangle bounds) {
        Image img = null;
        if ((this.state & 4) != 0) {
            img = this.activeImage;
        } else if ((this.state & 2) != 0) {
            img = this.hoverImage;
        }
        if (img == null) {
            img = this.image;
        }
        Rectangle ibounds = img != null ? img.getBounds() : new Rectangle(0, 0, 0, 0);
        Point maxsize = this.computeMaxImageSize();
        int spacing = img != null ? this.textSpacing : 0;
        int textWidth = bounds.width - maxsize.x - spacing - this.marginWidth - this.marginWidth;
        int y = bounds.y + this.marginHeight + maxsize.y / 2 - ibounds.height / 2;
        if (this.horizontalAlignment == 16384) {
            int x = bounds.x + this.marginWidth + maxsize.x / 2 - ibounds.width / 2;
            int textX = bounds.x + this.marginWidth + maxsize.x + spacing;
            if (img != null) {
                gc.drawImage(img, x, y);
            }
            if (this.getText() != null) {
                this.drawText(gc, bounds, textX, textWidth);
            }
        } else if (this.horizontalAlignment == 131072) {
            int x = bounds.x + this.marginWidth;
            if (this.getText() != null) {
                x += this.drawText(gc, bounds, x, textWidth);
            }
            x += maxsize.x / 2 - ibounds.width / 2 + spacing;
            if (img != null) {
                gc.drawImage(img, x, y);
            }
        }
    }

    private int drawText(GC gc, Rectangle clientArea, int textX, int textWidth) {
        Point textSize = this.computeTextSize(textWidth, -1);
        Point descriptionSize = this.computeDescriptionSize(textWidth - 2, -1);
        int slotHeight = clientArea.height - this.marginHeight - this.marginHeight;
        textWidth = textSize.x;
        int textHeight = textSize.y;
        int desWidth = descriptionSize.x;
        int desHeight = descriptionSize.y;
        int textY = this.verticalAlignment == 1024 ? this.marginHeight + slotHeight - textHeight - desHeight - this.textSpacing : (this.verticalAlignment == 0x1000000 ? this.marginHeight + slotHeight / 2 - (textHeight + desHeight + this.textSpacing) / 2 : this.marginHeight);
        this.paintWrapText(gc, this.getText(), new Rectangle(textX, textY, textWidth, textHeight), false);
        int desY = textY + textHeight + this.textSpacing;
        this.paintDescription(gc, new Rectangle(textX + 2, desY, desWidth, desHeight));
        return textWidth;
    }

    protected void paintDescription(GC gc, Rectangle bounds) {
        Font desFont = this.getDescriptionFont();
        if (desFont != null) {
            gc.setFont(desFont);
        } else {
            gc.setFont(this.getFont());
        }
        Color desColor = this.getDescriptionColor();
        if (desColor != null) {
            gc.setForeground(desColor);
        } else {
            gc.setForeground(this.getForeground());
        }
        if ((this.getStyle() & 0x40) != 0) {
            this.paintWrapText(gc, this.getDescription(), bounds, false);
        } else {
            Point totalSize = this.computeDescriptionSize(-1, -1);
            boolean shortenText = false;
            if (bounds.width < totalSize.x) {
                shortenText = true;
            }
            String textToDraw = this.getDescription();
            gc.drawText(textToDraw, bounds.x, bounds.y, true);
        }
    }

    protected Point computeDescriptionSize(int wHint, int hHint) {
        Point extent;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getDescriptionFont());
        if ((this.getStyle() & 0x40) != 0 && wHint != -1) {
            extent = this.computeWrapSize(gc, this.getDescription(), wHint);
        } else {
            extent = gc.textExtent(this.getText());
            if ((this.getStyle() & 0x40) == 0 && wHint != -1) {
                extent.x = wHint;
            }
        }
        gc.dispose();
        return extent;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point isize = this.computeMaxImageSize();
        int spacing = isize.x > 0 ? this.textSpacing : 0;
        Point textSize = null;
        if (this.getText() != null) {
            int innerWHint = wHint;
            if (wHint != -1) {
                innerWHint = wHint - 2 * this.marginWidth - isize.x - spacing;
            }
            textSize = super.computeSize(innerWHint, hHint, changed);
        }
        Point desPoint = null;
        if (this.getDescription() != null) {
            int innerWHint = wHint;
            if (wHint != -1) {
                innerWHint = wHint - 2 * this.marginWidth - isize.x - spacing;
            }
            this.checkWidget();
            if (innerWHint != -1) {
                innerWHint -= this.marginWidth * 2;
            }
            Point desSize = this.computeDescriptionSize(innerWHint - 2, hHint);
            int desWidth = desSize.x + 2 * this.marginWidth;
            int desHeight = desSize.y + 2 * this.marginHeight;
            desPoint = new Point(desWidth, desHeight);
        }
        int width = isize.x;
        int height = isize.y;
        if (textSize != null && desPoint != null) {
            width += spacing;
            width += Math.max(textSize.x, desPoint.x + 2);
            height = Math.max(height, textSize.y + desPoint.y + this.textSpacing);
        }
        return new Point(width += 2 * this.marginWidth, height += 2 * this.marginHeight);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    public void setDescriptionFont(Font descriptionFont) {
        this.descriptionFont = descriptionFont;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public void setDescriptionColor(Color descriptionColor) {
        this.descriptionColor = descriptionColor;
    }

    private void paintWrapText(GC gc, String text, Rectangle bounds, boolean underline) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = fm.getAverageCharWidth();
        int saved = 0;
        int last = 0;
        int y = bounds.y;
        int width = bounds.width;
        int loc = wb.first();
        while (loc != -1) {
            String line = text.substring(saved, loc);
            Point extent = gc.textExtent(line);
            if (extent.x > width) {
                String prevLine = text.substring(saved, last);
                gc.drawText(prevLine, bounds.x, y, true);
                if (underline) {
                    Point prevExtent = gc.textExtent(prevLine);
                    int lineY = y + lineHeight - descent + 1;
                    gc.drawLine(bounds.x, lineY, bounds.x + prevExtent.x, lineY);
                }
                saved = last;
                y += lineHeight;
            }
            last = loc;
            loc = wb.next();
        }
        String lastLine = text.substring(saved, last);
        gc.drawText(lastLine, bounds.x, y, true);
        if (underline) {
            int lineY = y + lineHeight - descent + 1;
            Point lastExtent = gc.textExtent(lastLine);
            gc.drawLine(bounds.x, lineY, bounds.x + lastExtent.x, lineY);
        }
    }

    private Point computeWrapSize(GC gc, String text, int wHint) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int saved = 0;
        int last = 0;
        int height = lineHeight;
        int maxWidth = 0;
        int loc = wb.first();
        while (loc != -1) {
            String word = text.substring(saved, loc);
            Point extent = gc.textExtent(word);
            if (extent.x > wHint) {
                saved = last;
                height += extent.y;
            } else {
                maxWidth = Math.max(maxWidth, extent.x);
            }
            last = loc;
            loc = wb.next();
        }
        return new Point(maxWidth, height);
    }

    protected void handleEnter(Event e) {
        this.state = 2;
        super.handleEnter(e);
    }

    protected void handleExit(Event e) {
        this.state = 0;
        super.handleExit(e);
    }

    protected void handleActivate(Event e) {
        this.state &= 4;
        this.redraw();
        super.handleActivate(e);
        this.state &= 0xFFFFFFFB;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public Image getActiveImage() {
        return this.activeImage;
    }

    public void setActiveImage(Image activeImage) {
        this.activeImage = activeImage;
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public void setHoverImage(Image hoverImage) {
        this.hoverImage = hoverImage;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private Point computeMaxImageSize() {
        int x = 0;
        int y = 0;
        if (this.image != null) {
            x = Math.max(this.image.getBounds().width, x);
            y = Math.max(this.image.getBounds().height, y);
        }
        if (this.hoverImage != null) {
            x = Math.max(this.hoverImage.getBounds().width, x);
            y = Math.max(this.hoverImage.getBounds().height, y);
        }
        if (this.activeImage != null) {
            x = Math.max(this.activeImage.getBounds().width, x);
            y = Math.max(this.activeImage.getBounds().height, y);
        }
        return new Point(x, y);
    }

    private static int removeAlignment(int style) {
        int resultStyle = style;
        if ((style & 0x1000000) != 0) {
            resultStyle &= 0xFEFFFFFF;
        }
        if ((style & 0x80) != 0) {
            resultStyle &= 0xFFFFFF7F;
        }
        if ((style & 0x400) != 0) {
            resultStyle &= 0xFFFFFBFF;
        }
        if ((style & 0x4000) != 0) {
            resultStyle &= 0xFFFFBFFF;
        }
        if ((style & 0x20000) != 0) {
            resultStyle &= 0xFFFDFFFF;
        }
        return resultStyle;
    }

    private void extractAlignment(int style) {
        if ((style & 0x1000000) != 0) {
            this.verticalAlignment = 0x1000000;
        } else if ((style & 0x80) != 0) {
            this.verticalAlignment = 128;
        } else if ((style & 0x400) != 0) {
            this.verticalAlignment = 1024;
        }
        if ((style & 0x4000) != 0) {
            this.horizontalAlignment = 16384;
        } else if ((style & 0x20000) != 0) {
            this.horizontalAlignment = 131072;
        }
    }

    public void setEnabled(boolean enabled) {
        if (!(enabled || this.disabledImage != null && !this.disabledImage.isDisposed() || this.image == null || this.image.isDisposed())) {
            this.disabledImage = new Image(this.image.getDevice(), this.image, -1);
        }
        super.setEnabled(enabled);
        if (enabled && this.disabledImage != null) {
            this.disabledImage.dispose();
            this.disabledImage = null;
        }
    }
}

