/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.ui.internal.model.ITreeNode;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProperties {
    private final IStructuredSelection selection;
    private final boolean isEmpty;
    private final boolean isHomogenous;
    private final Object homogenousObject;
    private final boolean isSingle;
    private final ITreeNode singleNode;
    private List objects;

    public SelectionProperties(Object[] treeNodeArray) {
        this((IStructuredSelection)new StructuredSelection(treeNodeArray));
    }

    public SelectionProperties(ISelection selection) {
        this((IStructuredSelection)selection);
    }

    public SelectionProperties(IStructuredSelection selection) {
        this.selection = selection;
        Hashtable class2count = this.examineSelection();
        this.isEmpty = class2count.size() == 0;
        this.isHomogenous = class2count.keySet().size() == 1;
        this.homogenousObject = this.isHomogenous ? ((ITreeNode)selection.getFirstElement()).getObject() : null;
        this.isSingle = this.isHomogenous && (Integer)class2count.values().iterator().next() == 1;
        this.singleNode = this.isSingle ? (ITreeNode)selection.getFirstElement() : null;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public List getObjects() {
        if (this.objects == null) {
            this.objects = new Vector();
            for (ITreeNode node : this.selection) {
                this.objects.add(node.getObject());
            }
        }
        return this.objects;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isHomogenous() {
        return this.isHomogenous;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Object getHomogenousObject() {
        return this.homogenousObject;
    }

    public ITreeNode getSingleNode() {
        return this.singleNode;
    }

    private Hashtable examineSelection() {
        Hashtable map = new Hashtable();
        if (this.selection == null) {
            return map;
        }
        for (ITreeNode node : this.selection) {
            Object content = node.getObject();
            Class<?> contentClass = content.getClass();
            Integer count = (Integer)map.get(contentClass);
            if (count == null) {
                count = 0;
            }
            map.put(contentClass, count + 1);
        }
        return map;
    }
}

