/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.ui.extensions;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.ws.sync.core.SyncEngine;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.internal.ui.Messages;
import com.ibm.ws.sync.ui.extensions.ImportWASCommonLocationPage;
import com.ibm.ws.sync.ui.extensions.ImportWASCompletionPage;
import com.ibm.ws.sync.ui.extensions.ImportWASSummaryPage;
import com.ibm.ws.sync.ui.extensions.ImportWASWizardPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportWASWizard
extends AgentUIWizard {
    private IWizardPage[] primaryPages;
    private ImageDescriptor imageDescriptor;
    private CompletionPage completionPage;
    private Profile synchronizedProfile = null;
    private SyncLocation syncLocation = null;
    private IStatus syncResult;
    private boolean shouldSkipCommonLocationPage = true;

    public ImportWASWizard() {
        this(null, Messages.ImportWAS_defaultTitle, null);
        this.setHasDownloadActivites(false);
    }

    public ImportWASWizard(String finishReturnViewId, String defaultTitle, ImageDescriptor titleImageDescriptor) {
        super(finishReturnViewId, defaultTitle, titleImageDescriptor);
        this.setHasDownloadActivites(false);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.ws.sync.ui", (String)"icons/qs_images/import_was_wiz.png");
        }
        return this.imageDescriptor;
    }

    public IWizardPage getCompletionPage(IStatus completionStatus) {
        if (this.completionPage == null) {
            this.completionPage = this.createCompletionPage(completionStatus);
        }
        return this.completionPage;
    }

    public String getFinishLabel() {
        return Messages.ImportWAS_finishButtonLabel;
    }

    private IWizardPage[] createPrimaryPages() {
        ImportWASWizardPage p = new ImportWASWizardPage();
        p.setDescription(Messages.ImportWAS_profilesDescription);
        p.setHelpRef("com.ibm.cic.agent.ui.ImportInstallationLocationPage");
        p.setImageDescriptor(this.getImageDescriptor());
        return new IWizardPage[]{p};
    }

    public IWizardPage[] getPrimaryPages() {
        if (this.primaryPages == null) {
            this.primaryPages = this.createPrimaryPages();
        }
        return this.primaryPages;
    }

    public void addPages() {
        ImportWASCommonLocationPage commonLocationPage;
        if (this.primaryPages == null) {
            this.primaryPages = this.createPrimaryPages();
        }
        if (this.primaryPages != null) {
            IWizardPage[] iWizardPageArray = this.primaryPages;
            int n = this.primaryPages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage primaryPage = iWizardPageArray[n2];
                this.addPage(primaryPage);
                ++n2;
            }
        }
        if (!(commonLocationPage = new ImportWASCommonLocationPage(this.toolkit, this, com.ibm.cic.agent.internal.ui.Messages.CommonLocationPage_description)).shouldSkip()) {
            commonLocationPage.setHelpRef("com.ibm.cic.agent.ui.CommonLocationPage");
            commonLocationPage.setImageDescriptor(this.getImageDescriptor());
            this.addPage((IWizardPage)commonLocationPage);
            this.shouldSkipCommonLocationPage = false;
        }
        ImportWASSummaryPage summaryPage = new ImportWASSummaryPage(this.toolkit, this);
        summaryPage.setImageDescriptor(this.getImageDescriptor());
        this.addPage((IWizardPage)summaryPage);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.synchronizedProfile = this.synchronize();
        return false;
    }

    public CompletionPage createCompletionPage(IStatus completionStatus) {
        ImportWASCompletionPage cp = new ImportWASCompletionPage(CicCommonUiPlugin.getDefault().getFormToolkit(), "", "", this, this.syncResult);
        cp.setImageDescriptor(this.getImageDescriptor());
        return cp;
    }

    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        return null;
    }

    protected String getRestartMessage() {
        return null;
    }

    protected WizardType getWizardType() {
        return null;
    }

    protected IStatus performTask(IProgressMonitor monitor) {
        return null;
    }

    public void setInput(Object[] items) {
    }

    public Profile getSynchronizedProfile() {
        return this.synchronizedProfile;
    }

    public String getDefaultCommonLocation() {
        if (this.primaryPages.length > 0) {
            ImportWASWizardPage primaryPage = (ImportWASWizardPage)this.primaryPages[0];
            return primaryPage.getDefaultCommonLocation();
        }
        return null;
    }

    public SyncLocation getSyncLocation() {
        return this.syncLocation;
    }

    public void setSyncLocation(SyncLocation syncLocation) {
        this.syncLocation = syncLocation;
    }

    public boolean shouldSkipCommonLocationPage() {
        return this.shouldSkipCommonLocationPage;
    }

    private Profile synchronize() {
        final SyncEngine se = new SyncEngine(Agent.getInstance());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.ImportWAS_importing, 10);
                ImportWASWizard.this.syncResult = se.performSynchronization(ImportWASWizard.this.syncLocation, monitor);
                monitor.worked(9);
                if (ImportWASWizard.this.syncResult.getSeverity() == 0) {
                    Profile[] profile = Agent.getInstance().getProfiles();
                    int found = -1;
                    File syncLocationFile = new File(ImportWASWizard.this.syncLocation.getLocation());
                    int p = 0;
                    while (p < profile.length) {
                        String installLocation = profile[p].getInstallLocation();
                        File installedLocation = new File(installLocation);
                        if (installedLocation.equals(syncLocationFile)) {
                            found = p;
                            break;
                        }
                        ++p;
                    }
                    if (found >= 0) {
                        ImportWASWizard.this.synchronizedProfile = profile[found];
                    } else {
                        ImportWASWizard.this.syncResult = (IStatus)new Status(4, "com.ibm.ws.sync.ui", Messages.ImportWAS_result_fail);
                    }
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            this.syncResult = new Status(4, "com.ibm.ws.sync.ui", Messages.ImportWAS_unknown_exception);
            Throwable throwable = e.getCause();
            AgentUI.reportException((Throwable)throwable);
        }
        catch (InterruptedException e) {
            this.syncResult = new Status(4, "com.ibm.ws.sync.ui", Messages.ImportWAS_unknown_exception);
            AgentUI.reportException((Throwable)e);
        }
        return this.synchronizedProfile;
    }
}

