/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;

public final class AccessControlContext {
    static int STATE_NOT_AUTHORIZED = 0;
    static int STATE_AUTHORIZED = 1;
    static int STATE_UNKNOWN = 2;
    static int debugSetting = -1;
    DomainCombiner domainCombiner;
    ProtectionDomain[] context;
    int authorizeState = STATE_UNKNOWN;
    private boolean containPrivilegedContext = false;
    private ProtectionDomain callerPD;
    private static final SecurityPermission createAccessControlContext = new SecurityPermission("createAccessControlContext");
    private static final SecurityPermission getDomainCombiner = new SecurityPermission("getDomainCombiner");
    static final int DEBUG_ACCESS = 1;
    static final int DEBUG_ACCESS_STACK = 2;
    static final int DEBUG_ACCESS_DOMAIN = 4;
    static final int DEBUG_ACCESS_FAILURE = 8;
    static final int DEBUG_ACCESS_THREAD = 16;
    static final int DEBUG_ALL = 255;

    static int debugSetting() {
        if (debugSetting != -1) {
            return debugSetting;
        }
        debugSetting = 0;
        boolean access = false;
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        if (value == null) {
            return debugSetting;
        }
        int start = 0;
        int length = value.length();
        while (start < length) {
            String keyword;
            int index = value.indexOf(44, start);
            if (index == -1) {
                index = length;
            }
            if ((keyword = value.substring(start, index)).equals("all")) {
                debugSetting = 255;
                return debugSetting;
            }
            if (keyword.startsWith("access")) {
                debugSetting |= 1;
                if (start + 6 < length && value.charAt(start + 6) == ':') {
                    index = start + 6;
                    access = true;
                }
            } else if (access && keyword.equals("stack")) {
                debugSetting |= 2;
            } else if (access && keyword.equals("domain")) {
                debugSetting |= 4;
            } else if (access && keyword.equals("failure")) {
                debugSetting |= 8;
            } else if (access && keyword.equals("thread")) {
                debugSetting |= 0x10;
            } else {
                access = false;
            }
            start = index + 1;
        }
        return debugSetting;
    }

    static void debugPrintAccess() {
        System.err.print("access: ");
        if ((AccessControlContext.debugSetting() & 0x10) == 16) {
            System.err.print("(" + Thread.currentThread() + ")");
        }
    }

    public AccessControlContext(ProtectionDomain[] fromContext) {
        int length = fromContext.length;
        if (length == 0) {
            this.context = null;
        } else {
            int domainIndex = 0;
            this.context = new ProtectionDomain[length];
            block0: for (int i = 0; i < length; ++i) {
                ProtectionDomain current = fromContext[i];
                if (current == null) continue;
                for (int j = 0; j < i; ++j) {
                    if (current == this.context[j]) continue block0;
                }
                this.context[domainIndex++] = current;
            }
            if (domainIndex == 0) {
                this.context = null;
            } else if (domainIndex != length) {
                ProtectionDomain[] copy = new ProtectionDomain[domainIndex];
                System.arraycopy((Object)this.context, 0, (Object)copy, 0, domainIndex);
                this.context = copy;
            }
        }
    }

    AccessControlContext(ProtectionDomain[] context, int authorizeState, ProtectionDomain callerPD) {
        this.context = context;
        this.authorizeState = authorizeState;
        this.containPrivilegedContext = true;
        if (STATE_UNKNOWN == authorizeState) {
            this.callerPD = callerPD;
        }
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(createAccessControlContext);
        }
        this.authorizeState = STATE_AUTHORIZED;
        this.context = acc.context;
        this.domainCombiner = combiner;
        this.containPrivilegedContext = acc.containPrivilegedContext;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        int i;
        if (perm == null) {
            throw new NullPointerException();
        }
        if (null != this.context && STATE_AUTHORIZED != this.authorizeState && this.containPrivilegedContext && null != System.getSecurityManager()) {
            if (STATE_UNKNOWN == this.authorizeState) {
                this.authorizeState = null == this.callerPD || this.callerPD.implies(createAccessControlContext) ? STATE_AUTHORIZED : STATE_NOT_AUTHORIZED;
                this.callerPD = null;
            }
            if (STATE_NOT_AUTHORIZED == this.authorizeState) {
                throw new AccessControlException(Msg.getString("K002d", perm, createAccessControlContext), perm);
            }
        }
        if ((AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (this.context == null || this.context.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (i = 0; i < this.context.length; ++i) {
                    System.err.println("domain " + i + " " + this.context[i]);
                }
            }
        }
        int n = i = this.context == null ? 0 : this.context.length;
        while (--i >= 0 && this.context[i].implies(perm)) {
        }
        if (i >= 0) {
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("access denied " + perm);
            }
            if ((AccessControlContext.debugSetting() & 8) != 0) {
                new Exception("Stack trace").printStackTrace();
                System.err.println("domain that failed " + this.context[i]);
            }
            throw new AccessControlException(Msg.getString("K002c", perm), perm);
        }
        if ((AccessControlContext.debugSetting() & 1) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
        }
    }

    public boolean equals(Object o) {
        int olength;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlContext otherContext = (AccessControlContext)o;
        ProtectionDomain[] otherDomains = otherContext.context;
        int length = this.context == null ? 0 : this.context.length;
        int n = olength = otherDomains == null ? 0 : otherDomains.length;
        if (length != olength) {
            return false;
        }
        block0: for (int i = 0; i < length; ++i) {
            ProtectionDomain current = this.context[i];
            for (int j = 0; j < length; ++j) {
                if (current == otherDomains[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int result = 0;
        int n = i = this.context == null ? 0 : this.context.length;
        while (--i >= 0) {
            result ^= this.context[i].hashCode();
        }
        return result;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(getDomainCombiner);
        }
        return this.domainCombiner;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    AccessControlContext(ProtectionDomain[] domains, AccessControlContext acc) {
        int len = 0;
        int size = domains == null ? 0 : domains.length;
        int extra = 0;
        if (acc != null && acc.context != null) {
            extra = acc.context.length;
        }
        ProtectionDomain[] answer = new ProtectionDomain[size + extra];
        for (int i = 0; i < size; ++i) {
            boolean found = false;
            answer[len] = domains[i];
            if (answer[len] == null) break;
            if (acc != null && acc.context != null) {
                for (int j = 0; j < acc.context.length; ++j) {
                    if (answer[len] != acc.context[j]) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            ++len;
        }
        if (len == 0 && acc != null) {
            this.context = acc.context;
        } else if (len + extra == 0) {
            this.context = null;
        } else {
            if (len < size) {
                ProtectionDomain[] copy = new ProtectionDomain[len + extra];
                System.arraycopy((Object)answer, 0, (Object)copy, 0, len);
                answer = copy;
            }
            if (acc != null && acc.context != null) {
                System.arraycopy((Object)acc.context, 0, (Object)answer, len, acc.context.length);
            }
            this.context = answer;
        }
        this.authorizeState = STATE_AUTHORIZED;
        this.containPrivilegedContext = true;
    }

    AccessControlContext optimize() {
        return this;
    }
}

