/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithInt;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.reflect.Array;

final class CollectHandle
extends MethodHandle {
    final MethodHandle next;
    final int collectArraySize;
    private static final ThunkTable _thunkTable = new ThunkTable();

    CollectHandle(MethodHandle next, int collectArraySize) {
        super(CollectHandle.collectMethodType(next.type(), collectArraySize), null, null, 10, collectArraySize);
        this.collectArraySize = collectArraySize;
        this.next = next;
        this.vmSlot = 0L;
    }

    CollectHandle(CollectHandle original, MethodType newType) {
        super(original, newType);
        this.collectArraySize = original.collectArraySize;
        this.next = original.next;
        this.vmSlot = original.vmSlot;
    }

    private static final MethodType collectMethodType(MethodType type, int collectArraySize) {
        if (type.parameterCount() == 0) {
            throw new IllegalArgumentException("last argument of MethodType must be an array class");
        }
        Class<?> arrayComponent = type.arguments[type.parameterCount() - 1].getComponentType();
        if (arrayComponent == null) {
            throw new IllegalArgumentException("last argument of MethodType must be an array class");
        }
        MethodType newType = type.changeParameterType(type.parameterCount() - 1, arrayComponent);
        if (collectArraySize == 0) {
            newType = newType.dropParameterTypes(type.parameterCount() - 1, type.parameterCount());
        } else if (collectArraySize > 1) {
            Class[] classes = new Class[collectArraySize - 1];
            for (int j = 0; j < classes.length; ++j) {
                classes[j] = arrayComponent;
            }
            newType = newType.insertParameterTypes(newType.parameterCount(), classes);
        }
        return newType;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new CollectHandle(this, newType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object arg) {
        int collectArraySize = (Integer)arg;
        return this.thunkTable().get(new ThunkKeyWithInt(ThunkKey.computeThunkableSignature(this.type().toMethodDescriptorString()), collectArraySize));
    }

    private final Object allocateArray() {
        return Array.newInstance(this.next.type().parameterType(this.next.type().parameterCount() - 1).getComponentType(), this.collectArraySize);
    }

    private static native int numArgsToPassThrough();

    private static native int numArgsToCollect();

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(int argPlaceholder) throws Throwable {
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        ILGenMacros.invokeExact_V(this.next, ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L());
    }

    @MethodHandle.Invisible
    private final int invokeExact_thunkArchetype_I(int argPlaceholder) throws Throwable {
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_I(this.next, ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L());
    }

    @MethodHandle.Invisible
    private final long invokeExact_thunkArchetype_J(int argPlaceholder) throws Throwable {
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_J(this.next, ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L());
    }

    @MethodHandle.Invisible
    private final float invokeExact_thunkArchetype_F(int argPlaceholder) throws Throwable {
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_F(this.next, ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L());
    }

    @MethodHandle.Invisible
    private final double invokeExact_thunkArchetype_D(int argPlaceholder) throws Throwable {
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_D(this.next, ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L());
    }

    @MethodHandle.Invisible
    private final Object invokeExact_thunkArchetype_L(int argPlaceholder) throws Throwable {
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_L(this.next, ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L());
    }
}

