/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.javaSE.IPC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;

class Reply {
    private RandomAccessFile replyChannelRAF;
    private String key;
    private Integer portNumber;
    private final File replyFile;
    static final long ROOT_UID = 0L;
    static final int REPLY_PERMISSIONS = 384;
    static final String REPLY_FILENAME = "replyInfo";
    final long targetUid;

    Reply(Integer thePort, String theKey, String targetDirectory, long theUid) {
        this.portNumber = thePort;
        this.key = theKey;
        this.targetUid = theUid;
        this.replyFile = new File(targetDirectory, REPLY_FILENAME);
    }

    Reply(String notificationDirectory) {
        this.targetUid = 0L;
        this.replyFile = new File(notificationDirectory, REPLY_FILENAME);
    }

    void writeReply() throws IOException {
        try {
            IPC.logMessage("writing reply file port=", this.portNumber, " file path=", this.replyFile.getAbsolutePath());
            this.replyChannelRAF = new RandomAccessFile(this.replyFile, "rw");
            this.replyChannelRAF.setLength(0L);
            this.replyChannelRAF.writeBytes(this.key);
            this.replyChannelRAF.writeByte(10);
            this.replyChannelRAF.writeBytes(this.portNumber.toString());
            this.replyChannelRAF.writeByte(10);
            this.replyChannelRAF.close();
            IPC.chmod(this.replyFile.getAbsolutePath(), 384);
            long myUid = IPC.getUid();
            if (0L == myUid && 0L != this.targetUid) {
                IPC.chownFileToTargetUid(this.replyFile.getAbsolutePath(), this.targetUid);
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException(Msg.getString("K0552", this.replyFile.getAbsolutePath()), e);
        }
    }

    static Reply readReply(String path) throws IOException {
        Reply rply = new Reply(path);
        if (rply.fileDoesNotExist()) {
            return null;
        }
        try {
            BufferedReader replyStream = new BufferedReader(new FileReader(rply.replyFile));
            rply.key = replyStream.readLine();
            String line = replyStream.readLine();
            replyStream.close();
            try {
                rply.portNumber = new Integer(line);
            }
            catch (NumberFormatException e) {
                rply.portNumber = -1;
                throw new IOException(e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException(Msg.getString("K0548", rply.replyFile.getAbsolutePath()), e);
        }
        return rply;
    }

    private boolean fileDoesNotExist() {
        return !this.replyFile.exists();
    }

    synchronized int getPortNumber() {
        return this.portNumber;
    }

    synchronized String getKey() {
        return this.key;
    }

    void deleteReply() {
        if (null != this.replyFile) {
            if (!this.replyFile.delete()) {
                IPC.logMessage("eraseReply could not delete ", this.replyFile.getName());
            } else {
                IPC.logMessage("eraseReply deleted ", this.replyFile.getName());
            }
        }
    }
}

