/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VMLangAccess;
import java.util.HashMap;
import sun.reflect.CallerSensitive;

public final class VM {
    private static String[] cachedVMArgs;
    private static VMLangAccess javalangVMaccess;
    public static final boolean PACKED_SUPPORT_ENABLED = false;
    static final int CPE_TYPE_UNKNOWN = 0;
    static final int CPE_TYPE_DIRECTORY = 1;
    static final int CPE_TYPE_JAR = 2;
    static final int CPE_TYPE_TCP = 3;
    static final int CPE_TYPE_UNUSABLE = 5;

    private VM() {
    }

    @CallerSensitive
    static final native Class getStackClass(int var0);

    @CallerSensitive
    static final native ClassLoader getStackClassLoader(int var0);

    public static final native void initializeClassLoader(ClassLoader var0, boolean var1, boolean var2);

    private static final native boolean isBootstrapClassLoader(ClassLoader var0);

    static native Class findClassOrNull(String var0, ClassLoader var1);

    @CallerSensitive
    private static ClassLoader caller2ClassLoader() {
        ClassLoader loader = VM.getStackClassLoader(3);
        if (VM.isBootstrapClassLoader(loader)) {
            return null;
        }
        return loader;
    }

    public static native void dumpString(String var0);

    public static void setClassPathImpl(ClassLoader classLoader, String classPath) {
    }

    @Deprecated
    public static void enableClassHotSwap(Class hotSwapClass) {
    }

    static native int getCPIndexImpl(Class var0);

    public static void initializeVM() {
    }

    private static void shutdown() {
    }

    static final native int getClassPathEntryType(Object var0, int var1);

    public static String[] getVMArgs() {
        if (cachedVMArgs == null) {
            byte[][] byteArgs = VM.getVMArgsImpl();
            if (byteArgs == null) {
                return null;
            }
            String[] result = new String[byteArgs.length];
            for (int i = 0; i < byteArgs.length; ++i) {
                result[i] = byteArgs[i] == null ? null : Util.toString(byteArgs[i]);
            }
            cachedVMArgs = result;
        }
        return (String[])cachedVMArgs.clone();
    }

    private static native byte[][] getVMArgsImpl();

    static native int getClassPathCount();

    static native byte[] getPathFromClassPath(int var0);

    public static native void localGC();

    public static native void globalGC();

    public static native void runFinalization();

    public static final boolean useNatives() {
        return VM.useNativesImpl();
    }

    private static final native boolean useNativesImpl();

    public static native boolean enableJIT();

    private static native int allInstances(Class var0, Object[] var1);

    private static native int setCommonData(String var0, String var1);

    private static String[] allStrings() {
        int count = VM.allInstances(String.class, null);
        Object[] result = new String[count];
        if (count != 0) {
            VM.allInstances(String.class, result);
        }
        return result;
    }

    public static int removeStringDuplicates() {
        String[] heap = VM.allStrings();
        int stringCount = heap.length;
        int mergedCount = 0;
        HashMap<String, String> uniqueStrings = new HashMap<String, String>();
        for (int n = 0; n < stringCount; ++n) {
            String possibleDuplicate = heap[n];
            heap[n] = null;
            if (possibleDuplicate == null) continue;
            String originalString = (String)uniqueStrings.get(possibleDuplicate);
            if (originalString != null) {
                if (VM.setCommonData(originalString, possibleDuplicate) != 1) continue;
                ++mergedCount;
                continue;
            }
            uniqueStrings.put(possibleDuplicate, possibleDuplicate);
        }
        return mergedCount;
    }

    static native String getClassNameImpl(Class var0);

    public static void setVMLangAccess(VMLangAccess access) {
        if (javalangVMaccess != null) {
            throw new SecurityException("Cannot set access twice");
        }
        javalangVMaccess = access;
    }

    public static VMLangAccess getVMLangAccess() {
        return javalangVMaccess;
    }
}

