/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.URL;

public class SharedClassURLHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLHelper {
    private boolean minimizeUpdateChecks;
    public static final boolean MINIMIZE_ENABLED = true;

    SharedClassURLHelperImpl(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.initialize(loader, id, canFind, canStore);
        this.initializeShareableClassloader(loader);
    }

    private static native void init();

    private native boolean findSharedClassImpl3(int var1, String var2, String var3, ClassLoader var4, URL var5, boolean var6, boolean var7, byte[] var8, boolean var9);

    private native boolean storeSharedClassImpl3(int var1, String var2, ClassLoader var3, URL var4, Class var5, boolean var6, byte[] var7);

    @Override
    public boolean setMinimizeUpdateChecks() {
        this.minimizeUpdateChecks = true;
        return true;
    }

    @Override
    public byte[] findSharedClass(URL path, String className) {
        return this.findSharedClass(null, path, className);
    }

    @Override
    public synchronized byte[] findSharedClass(String partition, URL path, String className) {
        boolean doStore;
        boolean doFind;
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.printVerboseInfo("ClassLoader has been garbage collected. Returning null.");
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (path == null) {
            this.printVerboseError("Cannot call findSharedClass with null URL. Returning null.");
            return null;
        }
        if (className == null) {
            this.printVerboseError("Cannot call findSharedClass with null class name. Returning null.");
            return null;
        }
        SharedClassFilter theFilter = this.getSharingFilter();
        if (theFilter != null) {
            doFind = theFilter.acceptFind(className);
            doStore = nativeFlags[0] == 0 ? theFilter.acceptStore(className) : true;
        } else {
            doFind = true;
            doStore = true;
        }
        URL convertedPath = this.convertJarURL(path);
        if (!this.validateURL(convertedPath, false)) {
            return null;
        }
        byte[] romClassCookie = new byte[this.ROMCLASS_COOKIE_SIZE];
        boolean found = this.findSharedClassImpl3(this.id, partition, className, loader, convertedPath, doFind, doStore, romClassCookie, this.minimizeUpdateChecks);
        if (!found) {
            return null;
        }
        return romClassCookie;
    }

    @Override
    public boolean storeSharedClass(URL path, Class clazz) {
        return this.storeSharedClass(null, path, clazz);
    }

    @Override
    public synchronized boolean storeSharedClass(String partition, URL path, Class clazz) {
        if (!this.canStore) {
            return false;
        }
        if (path == null) {
            this.printVerboseError("Cannot call storeSharedClass with null URL. Returning false.");
            return false;
        }
        if (clazz == null) {
            this.printVerboseError("Cannot call storeSharedClass with null Class. Returning false.");
            return false;
        }
        URL convertedPath = this.convertJarURL(path);
        if (!this.validateURL(convertedPath, false)) {
            return false;
        }
        ClassLoader actualLoader = this.getClassLoader();
        if (!this.validateClassLoader(actualLoader, clazz)) {
            return false;
        }
        return this.storeSharedClassImpl3(this.id, partition, actualLoader, convertedPath, clazz, this.minimizeUpdateChecks, nativeFlags);
    }

    @Override
    String getHelperType() {
        return "SharedClassURLHelper";
    }

    static {
        SharedClassURLHelperImpl.init();
    }
}

