/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.LogPermission;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Log {
    private static final String LEGACY_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyLogSecurity";
    private static final LogPermission LOG_PERMISSION = new LogPermission();

    public static String QueryOptions() {
        Log.checkLegacySecurityPermssion();
        return Log.QueryOptionsImpl();
    }

    public static int SetOptions(String options) {
        Log.checkLegacySecurityPermssion();
        return Log.SetOptionsImpl(options);
    }

    private static void checkLegacySecurityPermssion() throws SecurityException {
        String flag = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(Log.LEGACY_PERMISSION_PROPERTY);
            }
        });
        boolean legacyDumpSecurityEnabled = Boolean.TRUE.toString().equals(flag);
        if (legacyDumpSecurityEnabled) {
            Log.checkLogSecurityPermssion();
        }
    }

    private static void checkLogSecurityPermssion() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(LOG_PERMISSION);
        }
    }

    private Log() {
    }

    private static native String QueryOptionsImpl();

    private static native int SetOptionsImpl(String var0);
}

