/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpEvent {
    private boolean argsValid;
    private boolean configCheck;
    private String event;
    private String lastDump;
    private List<String> dumpList;
    private String uid;
    private String stamp;
    private String pid;
    private String job;
    private boolean noZipFlag;
    private String buildId;
    private File settingsFile;
    private String settingsString;
    private boolean multipleDumps = false;
    private Logger logger;
    private String _CEE_DMPTARG = System.getenv("_CEE_DMPTARG");
    private String IBM_COREDIR = System.getenv("IBM_COREDIR");
    private String IBM_HEAPDUMPDIR = System.getenv("IBM_HEAPDUMPDIR");
    private String IBM_JAVACOREDIR = System.getenv("IBM_JAVACOREDIR");
    private String JAVA_DUMP_TDUMP_PATTERN = System.getenv("JAVA_DUMP_TDUMP_PATTERN");
    private File jarFile;

    public DumpEvent(String[] args, Logger logger) {
        this.logger = logger;
        this.argsValid(this.doArgs(args));
        this.setJarFile(this.findJarFile());
        this.setBuildId(this.findBuildId());
        this.setSettingsFile(this.findSettingsFile());
        this.logger.finest("The dump event is \"" + this.getEvent() + "\"");
    }

    private File findJarFile() {
        URL classUrl = DumpEvent.class.getResource("/com/ibm/java/diagnostics/collector/DiagnosticsCollector.class");
        String classUrlStr = null;
        if (classUrl != null) {
            classUrlStr = classUrl.toString();
        }
        String jarUrlStr = null;
        File f = null;
        if (classUrlStr != null && classUrlStr.startsWith("jar:") && classUrlStr.contains(".jar!")) {
            int start = classUrlStr.indexOf(":") + 1;
            int end = classUrlStr.indexOf("!");
            jarUrlStr = classUrlStr.substring(start, end);
            URI jarUri = null;
            try {
                jarUri = new URI(jarUrlStr);
                f = new File(jarUri);
            }
            catch (URISyntaxException e) {
                this.logger.log(Level.FINE, "Problem with URI for Diagnostics Collector jar: " + jarUrlStr, e);
            }
        }
        if (f == null) {
            this.logger.fine("Diagnostics Collector jar not found, class loaded from: " + classUrlStr);
        } else {
            this.logger.fine("Diagnostics Collector jar found at: " + f.getAbsolutePath());
        }
        return f;
    }

    public File findSettingsFile() {
        File jarParentDirSettings;
        File jarParentDir;
        File cwdSettings;
        File settings = this.getSettingsFile();
        if (settings == null && (cwdSettings = new File("dc.properties")).canRead()) {
            settings = cwdSettings;
        }
        File jarFileDir = null;
        if (settings == null) {
            File jf = this.getJarFile();
            if (jf != null) {
                jarFileDir = jf.getParentFile();
            }
            File jarDirSettings = null;
            if (jarFileDir != null && (jarDirSettings = new File(jarFileDir, "dc.properties")).canRead()) {
                settings = jarDirSettings;
            }
        }
        if (settings == null && jarFileDir != null && (jarParentDir = jarFileDir.getParentFile()) != null && (jarParentDirSettings = new File(jarParentDir, "dc.properties")).canRead()) {
            settings = jarParentDirSettings;
        }
        if (settings == null) {
            this.logger.fine("No user settings file detected");
        }
        return settings;
    }

    public String get_CEE_DMPTARG() {
        return this._CEE_DMPTARG;
    }

    public String getEvent() {
        return this.event;
    }

    public String getIBM_COREDIR() {
        return this.IBM_COREDIR;
    }

    public String getIBM_HEAPDUMPDIR() {
        return this.IBM_HEAPDUMPDIR;
    }

    public String getIBM_JAVACOREDIR() {
        return this.IBM_JAVACOREDIR;
    }

    public String getJAVA_DUMP_TDUMP_PATTERN() {
        return this.JAVA_DUMP_TDUMP_PATTERN;
    }

    public String getLastDump() {
        return this.lastDump;
    }

    public List<String> getDumpList() {
        return this.dumpList;
    }

    public String getUid() {
        return this.uid;
    }

    public void set_CEE_DMPTARG(String _cee_dmptarg) {
        this._CEE_DMPTARG = _cee_dmptarg;
    }

    public void setEvent(String event) {
        if (this.event == null || !this.event.equals("check")) {
            this.event = event;
        }
    }

    public void setIBM_COREDIR(String ibm_coredir) {
        this.IBM_COREDIR = ibm_coredir;
    }

    public void setIBM_HEAPDUMPDIR(String ibm_heapdumpdir) {
        this.IBM_HEAPDUMPDIR = ibm_heapdumpdir;
    }

    public void setIBM_JAVACOREDIR(String ibm_javacoredir) {
        this.IBM_JAVACOREDIR = ibm_javacoredir;
    }

    public void setJAVA_DUMP_TDUMP_PATTERN(String java_dump_tdump_pattern) {
        this.JAVA_DUMP_TDUMP_PATTERN = java_dump_tdump_pattern;
    }

    public void setLastDump(String last_dump) {
        this.lastDump = last_dump;
    }

    public void setDumpList(List<String> dumpList) {
        this.dumpList = dumpList;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getStamp() {
        return this.stamp;
    }

    boolean doArgs(String[] args) {
        if (args == null) {
            return false;
        }
        String eventVal = null;
        String stampVal = null;
        String lastdumpVal = null;
        String dumpListVal = null;
        String uidVal = null;
        String jobVal = null;
        String settingsVal = null;
        String dateVal = null;
        boolean areArgsValid = true;
        for (int i = 0; i < args.length; ++i) {
            if ("-event".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                eventVal = args[next];
                this.logger.fine("-event " + Messages.getString("DumpEvent.0") + eventVal);
                ++i;
                continue;
            }
            if ("-stamp".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null) continue;
                stampVal = args[next];
                this.logger.fine("-stamp " + Messages.getString("DumpEvent.1") + stampVal);
                if (args[next].startsWith("-")) continue;
                ++i;
                continue;
            }
            if ("-lastdump".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null) continue;
                if (!args[next].startsWith("-")) {
                    lastdumpVal = args[next];
                    this.logger.fine("-lastdump " + Messages.getString("DumpEvent.2") + lastdumpVal);
                    ++i;
                    continue;
                }
                if (!args[next].equals("-")) continue;
                ++i;
                continue;
            }
            if ("-dumplist".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-") && !args[next].equals("-") && !args[next].startsWith("-\t")) continue;
                dumpListVal = args[next];
                this.logger.fine("-dumplist " + Messages.getString("DumpEvent.2") + dumpListVal);
                ++i;
                continue;
            }
            if ("-uid".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                uidVal = args[next];
                this.logger.fine("-uid " + Messages.getString("DumpEvent.3") + uidVal);
                ++i;
                continue;
            }
            if ("-job".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                jobVal = args[next];
                this.logger.fine("-job " + Messages.getString("DumpEvent.5") + jobVal);
                ++i;
                continue;
            }
            if ("-settings".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                settingsVal = args[next];
                this.logger.fine("-settings" + Messages.getString("DumpEvent.7") + settingsVal);
                ++i;
                continue;
            }
            if ("-date".equals(args[i])) {
                int next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                dateVal = args[next];
                this.logger.fine("-date" + Messages.getString("DumpEvent.7") + dateVal);
                ++i;
                continue;
            }
            if ("-nozip".equals(args[i])) {
                this.setNoZipFlag();
                continue;
            }
            if ("-check".equals(args[i])) {
                this.setConfigCheck(true);
                continue;
            }
            areArgsValid = false;
            String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("DumpEvent.10"), args[i]);
            this.logger.warning(msg);
        }
        if (stampVal == null && dateVal == null) {
            dateVal = this.getNewestDate();
            if (dateVal != null) {
                stampVal = this.getNewestStampFromDate(dateVal);
            }
        } else if (stampVal == null && dateVal != null) {
            stampVal = this.getNewestStampFromDate(dateVal);
        }
        if (stampVal != null || this.isConfigCheck()) {
            areArgsValid &= this.checkAndSetEvent(eventVal);
            areArgsValid &= this.checkAndSetStamp(stampVal);
            areArgsValid &= this.checkAndSetLastdump(lastdumpVal);
            areArgsValid &= this.checkAndSetDumpList(dumpListVal);
            areArgsValid &= this.checkAndSetUid(uidVal);
            areArgsValid &= this.checkAndSetJob(jobVal);
            areArgsValid &= this.checkAndSetSettings(settingsVal);
        } else {
            areArgsValid = false;
        }
        return areArgsValid;
    }

    boolean checkAndSetSettings(String settingsVal) {
        if (settingsVal != null) {
            File sf = new File(settingsVal);
            if (sf.canRead()) {
                String msg = MessageFormat.format("{0} {1}", Messages.getString("DumpEvent.11"), sf.getAbsolutePath());
                this.logger.config(msg);
                this.settingsFile = sf;
            } else {
                String msg = MessageFormat.format("{0} {1}", Messages.getString("DumpEvent.12"), sf.getAbsolutePath());
                this.logger.warning(msg);
                this.logger.warning(Messages.getString("DumpEvent.13"));
            }
            this.settingsString = settingsVal;
        }
        return true;
    }

    public void setNoZipFlag() {
        this.logger.config(Messages.getString("DumpEvent.15"));
        this.noZipFlag = true;
    }

    public boolean getNoZipFlag() {
        return this.noZipFlag;
    }

    boolean checkAndSetJob(String jobVal) {
        boolean validity = true;
        if (jobVal != null) {
            boolean lengthValid;
            boolean noWhitespace = Pattern.matches("\\S+", jobVal);
            boolean bl = lengthValid = jobVal.length() <= 50;
            if (noWhitespace && lengthValid) {
                this.setJob(jobVal);
            } else {
                this.logger.warning("Java Diagnostics Collector" + Messages.getString("DumpEvent.17") + jobVal + "\"");
                validity = false;
            }
            if (System.getProperty("os.name").indexOf("z/OS") == -1) {
                this.logger.fine("-job parameter not used on this platform");
            }
        }
        return validity;
    }

    boolean checkAndSetUid(String uidVal) {
        String userName = System.getProperty("user.name");
        this.logger.config(Messages.getString("DumpEvent.18") + userName);
        if (uidVal != null) {
            boolean lengthValid;
            boolean noWhitespace = Pattern.matches("\\S+", uidVal);
            boolean bl = lengthValid = uidVal.length() < 129;
            if (noWhitespace && lengthValid) {
                if (!userName.equals(uidVal)) {
                    String msg = MessageFormat.format("{0} {1} {2} {3}", Messages.getString("DumpEvent.19"), uidVal, Messages.getString("DumpEvent.20"), userName);
                    this.logger.config(msg);
                }
                this.setUid(uidVal);
            } else {
                String msg = MessageFormat.format("{0} {1}{2} {3}", Messages.getString("DumpEvent.21"), uidVal, Messages.getString("DumpEvent.22"), userName);
                this.logger.config(msg);
                this.setUid(userName);
            }
        } else {
            String msg = MessageFormat.format("{0} {1}", Messages.getString("DumpEvent.23"), userName);
            this.logger.config(msg);
            this.setUid(userName);
        }
        return true;
    }

    boolean checkAndSetDumpList(String dumpListVal) {
        String[] dumps;
        if (dumpListVal == null || dumpListVal.equals("%list")) {
            this.setDumpList(null);
            return true;
        }
        ArrayList<String> validDumps = new ArrayList<String>();
        for (String dumpString : dumps = dumpListVal.split("\t")) {
            validDumps.add(dumpString);
        }
        this.setDumpList(validDumps);
        return true;
    }

    boolean checkAndSetLastdump(String lastdumpVal) {
        if (lastdumpVal != null && !"".equals(lastdumpVal)) {
            File dir;
            File f = new File(lastdumpVal);
            if (!f.canRead()) {
                if (Util.isOnZOS()) {
                    if (Util.zosDatasetExists(this.logger, lastdumpVal.replace("&DS", "001"))) {
                        this.setLastDump(lastdumpVal);
                        return true;
                    }
                    if (Util.zosDatasetExists(this.logger, lastdumpVal.concat(".X001"))) {
                        this.setLastDump(lastdumpVal.concat(".X&DS"));
                        return true;
                    }
                }
                String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("DumpEvent.24"), lastdumpVal);
                this.logger.warning(msg);
            }
            if ((dir = f.getParentFile()) != null && !dir.canRead()) {
                String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("DumpEvent.25"), dir.getAbsolutePath());
                this.logger.warning(msg);
            }
        }
        this.setLastDump(lastdumpVal);
        return true;
    }

    boolean checkAndSetStamp(String stampVal) {
        if (stampVal != null) {
            if (stampVal.startsWith("dc_config_check") || Pattern.matches("\\d\\d\\d\\d\\d\\d\\d\\d\\.\\d\\d\\d\\d\\d\\d\\.\\d+", stampVal)) {
                this.setStamp("." + stampVal + ".");
                this.setPid(stampVal.substring(stampVal.lastIndexOf(".") + 1));
                return true;
            }
            String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("DumpEvent.26"), stampVal);
            this.logger.warning(msg);
            return false;
        }
        this.logger.warning("Java Diagnostics Collector" + Messages.getString("DumpEvent.27"));
        return false;
    }

    String getNewestStampFromDate(String dateVal) {
        File[] dayhits;
        File dir = new File(System.getProperty("user.dir"));
        String stampVal = null;
        boolean multipleDumpsForDate = false;
        if (dateVal != null && Pattern.matches("\\d\\d\\d\\d\\d\\d\\d\\d", dateVal) && (dayhits = dir.listFiles(new ContainsFilter(dateVal))) != null) {
            int newestTime = 0;
            for (int j = 0; j < dayhits.length; ++j) {
                if (dayhits[j] == null) continue;
                int dateStartPosition = dayhits[j].getName().indexOf(dateVal);
                int timeStartPosition = dateStartPosition + 9;
                int timeEndPosition = timeStartPosition + 6;
                String timeString = null;
                try {
                    timeString = dayhits[j].getName().substring(timeStartPosition, timeEndPosition);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println(e.getMessage() + ":wrong format of file name");
                }
                if (timeString == null || !timeString.matches("\\d\\d\\d\\d\\d\\d")) continue;
                int time = Integer.parseInt(timeString);
                if (newestTime != 0 && time != newestTime) {
                    multipleDumpsForDate = true;
                }
                if (time <= newestTime) continue;
                newestTime = time;
                int pidEndPosition = dayhits[j].getName().indexOf(".", timeEndPosition + 2);
                try {
                    stampVal = dayhits[j].getName().substring(dateStartPosition, pidEndPosition);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println(e.getMessage() + ":wrong format of file name");
                }
            }
        }
        if (this.multipleDumps) {
            this.logger.warning(MessageFormat.format(Messages.getString("DumpEvent.31"), stampVal));
        } else if (multipleDumpsForDate) {
            this.logger.warning(MessageFormat.format(Messages.getString("DumpEvent.32"), dateVal, stampVal));
        }
        return stampVal;
    }

    String getNewestDate() {
        File dir = new File(System.getProperty("user.dir"));
        File[] allFiles = dir.listFiles();
        int newestDate = 0;
        String newestDateString = null;
        if (allFiles != null) {
            for (File file : allFiles) {
                int endPos;
                int startPos;
                String dateString;
                String fileName = file.getName();
                if (!fileName.matches(".*\\d\\d\\d\\d\\d\\d\\d\\d\\.\\d\\d\\d\\d\\d\\d\\.\\d.*") || !(dateString = fileName.substring(startPos = fileName.indexOf(46) + 1, endPos = startPos + 8)).matches("\\d\\d\\d\\d\\d\\d\\d\\d")) continue;
                int date = Integer.parseInt(dateString);
                if (newestDate != 0 && date != newestDate) {
                    this.multipleDumps = true;
                }
                if (date <= newestDate) continue;
                newestDate = date;
                newestDateString = dateString;
            }
        }
        if (newestDateString == null) {
            System.out.println("No files of the correct format found in current directory");
        }
        return newestDateString;
    }

    boolean checkAndSetEvent(String eventVal) {
        if (eventVal != null) {
            if (eventVal.equals("gpf") || eventVal.equals("outofmemoryerror") || eventVal.equals("user") || eventVal.equals("abort") || eventVal.equals("vmstart") || eventVal.equals("vmstop") || eventVal.equals("check")) {
                this.setEvent(eventVal);
            } else {
                this.setEvent("dumpevent");
                String msg = MessageFormat.format("{0} {1} {2} {3}", Messages.getString("DumpEvent.28"), eventVal, Messages.getString("DumpEvent.29"), this.getEvent());
                this.logger.config(msg);
            }
        } else {
            this.setEvent("dumpevent");
            String msg = MessageFormat.format("{0} {1}", Messages.getString("DumpEvent.30"), this.getEvent());
            this.logger.config(msg);
        }
        return true;
    }

    public boolean argsValid() {
        return this.argsValid;
    }

    private void argsValid(boolean flag) {
        this.argsValid = flag;
    }

    public void setStamp(String stamp) {
        this.stamp = stamp;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    String findBuildId() {
        String build = null;
        File f = this.getJarFile();
        if (f != null) {
            try {
                JarFile dcJar = new JarFile(f);
                Manifest mf = dcJar.getManifest();
                Attributes attr = null;
                if (mf != null) {
                    attr = mf.getMainAttributes();
                }
                if (attr != null) {
                    build = attr.getValue("Build-Identifier");
                }
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, "Problem getting build id from Diagnostics Collector jar manifest", e);
            }
        }
        if (build == null) {
            build = "not_packaged";
        }
        return build;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public void setSettingsFile(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public boolean isConfigCheck() {
        return this.configCheck;
    }

    public void setConfigCheck(boolean configCheck) {
        this.configCheck = configCheck;
        if (configCheck) {
            this.setEvent("check");
        }
    }

    public String getSettingsString() {
        return this.settingsString;
    }

    static class ContainsFilter
    implements FilenameFilter {
        String pattern;

        public ContainsFilter(String pattern) {
            this.pattern = pattern;
        }

        public boolean accept(File dir, String name) {
            return name != null && name.contains(this.pattern);
        }
    }
}

