/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.j9.ImageFactory;
import com.ibm.java.diagnostics.collector.DiagnosticsConfigChecker;
import com.ibm.java.diagnostics.collector.DumpDescriptor;
import com.ibm.java.diagnostics.collector.DumpEvent;
import com.ibm.java.diagnostics.collector.DumpSearch;
import com.ibm.java.diagnostics.collector.JextractRunner;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.MustGatherZip;
import com.ibm.java.diagnostics.collector.Settings;
import com.ibm.java.diagnostics.collector.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class DiagnosticsCollector {
    private static final String JAVA_HOME = "java.home";
    private static final String LIB = "lib";
    private static final String DDR = "ddr";
    private static final String J9DDR_JAR_NAME = "j9ddr.jar";
    private static final String DOTLOG = ".log";
    private static final String JAVADC = "JavaDiagnosticsCollector.";
    private static Logger logger;
    private static String logFileName;
    public static final String TOOLNAME = "Java Diagnostics Collector";

    private static void initLogger() {
        logger = Logger.getLogger("com.ibm.java.diagnostics.collector");
        logger.setLevel(Level.ALL);
    }

    private static void addConsoleHandlerToLogger(Settings settings) {
        Level consoleLogLevel = settings.getConsoleLogLevel();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SimpleFormatter());
        consoleHandler.setLevel(consoleLogLevel);
        logger.addHandler(consoleHandler);
    }

    private static void addFileHandlerToLogger(Settings settings) {
        String cwd;
        String outputPath = settings.getOutputDirPath();
        File targetLogFile = null;
        File targetLogDir = null;
        if (outputPath != null) {
            File outputDir = new File(outputPath);
            if (outputDir.exists()) {
                if (outputDir.isDirectory()) {
                    targetLogDir = outputDir;
                } else {
                    logger.log(Level.WARNING, Messages.getString("DiagnosticsCollector.17"), outputPath);
                }
            } else if (outputDir.mkdirs()) {
                targetLogFile = outputDir;
            } else {
                logger.log(Level.WARNING, Messages.getString("DiagnosticsCollector.18"), outputPath);
            }
        }
        if (targetLogDir == null && (cwd = System.getProperty("user.dir")) != null) {
            targetLogDir = new File(cwd);
        }
        if (targetLogDir != null) {
            try {
                targetLogFile = File.createTempFile(JAVADC, DOTLOG, targetLogDir);
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, Messages.getString("DiagnosticsCollector.19") + targetLogDir.getAbsolutePath());
            }
        }
        if (targetLogFile == null) {
            try {
                targetLogFile = File.createTempFile(JAVADC, DOTLOG, null);
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, Messages.getString("DiagnosticsCollector.20"));
            }
        }
        if (targetLogFile != null) {
            DiagnosticsCollector.addFileHandlerAndSetLogFileName(targetLogFile.getAbsolutePath(), settings.getFileLogLevel());
        }
    }

    private static void addFileHandlerAndSetLogFileName(String targetLogFilePath, Level logLevel) {
        FileHandler fh = null;
        try {
            fh = new FileHandler(targetLogFilePath);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, Messages.getString("DiagnosticsCollector.0"), targetLogFilePath);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, Messages.getString("DiagnosticsCollector.1"), targetLogFilePath);
        }
        if (fh != null) {
            fh.setFormatter(new SimpleFormatter());
            fh.setLevel(logLevel);
            logger.addHandler(fh);
            logFileName = targetLogFilePath;
        } else {
            String msg_format = TOOLNAME + Messages.getString("DiagnosticsCollector.2");
            logger.log(Level.SEVERE, msg_format, logFileName);
            logFileName = null;
        }
    }

    public static void main(String[] args) {
        DiagnosticsCollector.initLogger();
        DumpEvent de = new DumpEvent(args, logger);
        Settings settings = new Settings(de, logger);
        DiagnosticsCollector.addConsoleHandlerToLogger(settings);
        logger.setUseParentHandlers(false);
        DiagnosticsCollector.addFileHandlerToLogger(settings);
        logger.info("IBM Monitoring and Diagnostic Tools for Java - Diagnostics Collector");
        logger.info(Messages.getString("DiagnosticsCollector.4"));
        String fv = System.getProperty("java.fullversion");
        String lineSep = System.getProperty("line.separator");
        String pfm_fv = fv.replace("\n", lineSep);
        String fv_msg_template = Messages.getString("DiagnosticsCollector.5");
        String fv_msg = MessageFormat.format(fv_msg_template, pfm_fv);
        logger.config(TOOLNAME + fv_msg);
        String jclVer = System.getProperty("java.jcl.version");
        logger.config("java.jcl.version: \"" + jclVer + "\"");
        String dcBuildId = de.getBuildId();
        String buildVersionMsg = MessageFormat.format("{0}{1} {2}", TOOLNAME, Messages.getString("DiagnosticsCollector.6"), dcBuildId);
        logger.config(buildVersionMsg);
        StringBuffer sb = new StringBuffer("DC args: ");
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            sb.append(" ");
        }
        logger.fine(sb.toString());
        if (!de.argsValid()) {
            logger.severe(TOOLNAME + Messages.getString("DiagnosticsCollector.7"));
            String badArgumentsMsg = MessageFormat.format("\n\n{0}{1} {2}{3}", TOOLNAME, Messages.getString("DiagnosticsCollector.8"), dcBuildId, Messages.getString("DiagnosticsCollector.9"));
            System.err.println(badArgumentsMsg);
            System.exit(1);
        }
        String searchForFilesMsg = MessageFormat.format("\n\n{0}{1} {2}{3}", TOOLNAME, Messages.getString("DiagnosticsCollector.10"), dcBuildId, Messages.getString("DiagnosticsCollector.11"));
        System.err.println(searchForFilesMsg);
        DumpSearch ds = new DumpSearch(de, logger);
        DumpDescriptor[] dda = ds.getDumpSetAsArray();
        if (dda.length == 0) {
            logger.warning(TOOLNAME + Messages.getString("DiagnosticsCollector.24"));
            System.exit(2);
        }
        if (DiagnosticsCollector.isDDREnabled()) {
            if (!Util.isOnWindows() && !Util.isOnZOS()) {
                try {
                    for (DumpDescriptor dds : dda) {
                        String msg;
                        if (dds.getDumpType() != DumpDescriptor.DumpType.SYSTEM) continue;
                        ImageFactory dtfjFactory = new ImageFactory();
                        Image image = dtfjFactory.getImage(dds.getFile());
                        Class<?> clazz = null;
                        try {
                            clazz = image.getClass().getClassLoader().loadClass("com.ibm.j9ddr.libraries.LibraryCollector");
                            Object collector = clazz.newInstance();
                            Method method = collector.getClass().getMethod("collectLibrariesFor", String.class, String.class);
                            Object result = method.invoke(collector, dds.getFilePath(), "DDR");
                            logger.log(Level.INFO, result.toString());
                        }
                        catch (ClassNotFoundException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                        catch (IllegalAccessException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                        catch (InstantiationException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                        catch (SecurityException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                        catch (NoSuchMethodException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                        catch (IllegalArgumentException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                        catch (InvocationTargetException e) {
                            msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                            logger.log(Level.WARNING, msg);
                        }
                    }
                }
                catch (IOException e) {
                    String msg = MessageFormat.format(Messages.getString("DiagnosticsCollector.23"), e.toString());
                    logger.log(Level.WARNING, msg);
                }
            }
        } else if (settings.getRunJextract()) {
            JextractRunner jexr = new JextractRunner(logger);
            jexr.process(dda);
        } else {
            logger.config(Messages.getString("DiagnosticsCollector.21"));
        }
        if (de.isConfigCheck()) {
            boolean javadumpFound = false;
            for (DumpDescriptor d : dda) {
                if (d == null || d.getDumpType() != DumpDescriptor.DumpType.JAVA) continue;
                javadumpFound = true;
            }
            if (!javadumpFound && settings.getConfigCheckJavacore()) {
                logger.fine("Setting config.check.javacore is true but no javacore found yet. Waiting 5 seconds for javacore to finish ...");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINE, "Interrupted waiting for javacore to finish");
                }
                DumpSearch dsRetry = new DumpSearch(de, logger);
                dda = dsRetry.getDumpSetAsArray();
            }
            String checkingConfigMsg = MessageFormat.format("{0}{1} {2}{3}", TOOLNAME, Messages.getString("DiagnosticsCollector.12"), dcBuildId, Messages.getString("DiagnosticsCollector.13"));
            System.err.println(checkingConfigMsg);
            DiagnosticsConfigChecker dcc = new DiagnosticsConfigChecker(de, dda, logger);
            dcc.check();
        }
        if (!de.getNoZipFlag()) {
            System.err.println(TOOLNAME + Messages.getString("DiagnosticsCollector.14"));
            MustGatherZip mgz = new MustGatherZip(logger, logFileName, de, dda, settings);
            if (mgz.isZipFileCreated()) {
                String msg = MessageFormat.format("{0}{1} {2}", TOOLNAME, Messages.getString("DiagnosticsCollector.15"), mgz.getFilePath());
                System.err.println(msg);
            } else {
                System.err.println(TOOLNAME + Messages.getString("DiagnosticsCollector.16"));
            }
        }
    }

    private static boolean isDDREnabled() {
        File j9ddrFile = null;
        String javaHome = System.getProperty(JAVA_HOME);
        File libDirectory = new File(javaHome, LIB);
        File ddrDirectory = new File(libDirectory, DDR);
        j9ddrFile = new File(ddrDirectory, J9DDR_JAR_NAME);
        return j9ddrFile.exists();
    }
}

