/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.properties.MissingDataPostProcessor;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.Messages;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class HealthCenterMissingDataPostProcessor
extends MissingDataPostProcessor {
    private static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    private static final String BLANK = "";
    private static final String AGENT_LEVEL_PATTERN = "(.*)(\\d+.\\d+.\\d+.\\d{8})(.*)";
    private static final String AGENT_LEVEL_COMPONENTS_PATTERN = "(\\d+).(\\d+).(\\d+).(\\d{8})";
    private static final String XTRACE_OUTPUT_PATTERN = "-Xtrace.*output=.+";
    private static final String ENV_AGENT_VERSION_LABEL = "Health Center Agent version";
    private static final String ENV_COMMAND_LINE_LABEL = "Java command line";
    private static final String ENV_CONFIGURATION_LABEL = "Configuration";
    protected final String v1beta3agent = "1.0.0.20081105";
    protected final String v1beta4agent = "1.0.0.20081125";
    protected final String v1beta5agent = "1.0.0.20090130";
    public static final String NO_CONNECTION_OBJECT = Messages.getString("HealthCenterMissingDataPostProcessor.no.connection.object");
    public static final String NO_DATA_FROM_CONNECTION = Messages.getString("HealthCenterMissingDataPostProcessor.no.data.from.connection.object");
    protected VMLevelChecker checker;

    protected abstract String getMissingDataAdvice(Data var1);

    private String getAgentLevel(Data data) {
        Object object;
        Data data2 = data.getTopLevelData(JVMLabels.ENVIRONMENT);
        String string = BLANK;
        if (data2 != null && (object = (StringData)data2.getData(ENV_AGENT_VERSION_LABEL)) != null) {
            string = object.getValue();
        }
        object = Pattern.compile(AGENT_LEVEL_PATTERN);
        int n = 2;
        String string2 = BLANK;
        Matcher matcher = ((Pattern)object).matcher(string);
        if (matcher.matches() && matcher.groupCount() >= 3) {
            string2 = matcher.group(n);
        }
        return string2;
    }

    public int getJavaVersion(Data data) {
        String[] stringArray;
        int n = -1;
        String string = this.getSystemProperty(data, JAVA_SPECIFICATION_VERSION);
        if (string.contains(".") && (stringArray = string.split("\\.")).length == 2) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private String getSystemProperty(Data data, String string) {
        TableDataRow tableDataRow;
        EnvironmentData environmentData;
        TableData tableData;
        Data data2 = data.getTopLevelData(JVMLabels.ENVIRONMENT);
        String string2 = BLANK;
        if (data2 instanceof EnvironmentData && (tableData = (environmentData = (EnvironmentData)data2).getSystemProperties()) != null && (tableDataRow = tableData.get(string)) != null && tableDataRow.getRowData().length == 2) {
            string2 = (String)tableDataRow.getRowData()[1];
        }
        return string2;
    }

    protected boolean isVMOlderThan(int n, Data data) {
        Data data2 = data.getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data2 instanceof EnvironmentData) {
            EnvironmentData environmentData = (EnvironmentData)data2;
            return environmentData.isVMOlderThan(n);
        }
        return true;
    }

    public boolean isAgentOlderThan(String string, Data data) {
        String string2 = this.getAgentLevel(data);
        boolean bl = false;
        int[] nArray = this.getNumbers(string2);
        int[] nArray2 = this.getNumbers(string);
        if (nArray != null && nArray2 != null && nArray.length == nArray2.length && nArray2.length == 4) {
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                if (nArray[i] < nArray2[i]) {
                    bl = true;
                }
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private int[] getNumbers(String string) {
        int[] nArray = null;
        Pattern pattern = Pattern.compile(AGENT_LEVEL_COMPONENTS_PATTERN);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 4) {
            nArray = new int[4];
            try {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    nArray[i] = Integer.parseInt(matcher.group(i + 1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                nArray = null;
            }
        }
        return nArray;
    }

    public boolean isAgentThisLevelOrNewer(String string, Data data) {
        return !this.isAgentOlderThan(string, data);
    }

    private List<String> getCommandLineOptions(Data data) {
        TableDataRow tableDataRow;
        TableData tableData;
        List list = null;
        Data data2 = data.getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data2 != null && (tableData = (TableData)data2.getData(ENV_CONFIGURATION_LABEL)) != null && (tableDataRow = tableData.get(ENV_COMMAND_LINE_LABEL)) != null && tableDataRow.getRowData().length == 2) {
            list = (List)tableDataRow.getRowData()[1];
        }
        return list;
    }

    public boolean isXtraceOutputSpecified(Data data) {
        List<String> list = this.getCommandLineOptions(data);
        if (list != null) {
            for (String string : list) {
                if (!string.matches(XTRACE_OUTPUT_PATTERN)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getAdvice(Data data) {
        if (data.getTopLevelData(JVMLabels.CONNECTION) == null) {
            return NO_CONNECTION_OBJECT;
        }
        if (!this.subSystemsHaveChildren(data)) {
            ConnectionData connectionData = null;
            Data data2 = data.getTopLevelData(JVMLabels.CONNECTION);
            if (data2 instanceof ConnectionData) {
                connectionData = (ConnectionData)data2;
                return MessageFormat.format(NO_DATA_FROM_CONNECTION, connectionData.getDetails());
            }
        }
        return this.getMissingDataAdvice(data);
    }

    private boolean subSystemsHaveChildren(Data data) {
        boolean bl = false;
        for (Data data2 : data.getChildren()) {
            if (JVMLabels.CONNECTION.equals(data2.getLabel())) continue;
            bl |= data2.getChildren().length > 0;
        }
        return bl;
    }
}

