/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection;

import com.ibm.java.diagnostics.common.datamodel.impl.preferences.PreferencesHelper;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallingPreferenceInitalizer;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class NewConnectionPreferenceHelper
extends PreferencesHelper {
    private static final String[] STRING_TEMPLATE_ARRAY = new String[0];
    private static final String LOCALHOST = "localhost";
    private static final String DO_SCAN_PREFERENCE_NAME = "NewConnectionPreferenceHelper.classScan";
    private static final String HOSTNAME_PREFERENCE_NAME = "NewConnectionPreferenceHelper.classHostname";
    private static final String HOSTNAME_PREFERENCE_NAME_MQTT = "NewConnectionPreferenceHelper.classMQTTHostname";
    private static final String FIRST_HOSTNAME_PREFERENCE_NAME = "NewConnectionPreferenceHelper.classHostname0";
    private static final String PORT_PREFERENCE_NAME = "NewConnectionPreferenceHelper.classPort";
    private static final String PORT_PREFERENCE_NAME_MQTT = "NewConnectionPreferenceHelper.classMQTTPort";
    private static final Logger TRACE = LogFactory.getTrace(NewConnectionPreferenceHelper.class);
    private static final String PORT_SYSTEM_PROPERTY = "com.ibm.java.diagnostics.healthcenter.port";
    private static final String HOSTNAME_SYSTEM_PROPERTY = "com.ibm.java.diagnostics.healthcenter.hostname";
    private static final String EMPTY_STRING = "";
    private static final int MAXIMUM_HOST_LIST_SIZE = 10;

    public NewConnectionPreferenceHelper() {
        this.instantiatePreferences();
        this.initializeDefaultPreferences();
    }

    public int getPort(ConnectionType connectionType) {
        int n = 0;
        String string = System.getProperty(PORT_SYSTEM_PROPERTY);
        String string2 = null;
        string2 = connectionType.equals((Object)ConnectionType.JMX) ? PORT_PREFERENCE_NAME : PORT_PREFERENCE_NAME_MQTT;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                TRACE.warning(numberFormatException.toString());
                n = this.preferences.getInt(string2, 0);
            }
        } else {
            n = this.preferences.getInt(string2, 0);
        }
        return n;
    }

    public String getHostName(ConnectionType connectionType) {
        String string = null;
        string = System.getProperty(HOSTNAME_SYSTEM_PROPERTY);
        if (string == null) {
            string = connectionType.equals((Object)ConnectionType.MQTT) ? this.getHostStack(ConnectionType.MQTT).peek() : this.getHostStack(ConnectionType.JMX).peek();
        }
        return string;
    }

    protected Preferences instantiatePreferences() {
        return MarshallingPreferenceInitalizer.getInstance().getPreferences();
    }

    public void setHostName(String string, ConnectionType connectionType) {
        Stack<String> stack = this.getHostStack(connectionType);
        if (stack.contains(string)) {
            stack.remove(string);
        }
        stack.push(string);
        if (stack.size() > 10) {
            stack.remove(0);
        }
        for (int i = 0; i < stack.size(); ++i) {
            if (connectionType.equals((Object)ConnectionType.JMX)) {
                this.preferences.put(HOSTNAME_PREFERENCE_NAME + i, (String)stack.get(i));
                continue;
            }
            this.preferences.put(HOSTNAME_PREFERENCE_NAME_MQTT + i, (String)stack.get(i));
        }
    }

    public void setPort(int n, ConnectionType connectionType) {
        if (connectionType.equals((Object)ConnectionType.JMX)) {
            this.preferences.putInt(PORT_PREFERENCE_NAME, n);
        } else {
            this.preferences.putInt(PORT_PREFERENCE_NAME_MQTT, n);
        }
    }

    public boolean getDoAutoScan() {
        return this.preferences.getBoolean(DO_SCAN_PREFERENCE_NAME, true);
    }

    public String[] getRecentHosts(ConnectionType connectionType) {
        Stack<String> stack = this.getHostStack(connectionType);
        Collections.reverse(stack);
        return stack.toArray(STRING_TEMPLATE_ARRAY);
    }

    public void setDoAutoScan(boolean bl) {
        this.preferences.putBoolean(DO_SCAN_PREFERENCE_NAME, bl);
    }

    private Stack<String> getHostStack(ConnectionType connectionType) {
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < 10; ++i) {
            String string = connectionType.equals((Object)ConnectionType.MQTT) ? this.preferences.get(HOSTNAME_PREFERENCE_NAME_MQTT + i, null) : this.preferences.get(HOSTNAME_PREFERENCE_NAME + i, null);
            if (string instanceof String) {
                if (stack.contains(string) || EMPTY_STRING.equals(string)) continue;
                stack.push(string);
                continue;
            }
            if (string == null) continue;
            String string2 = MessageFormat.format(Messages.getString("NewConnectionPreferenceHelper.corrupted.preferences"), string);
            TRACE.warning(string2);
        }
        if (stack.isEmpty()) {
            stack = NewConnectionPreferenceHelper.initialiseDefaultHostList();
        }
        return stack;
    }

    private static Stack<String> initialiseDefaultHostList() {
        Stack<String> stack = new Stack<String>();
        try {
            String string = InetAddress.getLocalHost().getHostName();
            stack.push(string);
        }
        catch (UnknownHostException unknownHostException) {
            stack.push(LOCALHOST);
        }
        return stack;
    }

    public static void initializeDefaults(Preferences preferences) {
        if (preferences.getInt(PORT_PREFERENCE_NAME, -1) == -1) {
            preferences.putInt(PORT_PREFERENCE_NAME, 1972);
            try {
                String string = InetAddress.getLocalHost().getHostName();
                preferences.put(FIRST_HOSTNAME_PREFERENCE_NAME, string);
            }
            catch (UnknownHostException unknownHostException) {
                preferences.put(FIRST_HOSTNAME_PREFERENCE_NAME, LOCALHOST);
            }
            preferences.putBoolean(DO_SCAN_PREFERENCE_NAME, true);
        }
    }

    @Override
    public void initializeDefaultPreferences() {
        if (this.preferences.getInt(PORT_PREFERENCE_NAME, -1) == -1) {
            this.preferences.putInt(PORT_PREFERENCE_NAME, 1972);
            try {
                String string = InetAddress.getLocalHost().getHostName();
                this.preferences.put(FIRST_HOSTNAME_PREFERENCE_NAME, string);
            }
            catch (UnknownHostException unknownHostException) {
                this.preferences.put(FIRST_HOSTNAME_PREFERENCE_NAME, LOCALHOST);
            }
            this.preferences.putBoolean(DO_SCAN_PREFERENCE_NAME, true);
        }
    }

    public void clear() {
        try {
            this.preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }
}

