/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.OptionChecker;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UnsupportedOptionChecker
extends OptionChecker {
    public static final String XJ9 = "-Xj9";
    private static final String XJCL = "-Xjcl";
    private static final String XOSS = "-Xoss";
    private static final String XAGGRESSIVE = "-Xaggressive";
    private static final String XRUN = "-Xrun";
    private static final String[] options = new String[]{"-X", "-Xargencoding", "-Xbootclasspath", "-Xbootclasspath/a", "-Xbootclasspath/p", "-Xcheck", "-Xcompressedrefs", "-Xdbg", "-Xdebug", "-Xdisablejavadump", "-Xdump", "-Xfuture", "-Xifa", "-Xiss", "-Xjarversion", "-Xjni", "-Xlinenumbers", "-Xlp", "-Xmso", "-Xnoagent", "-Xnolinenumbers", "-Xnosigcatch", "-Xnosigchain", "-Xoptionsfile", "-Xoss", "-Xaggressive", "-Xrdbginfo", "-Xrs", "-Xrun", "-Xscmx", "-Xshareclasses", "-Xsigcatch", "-Xsigchain", "-Xss", "-Xssi", "-Xtrace", "-Xverify", "-XX:MaxDirectMemorySize", "-Xcodecache", "-Xcomp", "-Xint", "-Xjarversion", "-Xjit", "-Xquickstart", "-XsamplingExpirationTime", "-Xalwaysclassgc", "-Xclassgc", "-Xcompactexplicitgc", "-Xcompactgc", "-Xconcurrentbackground", "-Xconcurrentlevel", "-Xconmeter", "-Xdisableexcessivegc", "-Xdisableexplicitg", "-Xdisablestringconstantgc", "-Xenableexcessivegc", "-Xenablestringconstantgc", "-Xgc", "-Xgcpolicy", "-Xgcthreads", "-Xgcworkpackets", "-Xloa", "-Xloainitial", "-Xloamaximum", "-Xmaxe", "-Xmaxf", "-Xmaxt", "-Xmca", "-Xmco", "-Xmine", "-Xminf", "-Xmint", "-Xmn", "-Xmns", "-Xmnx", "-Xmo", "-Xmoi", "-Xmos", "-Xmox", "-Xmr", "-Xmrx", "-Xms", "-Xmx", "-Xnoclassgc", "-Xnocompactexplicitgc", "-Xnocompactgc", "-Xnoloa", "-Xnopartialcompactgc", "-Xpartialcompactgc", "-Xsoftmx", "-Xsoftrefthreshold", "-Xtgc", "-Xverbosegclog", "-Xoptionsfile", "-XselectiveDebug", "-Xhealthcenter", "-Xzero", "-Xthr", "-Xrealtime", "-Xnoquickstart", "-Xdisableexplicitgc", "-Xaot", "-Xnoaot", "-Xscdmx", "-XCEEHDLR", "-Xlockword", "-Xdiagnosticscollector", "-XXgc", "-Xnuma", "-Xconcurrentlevel0", "-XXgc:numaCommon", "-XX:+UseCompressedOops", "-Xnocompressedrefs", "-XXnosuballoc32bitmem", "-Xscmaxaot", "-Xlimit", "-Xmt"};
    private static final Set<String> legitimateOptions = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnsupportedOptionChecker() {
        String[] stringArray = options;
        synchronized (options) {
            if (legitimateOptions.size() == 0) {
                for (String string : options) {
                    legitimateOptions.add(string);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Status checkOptions(Collection<String> collection, StructuredStringDataBuilder structuredStringDataBuilder) {
        Status status = Status.HEALTHY;
        for (String string : collection) {
            String string2;
            if (!string.startsWith("-X")) continue;
            String[] stringArray = string.split("[:=0-9]");
            if (!(legitimateOptions.contains(string) || legitimateOptions.contains(stringArray[0]) || string.startsWith(XRUN) || string.startsWith(XJCL) || XJ9.equals(string))) {
                string2 = MessageFormat.format(Messages.getString("NonStandardOptionChecker.non.supported.option"), string);
                structuredStringDataBuilder.addWarning(string2);
                status = Status.WARNING;
            }
            if (!string.startsWith(XOSS)) continue;
            string2 = string.substring(XOSS.length());
            structuredStringDataBuilder.addWarning(MessageFormat.format(Messages.getString("NonStandardOptionChecker.xoss.deprecated"), string2));
            status = Status.WARNING;
        }
        return status;
    }
}

