/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api;

import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDefaultPreferences;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallingPreferenceInitalizer;
import java.util.prefs.Preferences;

public class HealthCenterPreferences {
    public HealthCenterPreferences() {
        this.setDefaults();
    }

    public void setSlidingWindowTruncation(boolean bl) {
        this.getPreferences().putBoolean("DataStoragePreferenceHelper.classUseSlidingWindow", bl);
    }

    public void setTruncationTimeWindow(int n) {
        this.getPreferences().putInt("DataStoragePreferenceHelper.classMinutesToKeep", n);
    }

    public void setBackingStoreCount(int n) {
        this.getPreferences().putInt("DataStoragePreferenceHelper.classmaxHCDToKeep", n);
    }

    public void setTruncationRunInterval(int n) {
        this.getPreferences().putInt("DataStoragePreferenceHelper.classTruncationJobRunInterval", n);
    }

    public boolean getSlidingWindowTruncation() {
        return this.getPreferences().getBoolean("DataStoragePreferenceHelper.classUseSlidingWindow", false);
    }

    public int getTruncationTimeWindow() {
        return this.getPreferences().getInt("DataStoragePreferenceHelper.classMinutesToKeep", 60);
    }

    public int getTruncationRunInterval() {
        return this.getPreferences().getInt("DataStoragePreferenceHelper.classTruncationJobRunInterval", 60);
    }

    public void setDefaults() {
        HealthCenterDefaultPreferences healthCenterDefaultPreferences = new HealthCenterDefaultPreferences();
        this.setSlidingWindowTruncation(healthCenterDefaultPreferences.getDefaultSlidingWindowTruncation());
        this.setTruncationRunInterval(healthCenterDefaultPreferences.getDefaultTruncationRunInterval());
        this.setTruncationTimeWindow(healthCenterDefaultPreferences.getDefaultTruncationTimeWindow());
        this.setMemoryRestictionEnabled(healthCenterDefaultPreferences.getDefaultMemoryRestrictionEnabled());
    }

    public void setMemoryRestictionEnabled(boolean bl) {
        this.getPreferences().putBoolean("DataStoragePreferenceHelper.classuseMemorySizeLimit", bl);
    }

    public boolean isMemoryRestictionEnabled() {
        return this.getPreferences().getBoolean("DataStoragePreferenceHelper.classuseMemorySizeLimit", true);
    }

    public long setMemoryRestriction(long l) {
        HealthCenterDefaultPreferences healthCenterDefaultPreferences = new HealthCenterDefaultPreferences();
        if (l > healthCenterDefaultPreferences.getDefaultMaxMemoryUse()) {
            this.getPreferences().putLong("DataStoragePreferenceHelper.classmaxMemoryUsage", l);
            return l;
        }
        return healthCenterDefaultPreferences.getDefaultMaxMemoryUse();
    }

    public long getMemoryRestriction() {
        return this.getPreferences().getLong("DataStoragePreferenceHelper.classmaxMemoryUsage", -1L);
    }

    private Preferences getPreferences() {
        Preferences preferences = MarshallingPreferenceInitalizer.getInstance().getPreferences();
        return preferences;
    }
}

