/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import java.text.MessageFormat;

public class StringDataImpl
extends DataImpl
implements StringDataBuilder {
    private static final String EMPTY_STRING = "";
    protected String value = "";
    private long creationTime = System.currentTimeMillis();

    public StringDataImpl(String string) {
        super(string);
    }

    public StringDataImpl(String string, String string2) {
        this(string);
        this.addValue(string2);
    }

    @Override
    public void addValue(String string) {
        if (string != null && string.length() > 0) {
            this.value = this.value + string;
            this.notifyListeners();
        }
    }

    @Override
    public void clearValue() {
        this.value = EMPTY_STRING;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return EMPTY_STRING.equalsIgnoreCase(this.value);
    }

    @Override
    public String toString() {
        return MessageFormat.format(Messages.getString("StringDataImpl.data.tostring.template"), this.label, this.value);
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

