/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.install.info.internal;

import com.ibm.cic.install.info.IInstallInfo;
import com.ibm.cic.install.info.internal.AbstractInfo;
import com.ibm.cic.install.info.internal.AbstractPackageContainer;
import com.ibm.cic.install.info.internal.InstallInfo;
import com.ibm.cic.install.info.internal.Location;
import com.ibm.cic.install.info.internal.Messages;
import com.ibm.cic.install.info.internal.Package;
import com.ibm.cic.install.info.internal.XmlConstants;
import com.ibm.cic.install.launcher.internal.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class InstallInfoParser
extends DefaultHandler
implements XmlConstants {
    private static final String PLUGIN_ID = Activator.getPluginId();
    private static final String PI_VERSION_REGEX = "version=['\"]([\\w\\d][\\w\\d\\.]*)['\"]$";
    private static final Pattern PI_VERSION_PATTERN = Pattern.compile("version=['\"]([\\w\\d][\\w\\d\\.]*)['\"]$");
    private static final Version EXPECTED_INSTALL_INFO_VERSION = new Version(0, 0, 3);
    private Version installInfoVersion = Version.emptyVersion;
    private InstallInfo installInfo = null;
    private ElemStack elemStack = new ElemStack();
    private MultiStatus status;

    public IStatus parse(File file) {
        String location;
        try {
            location = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            location = file.getPath();
        }
        this.status = new MultiStatus(PLUGIN_ID, 0, NLS.bind((String)Messages.InstallInfoParser_parseError, (Object)location), null);
        try {
            FileInputStream stream = new FileInputStream(file);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)stream, (DefaultHandler)this);
        }
        catch (Exception e) {
            IStatus excptStatus = this.exceptionStatus(e);
            this.status.add(excptStatus);
        }
        return this.status;
    }

    public IInstallInfo getInstallInfo() {
        return this.installInfo;
    }

    public void processingInstruction(String target, String data) {
        if ("installInfo".equals(target)) {
            this.installInfoVersion = InstallInfoParser.extractVersion(data);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.elemStack.size() == 0) {
            this.checkVersion();
        }
        this.elemStack.push(new ElemStackEntry(qName));
        if (qName.equals("installInfo")) {
            this.handleInstallInfoAttributes(attributes);
        } else if (qName.equals("location")) {
            this.handleLocationAttributes(attributes);
        } else if (qName.equals("package")) {
            this.handlePackageAttributes(attributes);
        } else if (qName.equals("property")) {
            this.handlePropertyAttributes(attributes);
        } else {
            this.unexpectedElement(qName, attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this.elemStack.pop();
    }

    public void characters(char[] chars, int start, int length) {
        String text = new String(chars, start, length);
        if (text.trim().length() != 0) {
            this.unexpectedCharacterData(text);
        }
    }

    public void warning(SAXParseException e) {
        this.addStatus(2, e);
    }

    public void error(SAXParseException e) {
        this.addStatus(4, e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.addStatus(4, e);
        throw e;
    }

    private void checkVersion() {
        if (!this.installInfoVersion.equals((Object)EXPECTED_INSTALL_INFO_VERSION)) {
            this.addError(NLS.bind((String)Messages.InstallInfoParser_unexpectedVersion, (Object)EXPECTED_INSTALL_INFO_VERSION, (Object)this.installInfoVersion));
        }
    }

    private void handleInstallInfoAttributes(Attributes attributes) {
        String xsiSchemaLocation;
        String xmlnsInstalled;
        boolean hasErrors = false;
        if (!this.isRootElement()) {
            this.unexpectedElement("installInfo", attributes);
            hasErrors = true;
        }
        this.hasUnexpectedAttributes(attributes, "installInfo", new String[]{"xmlns:installed", "xmlns:xsi", "xsi:schemaLocation"});
        String xmlnsXsi = attributes.getValue("xmlns:xsi");
        if (xmlnsXsi == null) {
            this.checkRequiredAttribute("installInfo", "xmlns:xsi", xmlnsXsi);
            hasErrors = true;
        }
        if ((xmlnsInstalled = attributes.getValue("xmlns:installed")) == null) {
            this.checkRequiredAttribute("installInfo", "xmlns:installed", xmlnsInstalled);
            hasErrors = true;
        }
        if ((xsiSchemaLocation = attributes.getValue("xsi:schemaLocation")) == null) {
            this.checkRequiredAttribute("installInfo", "xsi:schemaLocation", xsiSchemaLocation);
            hasErrors = true;
        }
        if (!hasErrors) {
            this.installInfo = new InstallInfo(xmlnsXsi, xmlnsInstalled, xsiSchemaLocation);
            this.elemStack.top().data = this.installInfo;
        }
    }

    private void handleLocationAttributes(Attributes attributes) {
        String path;
        String kind;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.unexpectedElement("location", attributes);
            hasErrors = true;
        }
        this.hasUnexpectedAttributes(attributes, "location", new String[]{"id", "kind", "path"});
        String id = attributes.getValue("id");
        if (id == null) {
            this.checkRequiredAttribute("location", "id", id);
            hasErrors = true;
        }
        if ((kind = attributes.getValue("kind")) == null) {
            this.checkRequiredAttribute("location", "kind", kind);
            hasErrors = true;
        }
        if ((path = attributes.getValue("path")) == null) {
            this.checkRequiredAttribute("location", "path", path);
            hasErrors = true;
        }
        if (!hasErrors) {
            Location loc = new Location(id, kind, path);
            InstallInfo info = (InstallInfo)this.elemStack.top((int)-1).data;
            if (info != null) {
                info.addLocation(loc);
            }
            this.elemStack.top().data = loc;
        }
    }

    private void handlePackageAttributes(Attributes attributes) {
        String kind;
        boolean hasErrors = false;
        if (this.isTopLevelElement() || this.isRootElement() || this.isPropertySubElement()) {
            this.unexpectedElement("package", attributes);
            hasErrors = true;
        }
        this.hasUnexpectedAttributes(attributes, "package", new String[]{"id", "kind", "name", "version"});
        String id = attributes.getValue("id");
        if (id == null) {
            this.checkRequiredAttribute("package", "id", id);
            hasErrors = true;
        }
        if ((kind = attributes.getValue("kind")) == null) {
            this.checkRequiredAttribute("package", "kind", kind);
            hasErrors = true;
        }
        String name = attributes.getValue("name");
        String versionStr = attributes.getValue("version");
        Version version = null;
        if (versionStr != null && versionStr.trim().length() != 0) {
            try {
                version = new Version(versionStr);
            }
            catch (Throwable throwable) {
                this.invalidAttributeValue("package", "version", versionStr);
            }
        }
        if (!hasErrors) {
            Package pkg = new Package(id, kind, name, version);
            this.elemStack.top().data = pkg;
            AbstractPackageContainer parent = (AbstractPackageContainer)this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addPackage(pkg);
            }
        }
    }

    private void handlePropertyAttributes(Attributes attributes) {
        AbstractInfo info;
        String value;
        boolean hasErrors = false;
        if (this.isRootElement() || this.isPropertySubElement()) {
            this.unexpectedElement("property", attributes);
            hasErrors = true;
        }
        this.hasUnexpectedAttributes(attributes, "property", new String[]{"name", "value"});
        String name = attributes.getValue("name");
        if (name == null) {
            this.checkRequiredAttribute("property", "name", name);
            hasErrors = true;
        }
        if ((value = attributes.getValue("value")) == null) {
            this.checkRequiredAttribute("property", "value", value);
            hasErrors = true;
        }
        if (!hasErrors && (info = this.elemStack.top((int)-1).data) != null) {
            info.setProperty(name, value);
        }
    }

    private IStatus exceptionStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.toString(), (Throwable)e);
    }

    private void addStatus(int severity, SAXParseException e) {
        String message = this.getMessage(e);
        this.status.add((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    private void addError(String msg) {
        this.status.add((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    private String getMessage(SAXParseException e) {
        StringBuffer sb = new StringBuffer();
        String systemId = e.getSystemId();
        if (systemId != null) {
            sb.append(systemId);
            sb.append(':');
        }
        sb.append(e.getLineNumber());
        sb.append(':');
        sb.append(e.getColumnNumber());
        sb.append(": ");
        sb.append(e.getMessage());
        return sb.toString();
    }

    private boolean checkRequiredAttribute(String element, String name, String value) {
        if (value == null) {
            this.addError(NLS.bind((String)Messages.InstallInfoParser_missingRequiredAttribute, (Object)element, (Object)name));
            return false;
        }
        return true;
    }

    private void unexpectedAttribute(String element, String attribute, String value) {
        this.addError(NLS.bind((String)Messages.InstallInfoParser_unexpectedAttribute, (Object[])new Object[]{element, attribute, value}));
    }

    private void invalidAttributeValue(String element, String attribute, String value) {
        this.addError(NLS.bind((String)Messages.InstallInfoParser_illegalValueForAttribute, (Object[])new Object[]{attribute, element, value}));
    }

    private void unexpectedElement(String element, Attributes attributes) {
        this.addError(NLS.bind((String)Messages.InstallInfoParser_unexpectedElement, (Object[])new Object[]{this.elemStack.top().toString(), element, InstallInfoParser.toString(attributes)}));
    }

    private void unexpectedCharacterData(String cdata) {
        this.addError(NLS.bind((String)Messages.InstallInfoParser_unexpectedCharacterData, (Object)this.elemStack.top().toString(), (Object)cdata.trim()));
    }

    private static String toString(Attributes attributes) {
        StringBuffer result = new StringBuffer();
        InstallInfoParser.toString(result, attributes);
        return result.toString();
    }

    private static void toString(StringBuffer sb, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i).trim();
            sb.append(' ').append(name);
            sb.append('=').append('\"');
            sb.append(value);
            sb.append('\"');
            ++i;
        }
    }

    private boolean hasUnexpectedAttributes(Attributes attributes, String elemName, String[] expectedAttributes) {
        boolean result = false;
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            boolean foundit = false;
            int j = 0;
            while (j < expectedAttributes.length) {
                String expectedAttribute = expectedAttributes[j];
                if (name.equals(expectedAttribute)) {
                    foundit = true;
                    break;
                }
                ++j;
            }
            if (!foundit) {
                String value = attributes.getValue(i).trim();
                this.unexpectedAttribute(elemName, name, value);
                result = true;
            }
            ++i;
        }
        return result;
    }

    private boolean isRootElement() {
        return this.elemStack.size() == 1;
    }

    private boolean isTopLevelElement() {
        return this.elemStack.size() == 2;
    }

    private boolean isPropertySubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("property");
    }

    private static Version extractVersion(String data) {
        return new Version(PI_VERSION_PATTERN.matcher(data).replaceAll("$1"));
    }

    private static class ElemStack
    extends Stack {
        private ElemStack() {
        }

        public ElemStackEntry top() {
            return (ElemStackEntry)this.peek();
        }

        public ElemStackEntry top(int topRelativeIndex) {
            int topIndex = this.size() - 1;
            int index = topIndex + topRelativeIndex;
            if (index < 0 || index > topIndex) {
                return null;
            }
            return (ElemStackEntry)this.get(index);
        }
    }

    private static class ElemStackEntry {
        public String name;
        public AbstractInfo data = null;

        public ElemStackEntry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

