/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Element;

public final class DOMKWTripleDES
extends DOMEncryptionMethod {
    private static final byte[] constantIv = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private Cipher cipher;
    private boolean padding = false;
    private SecureRandom random = null;

    public DOMKWTripleDES(Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2001/04/xmlenc#kw-tripledes", keySize, params);
    }

    public DOMKWTripleDES(Element smElem) throws MarshalException {
        super(smElem);
    }

    protected void checkParams(Integer keySize, EncryptionMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for TripleDES cipher algorithm");
        }
    }

    protected EncryptionMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for TripleDES cipher algorithm");
    }

    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for TripleDES cipher algorithm");
    }

    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    public byte[] decrypt(Key key, byte[] data) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return this.unwrap(key, data);
    }

    public Key decryptKey(Key key, byte[] encryptedKey, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        int len = encryptedKey.length;
        if (len != 32 && len != 40 && len != 48) {
            throw new IllegalBlockSizeException("Unsupported encrypted key length " + len);
        }
        return this.unwrap(key, encryptedKey, algo);
    }

    public byte[] encrypt(Key key, byte[] data, EncryptedType type) throws InvalidKeyException {
        if (type instanceof EncryptedKey) {
            try {
                return this.wrap(key, data);
            }
            catch (IllegalBlockSizeException ex) {
                throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
            }
        }
        throw new RuntimeException("Operation not supported");
    }

    public byte[] wrap(Key key, Key toBeWrapped) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] keybytes = toBeWrapped.getEncoded();
        return this.wrap(key, keybytes);
    }

    private byte[] wrap(Key key, byte[] keybytes) throws InvalidKeyException, IllegalBlockSizeException {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw (InvalidKeyException)new InvalidKeyException(nsae.getMessage()).initCause(nsae);
        }
        byte[] cks = sha1.digest(keybytes);
        byte[] wkcks = new byte[keybytes.length + 8];
        System.arraycopy(keybytes, 0, wkcks, 0, keybytes.length);
        System.arraycopy(cks, 0, wkcks, keybytes.length, 8);
        byte[] iv = new byte[8];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("TripleDES/CBC/NoPadding");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException(nsae.getMessage());
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException(nspe.getMessage());
            }
        }
        try {
            this.cipher.init(1, key, ivSpec);
        }
        catch (InvalidAlgorithmParameterException iap) {
            throw new InvalidKeyException(iap.getMessage());
        }
        byte[] temp1 = null;
        try {
            temp1 = this.cipher.doFinal(wkcks);
        }
        catch (BadPaddingException bpe) {
            new InvalidKeyException(bpe.getMessage());
        }
        byte[] temp2 = new byte[temp1.length + 8];
        System.arraycopy(iv, 0, temp2, 0, iv.length);
        System.arraycopy(temp1, 0, temp2, iv.length, temp1.length);
        byte[] temp3 = new byte[temp2.length];
        int i = temp2.length - 1;
        int j = 0;
        while (i >= 0) {
            temp3[j] = temp2[i];
            --i;
            ++j;
        }
        IvParameterSpec constSpec = new IvParameterSpec(constantIv);
        try {
            this.cipher.init(1, key, constSpec);
        }
        catch (InvalidAlgorithmParameterException iap) {
            new InvalidKeyException(iap.getMessage());
        }
        byte[] output = null;
        try {
            output = this.cipher.doFinal(temp3);
        }
        catch (BadPaddingException bpe) {
            new InvalidKeyException(bpe.getMessage());
        }
        return output;
    }

    public byte[] unwrap(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        int len = encrypted.length;
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("TripleDES/CBC/NoPadding");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalBlockSizeException(nsae.getMessage());
            }
            catch (NoSuchPaddingException nspe) {
                throw new IllegalBlockSizeException(nspe.getMessage());
            }
        }
        try {
            this.cipher.init(2, key, new IvParameterSpec(constantIv));
        }
        catch (InvalidAlgorithmParameterException iap) {
            throw new IllegalBlockSizeException(iap.getMessage());
        }
        byte[] temp2 = this.cipher.doFinal(encrypted);
        for (int i = 0; i < temp2.length / 2; ++i) {
            byte tmp = temp2[i];
            temp2[i] = temp2[temp2.length - i - 1];
            temp2[temp2.length - i - 1] = tmp;
        }
        byte[] iv = new byte[8];
        System.arraycopy(temp2, 0, iv, 0, 8);
        IvParameterSpec spec = new IvParameterSpec(iv);
        try {
            this.cipher.init(2, key, spec);
        }
        catch (InvalidAlgorithmParameterException iap) {
            throw new IllegalBlockSizeException(iap.getMessage());
        }
        byte[] wkcks = this.cipher.doFinal(temp2, 8, temp2.length - 8);
        byte[] wk = new byte[wkcks.length - 8];
        System.arraycopy(wkcks, 0, wk, 0, wk.length);
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalBlockSizeException(nsae.getMessage());
        }
        byte[] cs = sha1.digest(wk);
        for (int i = 0; i < 8; ++i) {
            if (cs[i] == wkcks[wk.length + i]) continue;
            throw new IllegalBlockSizeException("check sum not the same");
        }
        return wk;
    }

    public Key unwrap(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] keybytes = this.unwrap(key, encrypted);
        String algoName = Utils.mapAlgorithm(algo.getAlgorithm());
        return this.genKey(keybytes, algoName);
    }
}

