/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.xml.enc.dom.C14nUtil;
import com.ibm.xml.enc.dom.DOMCipherData;
import com.ibm.xml.enc.dom.DOMCipherReference;
import com.ibm.xml.enc.dom.DOMCipherValue;
import com.ibm.xml.enc.dom.DOMEncManager;
import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.DOMEncryptionProperties;
import com.ibm.xml.enc.dom.DOMKeyInfo;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.Debug;
import com.ibm.xml.enc.dom.TransformUtil;
import com.ibm.xml.enc.dom.TreeNodeSetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.enc.CipherData;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.CipherValue;
import javax.xml.crypto.enc.EncryptedData;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.ToBeEncryptedOctetStream;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.dom.DOMEncryptContext;
import javax.xml.crypto.enc.dom.DOMToBeEncryptedXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXParseException;

public final class DOMEncryptedData
extends DOMStructure
implements EncryptedData {
    private static Debug debug = Debug.getInstance("xmlenc");
    private DOMEncryptionMethod em;
    private DOMKeyInfo ki;
    private DOMCipherData cd;
    private DOMEncryptionProperties eps;
    private String id;
    private String type;
    private String mimeType;
    private String encoding;
    private Element localEncDataElem = null;
    private ToBeEncrypted toBeEncrypted = null;
    private boolean isDecrypted = false;
    private byte[] decrypted = null;
    private byte[] encryptedBytes = null;

    public DOMEncryptedData(ToBeEncrypted toBeEncrypted, DOMEncryptionMethod em, DOMKeyInfo ki, DOMEncryptionProperties eps, String id) {
        if (toBeEncrypted instanceof DOMToBeEncryptedXML) {
            this.toBeEncrypted = (DOMToBeEncryptedXML)toBeEncrypted;
        } else if (toBeEncrypted instanceof ToBeEncryptedOctetStream) {
            this.toBeEncrypted = (ToBeEncryptedOctetStream)toBeEncrypted;
        } else {
            throw new IllegalArgumentException("toBeEncrypted is not type of DOMToBeEncryptedXML or ToBeEncryptedOctetStream");
        }
        this.id = id;
        this.em = em;
        this.ki = ki;
        this.eps = eps;
        this.type = this.toBeEncrypted.getType();
        this.mimeType = this.toBeEncrypted.getMimeType();
        this.encoding = this.toBeEncrypted.getEncoding();
    }

    public DOMEncryptedData(ToBeEncrypted toBeEncrypted, DOMEncryptionMethod em, DOMKeyInfo ki, DOMEncryptionProperties eps, String id, DOMCipherReference cipherRef) {
        if (toBeEncrypted instanceof DOMToBeEncryptedXML) {
            this.toBeEncrypted = (DOMToBeEncryptedXML)toBeEncrypted;
        } else if (toBeEncrypted instanceof ToBeEncryptedOctetStream) {
            this.toBeEncrypted = (ToBeEncryptedOctetStream)toBeEncrypted;
        } else {
            throw new IllegalArgumentException("toBeEncrypted is not type of DOMToBeEncryptedXML or ToBeEncryptedOctetStream");
        }
        this.em = em;
        this.ki = ki;
        this.eps = eps;
        this.id = id;
        this.type = this.toBeEncrypted.getType();
        this.mimeType = this.toBeEncrypted.getMimeType();
        this.encoding = this.toBeEncrypted.getEncoding();
        this.cd = cipherRef;
    }

    public DOMEncryptedData(Element encDataElem, XMLCryptoContext context) throws MarshalException {
        this.localEncDataElem = encDataElem;
        this.id = DOMUtils.getAttributeValue(this.localEncDataElem, "Id");
        this.type = DOMUtils.getAttributeValue(this.localEncDataElem, "Type");
        this.mimeType = DOMUtils.getAttributeValue(this.localEncDataElem, "MimeType");
        this.encoding = DOMUtils.getAttributeValue(this.localEncDataElem, "Encoding");
        Element elem = DOMUtils.getFirstChildElement(this.localEncDataElem);
        if (elem == null) {
            throw new MarshalException("Missing CipherData element in EncryptedData");
        }
        String localName = elem.getLocalName();
        if (localName.equals("EncryptionMethod")) {
            this.em = (DOMEncryptionMethod)DOMEncryptionMethod.unmarshal(elem);
            elem = DOMUtils.getNextSiblingElement(elem);
        }
        if (elem == null) {
            throw new MarshalException("Missing CipherData element in EncryptedData");
        }
        localName = elem.getLocalName();
        if (localName == null) {
            localName = elem.getNodeName();
        }
        if (localName.equals("KeyInfo")) {
            this.ki = new DOMKeyInfo(elem, context);
            elem = DOMUtils.getNextSiblingElement(elem);
        }
        if (elem == null) {
            throw new MarshalException("Missing CipherData element in EncryptedData");
        }
        this.cd = DOMCipherData.getInstance(elem, context);
        if ((elem = DOMUtils.getNextSiblingElement(elem)) != null) {
            this.eps = new DOMEncryptionProperties(elem);
            elem = DOMUtils.getNextSiblingElement(elem);
        }
        if (elem != null) {
            throw new MarshalException("Extra element in EncryptedData");
        }
    }

    public DOMEncryptedData(String id, String type, String mimeType, String encoding, DOMEncryptionMethod em, DOMKeyInfo ki, DOMCipherData cdata, DOMEncryptionProperties ep, Element localEncDataElem) throws MarshalException {
        this.id = id;
        this.type = type;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.em = em;
        this.ki = ki;
        this.cd = cdata;
        this.eps = ep;
        this.localEncDataElem = localEncDataElem;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.em;
    }

    public KeyInfo getKeyInfo() {
        return this.ki;
    }

    public CipherData getCipherData() {
        return this.cd;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.eps;
    }

    public InputStream getCipherText() {
        if (this.encryptedBytes != null) {
            ByteArrayInputStream cipherText = new ByteArrayInputStream((byte[])this.encryptedBytes.clone());
            return cipherText;
        }
        if (this.cd != null && this.cd instanceof CipherReference) {
            try {
                return ((DOMCipherReference)this.cd).getCipherValue();
            }
            catch (XMLEncryptionException ex) {
                if (debug != null) {
                    debug.trace("DOMEncryptedData", "getCipherText", ex);
                }
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public ToBeEncrypted getToBeEncrypted() {
        return this.toBeEncrypted;
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, encPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String encPrefix, DOMCryptoContext context) throws MarshalException {
        if (parent == null) {
            throw new MarshalException("parent node can not be null");
        }
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element encDataElem = DOMUtils.createElement(ownerDoc, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        if (encPrefix == null) {
            encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2001/04/xmlenc#");
        } else {
            encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + encPrefix, "http://www.w3.org/2001/04/xmlenc#");
        }
        if (this.em != null) {
            this.em.marshal(encDataElem, encPrefix, context);
        }
        if (this.ki != null) {
            this.ki.marshal(encDataElem, encPrefix, context);
        }
        this.cd.marshal(encDataElem, encPrefix, context);
        if (this.eps != null) {
            this.eps.marshal(encDataElem, encPrefix, context);
        }
        if (this.id != null) {
            DOMUtils.setAttributeID(encDataElem, "Id", this.id);
        }
        if (this.type != null) {
            DOMUtils.setAttributeID(encDataElem, "Type", this.type);
        }
        if (this.mimeType != null) {
            DOMUtils.setAttributeID(encDataElem, "MimeType", this.mimeType);
        }
        if (this.encoding != null) {
            DOMUtils.setAttributeID(encDataElem, "Encoding", this.encoding);
        }
        parent.insertBefore(encDataElem, nextSibling);
    }

    public void decryptAndReplace(XMLDecryptContext decryptContext) throws XMLEncryptionException {
        if (decryptContext == null) {
            throw new NullPointerException("context is null");
        }
        if (this.type != null && !this.type.equals("http://www.w3.org/2001/04/xmlenc#Element") && !this.type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            throw new XMLEncryptionException("Cannot decrypt and replace non-Element or non-content type");
        }
        InputStream is = this.decrypt(decryptContext);
        if (is != null) {
            Node parent = this.localEncDataElem.getParentNode();
            Document ownerDoc = parent.getOwnerDocument();
            String temp = new String(this.decrypted).trim();
            StringBuffer sb = new StringBuffer();
            sb.append("<temp>");
            sb.append(temp);
            sb.append("</temp>");
            ByteArrayInputStream is2 = new ByteArrayInputStream(sb.toString().getBytes());
            if (sb.toString().startsWith("<")) {
                if (debug != null) {
                    debug.trace("DOMEncryptedData", "decryptAndReplace", "decrypted data starts with <");
                }
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document d = db.parse(is2);
                    NodeList nlist = d.getChildNodes();
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "decryptAndReplace", "node list length=" + nlist.getLength());
                        debug.trace("DOMEncryptedData", "decryptAndReplace", "nodename=" + nlist.item(0).getNodeName());
                    }
                    NodeList nlist2 = nlist.item(0).getChildNodes();
                    int length = nlist2.getLength();
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "decryptAndReplace", "child node list length=" + nlist2.getLength());
                    }
                    for (int i = 0; i < length; ++i) {
                        if (debug != null) {
                            debug.trace("DOMEncryptedData", "decryptAndReplace", "node name to import=" + nlist2.item(i).getNodeName());
                        }
                        Node newNode = ownerDoc.importNode(nlist2.item(i), true);
                        parent.insertBefore(newNode, this.localEncDataElem);
                    }
                    parent.removeChild(this.localEncDataElem);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "decryptAndReplace", e);
                    }
                    if (e instanceof SAXParseException) {
                        try {
                            String text = new String(this.decrypted);
                            Text t = ownerDoc.createTextNode(text);
                            parent.replaceChild(t, this.localEncDataElem);
                        }
                        catch (Exception ex) {
                            if (debug != null) {
                                debug.trace("DOMEncryptedData", "decryptAndReplace", ex);
                            }
                            throw new XMLEncryptionException((Throwable)ex);
                        }
                    }
                    throw new XMLEncryptionException((Throwable)e);
                }
            } else {
                if (debug != null) {
                    debug.trace("DOMEncryptedData", "decryptAndReplace", ">>>>not starts with <");
                }
                try {
                    String text = new String(this.decrypted);
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "decryptAndReplace", ">>>create string " + text);
                    }
                    Text t = ownerDoc.createTextNode(text);
                    parent.replaceChild(t, this.localEncDataElem);
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "decryptAndReplace", ex);
                    }
                    throw new XMLEncryptionException((Throwable)ex);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public InputStream decrypt(XMLDecryptContext decryptContext) throws XMLEncryptionException {
        if (decryptContext == null) {
            throw new NullPointerException("decryptContext is null");
        }
        if (this.isDecrypted) {
            return new ByteArrayInputStream(this.decrypted);
        }
        encryptedValue = null;
        if (this.cd == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
        if (this.cd instanceof CipherReference) {
            cref = (DOMCipherReference)this.cd;
            is = cref.getCipherValue((XMLCryptoContext)decryptContext);
            if (is == null) {
                throw new XMLEncryptionException("Dereferencing CipherReference returned null");
            }
            try {
                encryptedValue = new byte[is.available()];
                is.read(encryptedValue);
                if (DOMEncryptedData.debug == null) ** GOTO lbl30
                DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", new HexDumpEncoder().encode(encryptedValue));
            }
            catch (IOException io) {
                if (DOMEncryptedData.debug != null) {
                    DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", io);
                }
                throw new XMLEncryptionException((Throwable)io);
            }
            catch (RuntimeException re) {
                if (DOMEncryptedData.debug != null) {
                    DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", re);
                }
                throw new XMLEncryptionException((Throwable)re);
            }
        } else if (this.cd instanceof CipherValue) {
            encryptedValue = ((CipherValue)this.cd).getValue();
        }
lbl30:
        // 5 sources

        em = this.getEncryptionMethod((XMLCryptoContext)decryptContext);
        try {
            this.decrypted = em.decrypt(decryptContext.getKeySelector().select(this.ki, KeySelector.Purpose.DECRYPT, (AlgorithmMethod)em, (XMLCryptoContext)decryptContext).getKey(), encryptedValue);
        }
        catch (KeySelectorException kse) {
            if (DOMEncryptedData.debug != null) {
                DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", kse);
            }
            throw new XMLEncryptionException((Throwable)kse);
        }
        catch (InvalidKeyException ike) {
            if (DOMEncryptedData.debug != null) {
                DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", ike);
            }
            throw new XMLEncryptionException((Throwable)ike);
        }
        catch (BadPaddingException bpe) {
            if (DOMEncryptedData.debug != null) {
                DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", bpe);
            }
            throw new XMLEncryptionException((Throwable)bpe);
        }
        catch (IllegalBlockSizeException ibse) {
            if (DOMEncryptedData.debug != null) {
                DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", ibse);
            }
            throw new XMLEncryptionException((Throwable)ibse);
        }
        catch (RuntimeException re) {
            if (DOMEncryptedData.debug != null) {
                DOMEncryptedData.debug.trace("DOMEncryptedData", "decrypt", re);
            }
            throw new XMLEncryptionException((Throwable)re);
        }
        this.isDecrypted = true;
        return new ByteArrayInputStream(this.decrypted);
    }

    private DOMEncryptionMethod getEncryptionMethod(XMLCryptoContext context) throws XMLEncryptionException {
        if (this.em != null) {
            return this.em;
        }
        EncryptionMethod em2 = null;
        if (context instanceof XMLDecryptContext) {
            em2 = ((XMLDecryptContext)context).getEncryptionMethod();
        } else if (context instanceof XMLEncryptContext) {
            em2 = ((XMLEncryptContext)context).getEncryptionMethod();
        }
        if (em2 != null) {
            DOMEncryptionMethod dem = null;
            if (em2 instanceof DOMEncryptionMethod) {
                dem = (DOMEncryptionMethod)em2;
            } else {
                try {
                    dem = (DOMEncryptionMethod)((Object)DOMEncManager.getEncryptionMethod(em2.getAlgorithm(), em2.getKeySize(), em2.getParameterSpec()));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "decrypt", ex);
                    }
                    throw new XMLEncryptionException((Throwable)ex);
                }
            }
            return dem;
        }
        throw new XMLEncryptionException("no encryption method");
    }

    public void encrypt(XMLEncryptContext encryptContext) throws MarshalException, XMLEncryptionException {
        if (debug != null) {
            debug.entry("DOMEncryptedData", "encrypt");
        }
        if (encryptContext == null) {
            throw new NullPointerException("encryptContext cannot be null");
        }
        if (!(encryptContext instanceof DOMEncryptContext)) {
            throw new XMLEncryptionException("encryptContext must be of type DOMEncryptContext");
        }
        if (this.toBeEncrypted == null) {
            throw new XMLEncryptionException("toBeEncrypted is null");
        }
        DOMEncryptContext context = (DOMEncryptContext)encryptContext;
        byte[] toBeEncryptedBytes = null;
        if (this.toBeEncrypted instanceof ToBeEncryptedOctetStream) {
            if (debug != null) {
                debug.trace("DOMEncryptedData", "encrypt", "ToBeEncryptedOctetStream");
            }
            InputStream is = ((ToBeEncryptedOctetStream)this.toBeEncrypted).getInputStream();
            try {
                toBeEncryptedBytes = new byte[is.available()];
                is.read(toBeEncryptedBytes);
            }
            catch (IOException ex) {
                throw new XMLEncryptionException((Throwable)ex);
            }
        }
        if (debug != null) {
            debug.trace("DOMEncryptedData", "encrypt", "ToBeEncryptedXML");
        }
        NodeList nodes = ((DOMToBeEncryptedXML)this.toBeEncrypted).getNodeList();
        int size = nodes.getLength();
        ArrayList<byte[]> list = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TreeNodeSetData tree = new TreeNodeSetData(nodes.item(i), true, null);
            try {
                OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                DOMEncryptedData.serializeNode(tree.getTopNode(), tree.getTopNode(), tree.getOmittedNode(), tree.isWithComments(), true, wr);
                ((Writer)wr).close();
                baos.close();
            }
            catch (IOException ie) {
                throw new XMLEncryptionException((Throwable)ie);
            }
            list.add(baos.toByteArray());
        }
        int byteslen = 0;
        for (int i = 0; i < list.size(); ++i) {
            byteslen += ((byte[])list.get(i)).length;
        }
        toBeEncryptedBytes = new byte[byteslen];
        int start = 0;
        for (int i = 0; i < list.size(); ++i) {
            System.arraycopy(list.get(i), 0, toBeEncryptedBytes, start, ((byte[])list.get(i)).length);
            start += ((byte[])list.get(i)).length;
        }
        KeySelector ks = encryptContext.getKeySelector();
        Key encryptionKey = null;
        DOMEncryptionMethod dem = this.getEncryptionMethod((XMLCryptoContext)context);
        try {
            encryptionKey = ks.select(this.ki, KeySelector.Purpose.ENCRYPT, (AlgorithmMethod)((Object)dem), (XMLCryptoContext)context).getKey();
        }
        catch (KeySelectorException kse) {
            if (debug != null) {
                debug.trace("DOMEncryptedData", "encrypt", kse);
            }
            throw new XMLEncryptionException((Throwable)kse);
        }
        byte[] ebytes = null;
        try {
            ebytes = dem.encrypt(encryptionKey, toBeEncryptedBytes, (EncryptedType)this);
        }
        catch (Exception ee) {
            if (debug != null) {
                debug.trace("DOMEncryptedData", "encrypt", ee);
            }
            throw new XMLEncryptionException((Throwable)ee);
        }
        if (debug != null) {
            debug.trace("DOMEncryptedData", "encrypt", "EncryptedData = " + this.encryptedBytes);
        }
        if (this.cd == null) {
            this.cd = new DOMCipherValue(ebytes);
        } else {
            this.encryptedBytes = ebytes;
        }
        this.marshal(context.getParent(), context.getNextSibling(), context.getDefaultNamespacePrefix(), (DOMCryptoContext)context);
        if (debug != null) {
            debug.exit("DOMEncryptedData", "encrypt");
        }
    }

    public boolean equals(Object o) {
        boolean encodingEqual;
        boolean mimeTypeEqual;
        boolean typeEqual;
        boolean epsEquals;
        boolean cipherDataEqual;
        boolean encMethodEqual;
        boolean keyInfoEqual;
        boolean idEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedData)) {
            return false;
        }
        EncryptedData oenc = (EncryptedData)o;
        boolean bl = this.id == null ? oenc.getId() == null : (idEqual = this.id.equals(oenc.getId()));
        if (!idEqual) {
            return false;
        }
        boolean bl2 = this.ki == null ? oenc.getKeyInfo() == null : (keyInfoEqual = this.ki.equals(oenc.getKeyInfo()));
        if (!keyInfoEqual) {
            return false;
        }
        boolean bl3 = this.em == null ? oenc.getEncryptionMethod() == null : (encMethodEqual = this.em.equals(oenc.getEncryptionMethod()));
        if (!encMethodEqual) {
            return false;
        }
        boolean bl4 = this.cd == null ? oenc.getCipherData() == null : (cipherDataEqual = this.cd.equals(oenc.getCipherData()));
        if (!cipherDataEqual) {
            return false;
        }
        boolean bl5 = this.eps == null ? oenc.getEncryptionProperties() == null : (epsEquals = this.eps.equals(oenc.getEncryptionProperties()));
        if (!epsEquals) {
            return false;
        }
        boolean bl6 = this.type == null ? oenc.getType() == null : (typeEqual = this.type.equals(oenc.getType()));
        if (!typeEqual) {
            return false;
        }
        boolean bl7 = this.mimeType == null ? oenc.getMimeType() == null : (mimeTypeEqual = this.mimeType.equals(oenc.getMimeType()));
        if (!mimeTypeEqual) {
            return false;
        }
        boolean bl8 = this.encoding == null ? oenc.getEncoding() == null : (encodingEqual = this.encoding.equals(oenc.getEncoding()));
        return encodingEqual;
    }

    private static void serializeSubset(Stack stack, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof C14nUtil.Attributes) {
            C14nUtil.Attributes ancestorAttrs = stack.empty() ? null : (C14nUtil.Attributes)stack.peek();
            ((C14nUtil.Attributes)obj).serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, i);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            DOMEncryptedData.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        C14nUtil.Attributes ancestorAttrs = stack.empty() ? null : (C14nUtil.Attributes)stack.peek();
        C14nUtil.Attributes attrs = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node) {
            parent = node.getParentNode();
            if (parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            attrs = (C14nUtil.Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns") && (parent = node.getParentNode()).getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!C14nUtil.isAncestor(nodeVector.elementAt(next), node)) break;
            DOMEncryptedData.serializeSubset(stack, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        String nodename = node.getNodeName();
        if (debug != null) {
            debug.trace("DOMEncryptedData", "serializeSubset", "nodename=" + nodename);
        }
        wr.write(nodename);
        wr.write(">");
    }

    private static boolean inNodeList(Node node, NodeList list) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i) != node) continue;
            return true;
        }
        return false;
    }

    static void serializeNode(Node topNode, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        DOMEncryptedData.serializeNode(topNode, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(Node topNode, Stack stack, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        if (exceptedNode == node) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                wr.write("<");
                wr.write(node.getNodeName());
                DOMEncryptedData.serializeAttributes(topNode, stack, (Element)node, xmlAttributes, wr);
                wr.write(">");
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (debug != null) {
                        debug.trace("DOMEncryptedData", "serializeNode", "child.getLocalName=" + child.getLocalName());
                    }
                    DOMEncryptedData.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                stack.pop();
                wr.write("</");
                wr.write(node.getNodeName());
                wr.write(">");
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), wr);
                break;
            }
            case 5: 
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    DOMEncryptedData.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                break;
            }
            case 7: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 8: {
                if (!withComments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                String an = node.getNodeName();
                C14nUtil.serializeAttribute(node, wr, an.equals("xmlns") || an.startsWith("xmlns:"));
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node startNode) {
        NamedNodeMap attributeList;
        Hashtable<String, Attr> attrs = null;
        for (Node node = startNode.getParentNode(); node != null; node = node.getParentNode()) {
            NamedNodeMap attributeList2 = node.getAttributes();
            if (attributeList2 == null) continue;
            int nAttrs = attributeList2.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList2.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || attrs != null && attrs.containsKey(attrName)) continue;
                if (attrs == null) {
                    attrs = new Hashtable<String, Attr>();
                }
                attrs.put(attrName, attr);
            }
        }
        if (attrs != null && (attributeList = startNode.getAttributes()) != null) {
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || !attrs.containsKey(attrName)) continue;
                attrs.remove(attrName);
            }
        }
        return attrs;
    }

    private static void serializeAttributes(Node topNode, Stack stack, Element element, boolean xmlAttributes, Writer wr) throws IOException {
        Hashtable nsattrs = DOMEncryptedData.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap nnm = element.getAttributes();
        int atlen = nnm.getLength();
        for (int i = 0; i < atlen; ++i) {
            nsattrs.put(nnm.item(i).getNodeName(), nnm.item(i));
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        Attr[] attrs = new Attr[atlen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            Attr attr = (Attr)en.nextElement();
            indexMap[i] = i;
            attrs[i] = attr;
            as[i] = C14nUtil.createSortedString(attr, element);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, atlen);
        for (int j = 0; j < atlen; ++j) {
            Attr xa;
            Attr a = attrs[indexMap[j]];
            String attrName = a.getNodeName();
            boolean checkURI = false;
            if (attrName.equals("xmlns:xml")) continue;
            if (attrName.equals("xmlns") && a.getNodeValue().length() == 0) {
                if (DOMEncryptedData.isTopElement(topNode, element)) continue;
                boolean found = false;
                for (int depth = stack.size() - 1; depth >= 0; --depth) {
                    Hashtable attrs2 = (Hashtable)stack.elementAt(depth);
                    Attr attr = (Attr)attrs2.get("xmlns");
                    if (attr == null || attr.getNodeValue().length() <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                Attr nsa;
                checkURI = true;
                if (parentAttrs != null && (nsa = (Attr)parentAttrs.get(attrName)) != null && nsa.getNodeValue().equals(a.getNodeValue())) {
                    continue;
                }
            } else if (attrName.startsWith("xml:") && parentAttrs != null && (xa = (Attr)parentAttrs.get(attrName)) != null && xa.getNodeValue().equals(a.getNodeValue())) continue;
            C14nUtil.serializeAttribute(a, wr, checkURI);
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node startNode, boolean useProxy) {
        Node node = startNode;
        Hashtable<String, Attr> nsnodes = new Hashtable<String, Attr>();
        Document factory = startNode.getOwnerDocument();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            Attr xa;
            if (useProxy) {
                xa = new TransformUtil.AttrProxy(startNode, factory, "http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
            } else {
                xa = factory.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml");
                xa.setNodeValue("http://www.w3.org/XML/1998/namespace");
            }
            nsnodes.put("xmlns:xml", xa);
        }
        do {
            NamedNodeMap attributeList;
            if ((attributeList = node.getAttributes()) == null) continue;
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr newAttr;
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || nsnodes.containsKey(attrName)) continue;
                if (node == startNode) {
                    nsnodes.put(attrName, attr);
                    continue;
                }
                if (useProxy) {
                    newAttr = new TransformUtil.AttrProxy(startNode, factory, "http://www.w3.org/2000/xmlns/", attrName, attr.getNodeValue());
                } else {
                    newAttr = factory.createAttributeNS("http://www.w3.org/2000/xmlns/", attrName);
                    newAttr.setNodeValue(attr.getNodeValue());
                }
                nsnodes.put(attrName, newAttr);
            }
        } while ((node = node.getParentNode()) != null);
        return nsnodes;
    }

    private static boolean isTopElement(Node topNode, Element element) {
        if (topNode == element) {
            return true;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            switch (parent.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    parent = parent.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + parent.getNodeType());
        }
        return true;
    }
}

