/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.update.configurator.ConfigurationActivator;
import com.ibm.cic.agent.internal.installAdaptors.BundleEntry;
import com.ibm.cic.agent.internal.installAdaptors.BundleFile;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.agent.internal.installAdaptors.EclipseConfigureOperation;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseIdVersionData;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public abstract class EclipseBundleOperation
extends EclipseConfigureOperation {
    protected Collection artifacts;

    public EclipseBundleOperation(Collection artifacts, IInstallableUnit unit, InstallContext context, ConfigurationContributorEditor targetedConfig, boolean configure) {
        super(unit, context, targetedConfig, configure);
        this.artifacts = artifacts;
    }

    protected abstract boolean isMatchingArtifact(IArtifact var1);

    protected BundleInfo getInfo(EclipseBundleData data) throws CoreException {
        String location;
        if (this.isConfigure()) {
            BundleEntry entry = this.getBundleEntry((EclipseIdVersionData)data);
            location = entry.getLocalURL().toExternalForm();
        } else {
            location = this.getLocation((EclipseIdVersionData)data, "plugins", data.getExploded());
        }
        BundleInfo info = new BundleInfo();
        info.setSymbolicName(data.getId());
        info.setVersion(data.getVersion().toString());
        info.setLocation(location);
        info.setStartLevel(data.getStartLevel());
        info.setExpectedState(data.getExpectedState());
        info.setSingleton(data.isSingleton());
        return info;
    }

    protected BundleEntry getBundleEntry(EclipseIdVersionData data) throws CoreException {
        File bundleLocation;
        IArtifact artifact = this.findArtifact(data.getId(), data.getVersion());
        if (artifact == null) {
            String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_missing_artifact_for_bundle_or_feature, (Object)data.getId(), (Object)data.getVersion());
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, null));
        }
        try {
            bundleLocation = CacheManager.getDefaultInstance().getArtifactLocation(this.getUnit(), artifact, null);
        }
        catch (CacheManager.CacheManagerException e) {
            String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_error_getting_artifact_location, (Object)e.getMessage());
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
        }
        return this.createBundleEntry(bundleLocation);
    }

    private IArtifact findArtifact(String id, Version version) {
        for (IArtifact artifact : this.artifacts) {
            IArtifactKey key = artifact.getKey();
            if (!key.getId().getId().equals(id) || !key.getVersion().equals((Object)version) || !this.isMatchingArtifact(artifact)) continue;
            return artifact;
        }
        return null;
    }

    private BundleEntry createBundleEntry(File backingFile) throws CoreException {
        String path = backingFile.getName();
        File parentFile = backingFile.getParentFile();
        BundleFile bundleFile = null;
        try {
            bundleFile = parentFile.isDirectory() ? new BundleFile.DirBundleFile(parentFile) : new BundleFile.ZipBundleFile(parentFile);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_error_creating_bundlefile_for_path, (Object)e.getMessage());
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
        }
        BundleEntry entry = bundleFile.getEntry(path);
        if (entry == null) {
            String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_error_creating_bundlefile_for_path, (Object)path);
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, null));
        }
        return entry;
    }

    protected String getLocation(EclipseIdVersionData data, String dirName, boolean isExploded) {
        String loc;
        File cacheLocation = CacheManager.getDefaultInstance().getCacheLocation();
        File dir = new File(cacheLocation, dirName);
        String name = String.valueOf(data.getId()) + '_' + data.getVersion();
        if (!isExploded) {
            name = String.valueOf(name) + CicConstants.getJarFileDotExt();
        }
        File location = new File(dir, name);
        try {
            loc = FileURLUtil.toUnescapedFileURL((File)location).toString();
        }
        catch (MalformedURLException malformedURLException) {
            loc = String.valueOf(dirName) + '/' + name;
        }
        return loc;
    }

    protected static void refreshPackages(Bundle[] bundles, BundleContext context) {
        ConfigurationActivator.refreshPackages((Bundle[])bundles, (BundleContext)context);
    }
}

