/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.internal.eclipse.qualification.PlatformConfigurationState;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.FeatureInfo;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class ConfigurationValidator {
    public static IStatus validateConfiguration(ConfigurationEditor editor, int severity, IProgressMonitor monitor) {
        BundleInfo[] infos = editor.getBundles();
        if (infos.length == 0) {
            return Status.OK_STATUS;
        }
        File configDir = editor.getConfigurationLocation();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 4);
        try {
            IStatus status = ConfigurationValidator.checkForMissingFeaturesAndBundles(editor, severity, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            PlatformConfigurationState configState = new PlatformConfigurationState();
            status = configState.init(configDir, infos, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = ConfigurationValidator.checkForUnsatisfiedConstraints(configState.getState(), severity, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = editor.validateOsgiBundlesProperty(severity, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
        }
        catch (Exception e) {
            Status status = new Status(severity, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.EclipseInstallAdaptor_problemValidatingEclipseInstallation, (Object)configDir.toString(), (Object)e.toString()), (Throwable)e);
            return status;
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkForMissingFeaturesAndBundles(ConfigurationEditor editor, int severity, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.ConfigurationValidator_missingFeaturesOrBundles, new Object[0]);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        try {
            ConfigurationValidator.checkForMissingFeatures(status, editor, severity, pm.next());
            ConfigurationValidator.checkForMissingBundles(status, editor, severity, pm.next());
        }
        finally {
            pm.done();
        }
        return status;
    }

    public static void checkForMissingFeatures(CicMultiStatus status, ConfigurationEditor editor, int severity, IProgressMonitor monitor) {
        FeatureInfo[] infos = editor.getFeatures();
        monitor.beginTask("", infos.length);
        try {
            FeatureInfo[] featureInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureInfo info = featureInfoArray[n2];
                String location = info.getLocation();
                File file = null;
                try {
                    URL url = new URL(location);
                    file = new File(url.getFile());
                }
                catch (MalformedURLException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                if (file == null || !file.exists()) {
                    String msg = NLS.bind((String)Messages.ConfigurationValidator_featureNotFound, (Object)(file == null ? location : FileUtil.getCanonicalPath((File)file)));
                    status.add((IStatus)new Status(severity, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, msg, null));
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void checkForMissingBundles(CicMultiStatus status, ConfigurationEditor editor, int severity, IProgressMonitor monitor) {
        BundleInfo[] infos = editor.getBundles();
        monitor.beginTask("", infos.length);
        try {
            BundleInfo[] bundleInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                BundleInfo info = bundleInfoArray[n2];
                String location = info.getLocation();
                File file = null;
                try {
                    URL url = new URL(location);
                    file = new File(url.getFile());
                }
                catch (MalformedURLException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                if ((file == null || !file.exists()) && editor.isManagedBundle(info)) {
                    String msg = NLS.bind((String)Messages.ConfigurationValidator_bundleNotFound, (Object)(file == null ? location : FileUtil.getCanonicalPath((File)file)));
                    status.add((IStatus)new Status(severity, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, msg, null));
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static IStatus checkForUnsatisfiedConstraints(State state, int severity, IProgressMonitor monitor) {
        return ConfigurationValidator.checkForUnsatisfiedConstraints(Messages.EclipseInstallAdaptor_unsatisfiedConstraintsWarning, Messages.EclipseInstallAdaptor_unsatisfiedConstraintsError, Messages.EclipseInstallAdaptor_unsatisfiedConstraintWarning, Messages.EclipseInstallAdaptor_unsatisfiedConstraintError, state, severity, monitor);
    }

    public static IStatus checkForUnsatisfiedConstraints(String unsatisfiedConstraintsMsgWarning, String unsatisfiedConstraintsMsgError, String unsatisfiedConstraintMsgWarning, String unsatisfiedConstraintMsgError, State state, int severity, IProgressMonitor monitor) {
        CicMultiStatus status = severity == 2 ? Statuses.WARNING.getMultiStatus(unsatisfiedConstraintsMsgWarning, new Object[0]) : Statuses.ERROR.getMultiStatus(unsatisfiedConstraintsMsgError, new Object[0]);
        VersionConstraint[] constraints = state.getStateHelper().getUnsatisfiedLeaves(state.getBundles());
        monitor.beginTask("", constraints.length);
        try {
            VersionConstraint[] versionConstraintArray = constraints;
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                VersionConstraint constraint = versionConstraintArray[n2];
                if ((constraint instanceof BundleSpecification || constraint instanceof HostSpecification) && !ConfigurationValidator.isOptionalConstraint(constraint)) {
                    VersionRange tolerance = constraint.getVersionRange();
                    String requiredBundleId = constraint.getName();
                    String requiredByBundleId = constraint.getBundle().getName();
                    if (tolerance != null && !tolerance.equals((Object)VersionRange.emptyRange)) {
                        String requiredBundleIdAndVersion = ConfigurationValidator.getVersionedBundleId(state, requiredBundleId);
                        if (!requiredBundleIdAndVersion.equals(requiredBundleId)) {
                            if (severity == 2) {
                                status.add((IStatus)Statuses.WARNING.get(unsatisfiedConstraintMsgWarning, new Object[]{requiredBundleIdAndVersion, requiredByBundleId, tolerance}));
                            } else {
                                status.add((IStatus)Statuses.ERROR.get(unsatisfiedConstraintMsgError, new Object[]{requiredBundleIdAndVersion, requiredByBundleId, tolerance}));
                            }
                        } else if (severity == 2) {
                            status.add((IStatus)Statuses.WARNING.get(Messages.EclipseInstallAdaptor_unresolvedBundleWarning, new Object[]{requiredBundleId, requiredByBundleId}));
                        } else {
                            status.add((IStatus)Statuses.ERROR.get(Messages.EclipseInstallAdaptor_unresolvedBundleError, new Object[]{requiredBundleId, requiredByBundleId}));
                        }
                    } else if (severity == 2) {
                        status.add((IStatus)Statuses.WARNING.get(Messages.EclipseInstallAdaptor_unresolvedBundleWarning, new Object[]{requiredBundleId, requiredByBundleId}));
                    } else {
                        status.add((IStatus)Statuses.ERROR.get(Messages.EclipseInstallAdaptor_unresolvedBundleError, new Object[]{requiredBundleId, requiredByBundleId}));
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        status.add(Status.CANCEL_STATUS);
                        break;
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return status.getChildren().length > 0 ? status : Statuses.OK.getMultiStatus();
    }

    public static boolean isOptionalConstraint(VersionConstraint constraint) {
        if (constraint instanceof BundleSpecification) {
            BundleSpecification spec = (BundleSpecification)constraint;
            return spec.isOptional();
        }
        return false;
    }

    public static String getVersionedBundleId(State state, String bundleId) {
        BundleDescription[] bundles = state.getBundles(bundleId);
        Version maxVersion = null;
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription description = bundleDescriptionArray[n2];
            Version version = description.getVersion();
            if (maxVersion == null) {
                maxVersion = version;
            } else if (maxVersion.compareTo(version) < 0) {
                maxVersion = version;
            }
            ++n2;
        }
        if (maxVersion == null) {
            return bundleId;
        }
        return String.valueOf(bundleId) + '_' + maxVersion.toString();
    }
}

