/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class BundleRegistry {
    private static final Logger log = Logger.getLogger(BundleRegistry.class);
    private final File storageFile;
    protected LinkedHashMap bundles = new LinkedHashMap();
    private boolean isDirty = false;
    private final LinkedHashSet possiblyErroneousBundles = new LinkedHashSet();

    protected BundleRegistry(InstallContext context) {
        this.storageFile = new File(context.getAdapterStorage("eclipse"), "bundles.properties");
    }

    public BundleInfo add(BundleInfo info, IInstallableUnit unit) {
        String bundleId = info.getSymbolicName();
        LinkedHashMap<String, BundleInfoEx> contributions = (LinkedHashMap<String, BundleInfoEx>)this.bundles.get(bundleId);
        if (contributions == null) {
            contributions = new LinkedHashMap<String, BundleInfoEx>();
            this.bundles.put(bundleId, contributions);
        }
        BundleInfoEx formerLatestInfo = this.getLatestSingletonVersion(contributions);
        String versionedUnitId = this.getUnitId(unit);
        BundleInfoEx copiedInfo = this.copyBundleInfo(info);
        if (copiedInfo.isSingleton()) {
            if (formerLatestInfo == null) {
                if (!contributions.isEmpty()) {
                    this.possiblyErroneousBundles.add(copiedInfo);
                }
            } else if (!this.isEquivalent(formerLatestInfo, copiedInfo)) {
                this.possiblyErroneousBundles.add(copiedInfo);
            }
        } else if (formerLatestInfo != null) {
            this.possiblyErroneousBundles.add(copiedInfo);
        }
        contributions.put(versionedUnitId, copiedInfo);
        this.markDirty();
        if (!copiedInfo.isSingleton()) {
            return null;
        }
        if (BundleRegistry.shouldReplace(copiedInfo, formerLatestInfo)) {
            return formerLatestInfo;
        }
        return info;
    }

    public List getAllConfiguredBundleInfos() {
        ArrayList<BundleInfoEx> allLatestBundleInfos = new ArrayList<BundleInfoEx>();
        for (Map.Entry entry : this.bundles.entrySet()) {
            Map contributions = (Map)entry.getValue();
            BundleInfoEx latestBundleInfo = this.getLatestSingletonVersion(contributions);
            if (latestBundleInfo != null) {
                allLatestBundleInfos.add(latestBundleInfo);
            }
            Collection values = contributions.values();
            for (BundleInfoEx info : values) {
                if (info.isSingleton()) continue;
                allLatestBundleInfos.add(info);
                info.getLocation();
            }
        }
        return allLatestBundleInfos;
    }

    public BundleInfo remove(BundleInfo info, IInstallableUnit unit) {
        BundleInfoEx latestInfo;
        String bundleId = info.getSymbolicName();
        Map contributions = (Map)this.bundles.get(bundleId);
        if (contributions == null) {
            return null;
        }
        String versionedUnitId = this.getUnitId(unit);
        BundleInfoEx removedInfo = (BundleInfoEx)contributions.remove(versionedUnitId);
        if (removedInfo == null) {
            return null;
        }
        this.markDirty();
        if (contributions.isEmpty()) {
            this.bundles.remove(bundleId);
            latestInfo = null;
        } else {
            latestInfo = this.getLatestSingletonVersion(contributions);
        }
        if (latestInfo == null || !removedInfo.isSingleton()) {
            if (this.isConfiguredNonSingletonVersion(contributions, removedInfo.getVersion()) || latestInfo != null && removedInfo.getVersion().equals(latestInfo.getVersion())) {
                return info;
            }
            return null;
        }
        if (BundleRegistry.shouldReplace(removedInfo, latestInfo)) {
            return latestInfo;
        }
        return info;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void checkForErroneousBundles() throws CoreException {
        if (!this.isDirty) {
            return;
        }
        for (BundleInfoEx info : this.possiblyErroneousBundles) {
            String bundleId = info.getSymbolicName();
            Map contributions = (Map)this.bundles.get(bundleId);
            if (contributions == null) continue;
            if (info.isSingleton()) {
                this.checkForNonSingletonBundles(info, bundleId, contributions);
                this.checkForNonequivalentBundles(info, bundleId, contributions);
                continue;
            }
            this.checkForSingletonBundles(info, bundleId, contributions);
        }
        this.possiblyErroneousBundles.clear();
    }

    public void store() throws CoreException {
        if (!this.isDirty) {
            return;
        }
        Properties props = new Properties();
        for (Map.Entry entry : this.bundles.entrySet()) {
            String bundleId = (String)entry.getKey();
            Map contributions = (Map)entry.getValue();
            props.setProperty(bundleId, this.serializeContributions(contributions));
        }
        this.storageFile.getParentFile().mkdirs();
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(this.storageFile);
                props.store(stream, null);
                this.isDirty = false;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
                }
            }
        }
    }

    public boolean load() throws CoreException {
        if (!this.storageFile.isFile()) {
            return false;
        }
        Properties props = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(this.storageFile);
                props.load(stream);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
                }
            }
        }
        this.bundles = new LinkedHashMap(props.size());
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> element;
            Map.Entry<Object, Object> entry = element = iterator.next();
            String bundleId = (String)entry.getKey();
            String contributionsText = (String)entry.getValue();
            this.bundles.put(bundleId, this.deserializeContributions(bundleId, contributionsText));
        }
        return true;
    }

    private void markDirty() {
        this.isDirty = true;
    }

    private static boolean shouldReplace(BundleInfoEx info1, BundleInfoEx info2) {
        if (info2 == null) {
            return true;
        }
        int cmp = info1.getOsgiVersion().compareTo(info2.getOsgiVersion());
        return cmp > 0 || cmp == 0 && !info1.getLocation().equals(info2.getLocation());
    }

    private BundleInfoEx getLatestSingletonVersion(Map contributions) {
        Collection values = contributions.values();
        BundleInfoEx result = null;
        for (BundleInfoEx info : values) {
            if (!info.isSingleton() || !BundleRegistry.shouldReplace(info, result)) continue;
            result = info;
        }
        if (result != null) {
            result.getLocation();
        }
        return result;
    }

    private String getUnitId(IInstallableUnit unit) {
        return String.valueOf(unit.getParent().getIdentity().getId()) + ';' + IdentityUtil.getVersionedId((IContent)unit);
    }

    private boolean isEquivalent(BundleInfoEx info1, BundleInfoEx info2) {
        Version version1 = info1.getOsgiVersion();
        Version version2 = info2.getOsgiVersion();
        return version1.getMajor() == version2.getMajor() && version1.getMinor() == version2.getMinor();
    }

    private String serializeContributions(Map contributions) {
        StringBuffer sb = new StringBuffer();
        Set set = contributions.entrySet();
        for (Map.Entry entry : set) {
            String versionedUnitId = (String)entry.getKey();
            BundleInfoEx info = (BundleInfoEx)entry.getValue();
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(versionedUnitId).append('|').append(info.getVersion()).append('|').append(info.getStartLevel()).append('|').append(EclipseBundleData.convertState((int)info.expectedState()));
            if (info.isSingleton()) continue;
            sb.append('|').append(false);
        }
        return sb.toString();
    }

    private Map deserializeContributions(String bundleId, String contributionsText) {
        String[] entries;
        LinkedHashMap<String, BundleInfoEx> contributions = new LinkedHashMap<String, BundleInfoEx>();
        String[] stringArray = entries = contributionsText.split("\n");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entryText = stringArray[n2];
            String[] fields = entryText.split("\\|");
            String versionedUnitId = fields[0];
            BundleInfoEx info = new BundleInfoEx();
            info.setSymbolicName(bundleId);
            info.setVersion(fields[1]);
            info.setStartLevel(Integer.parseInt(fields[2]));
            info.setExpectedState(EclipseBundleData.convertState((String)fields[3]));
            if (fields.length > 4) {
                info.setSingleton(Boolean.valueOf(fields[4]));
            }
            contributions.put(versionedUnitId, info);
            ++n2;
        }
        return contributions;
    }

    private BundleInfoEx copyBundleInfo(BundleInfo info) {
        BundleInfoEx infoEx = new BundleInfoEx();
        infoEx.setSymbolicName(info.getSymbolicName());
        infoEx.setVersion(info.getVersion());
        infoEx.setStartLevel(info.getStartLevel());
        infoEx.setExpectedState(info.expectedState());
        infoEx.setLocation(info.getLocation());
        infoEx.setSingleton(info.isSingleton());
        return infoEx;
    }

    public boolean isConfiguredVersion(String bundleId, String version) {
        Map contributions = (Map)this.bundles.get(bundleId);
        if (contributions == null) {
            return false;
        }
        BundleInfoEx latestInfo = this.getLatestSingletonVersion(contributions);
        if (latestInfo != null && latestInfo.getVersion().equals(version)) {
            return true;
        }
        return this.isConfiguredNonSingletonVersion(contributions, version);
    }

    private boolean isConfiguredNonSingletonVersion(Map contributions, String version) {
        Collection values = contributions.values();
        for (BundleInfoEx info : values) {
            if (info.isSingleton() || !info.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    private void checkForNonequivalentBundles(BundleInfoEx info, String bundleId, Map contributions) throws CoreException {
        assert (info.isSingleton()) : "checkForNonequivalentBundles(): info param is not a singleton";
        BundleInfoEx result = null;
        Collection values = contributions.values();
        for (BundleInfoEx configuredInfo : values) {
            if (!configuredInfo.isSingleton() || this.isEquivalent(configuredInfo, info) || !BundleRegistry.shouldReplace(configuredInfo, result)) continue;
            result = configuredInfo;
        }
        if (result != null) {
            ICicStatus status = Statuses.ERROR.get(Messages.EclipseInstallAdaptor_error_configuring_bundle, new Object[]{String.valueOf(bundleId) + '_' + info.getVersion(), String.valueOf(bundleId) + '_' + result.getVersion()});
            if (AgentUserOptions.CIC_SUPPRESS_NON_EQUIVALENT_BUNDLE_ERROR.isSet()) {
                log.status((IStatus)status);
            } else {
                throw new CoreException((IStatus)status);
            }
        }
    }

    private void checkForNonSingletonBundles(BundleInfoEx info, String bundleId, Map contributions) throws CoreException {
        assert (info.isSingleton()) : "checkForNonSingletonBundles(): info param is not a singleton";
        Collection values = contributions.values();
        for (BundleInfoEx configuredInfo : values) {
            if (configuredInfo.isSingleton() || this.isEquivalent(configuredInfo, info)) continue;
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.EclipseInstallAdaptor_singleton_bundle_error, new Object[]{String.valueOf(bundleId) + '_' + info.getVersion(), String.valueOf(bundleId) + '_' + configuredInfo.getVersion()}));
        }
    }

    private void checkForSingletonBundles(BundleInfoEx info, String bundleId, Map contributions) throws CoreException {
        assert (!info.isSingleton()) : "checkForSingletonBundles(): info param is a singleton";
        Collection values = contributions.values();
        for (BundleInfoEx configuredInfo : values) {
            if (!configuredInfo.isSingleton() || this.isEquivalent(configuredInfo, info)) continue;
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.EclipseInstallAdaptor_non_singleton_bundle_error, new Object[]{String.valueOf(bundleId) + '_' + info.getVersion(), String.valueOf(bundleId) + '_' + configuredInfo.getVersion()}));
        }
    }

    private static class BundleInfoEx
    extends BundleInfo {
        private Version osgiVersion = null;

        private BundleInfoEx() {
        }

        public Version getOsgiVersion() {
            if (this.osgiVersion == null) {
                this.osgiVersion = new Version(this.getVersion());
            }
            return this.osgiVersion;
        }

        public String getLocation() {
            String versionedId;
            String loc = super.getLocation();
            if (loc != null) {
                return loc;
            }
            File cacheLocation = CacheManager.getDefaultInstance().getCacheLocation();
            File pluginsLocation = new File(cacheLocation, "plugins");
            File pluginLocation = new File(pluginsLocation, String.valueOf(versionedId = String.valueOf(this.getSymbolicName()) + '_' + this.getVersion()) + CicConstants.getJarFileDotExt());
            if (!pluginLocation.isFile()) {
                pluginLocation = new File(pluginsLocation, versionedId);
            }
            try {
                loc = FileURLUtil.toUnescapedFileURL((File)pluginLocation).toString();
            }
            catch (MalformedURLException malformedURLException) {
                loc = "plugins/" + versionedId;
            }
            super.setLocation(loc);
            return loc;
        }
    }
}

