/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleSearch;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationUtil;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.FeatureInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.Messages;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.PPSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.EclipseUtil;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SortedProperties;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.eclipse.internals.update.configurator.FeatureEntry;
import com.ibm.cic.eclipse.internals.update.configurator.IPlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.PlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.SiteEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Version;

public class ConfigurationEditor {
    private static final Logger log = Logger.getLogger(ConfigurationEditor.class);
    private static final String FILE_SCHEME = "file:";
    private static final String REFERENCE_SCHEME = "reference:";
    private static String CONFIG_LOCATION = "org.eclipse.update/platform.xml";
    private static String INI_FILE_LOCATION = "config.ini";
    public static final String LAUNCHER_SUFFIX = ".ini";
    private static String DEFAULT_LAUNCHER_NAME = "eclipse";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String PROP_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    public static final String PROP_ECLIPSE_PRODUCT = "eclipse.product";
    public static final String PROP_SPLASH_PATH = "osgi.splashPath";
    public static final String PROP_SPLASH_LOCATION = "osgi.splashLocation";
    public static final String PROP_BUNDLES = "osgi.bundles";
    public static final String PROP_BUNDLES_EXTRADATA = "osgi.bundles.extraData";
    public static final String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
    public static final String PROP_LAUNCHER_PATH = "osgi.launcherPath";
    private static final String PROP_LAUNCHER_NAME = "osgi.launcherIni";
    private static final String PROP_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String PROP_CIC_PLAN_VERIFIER = "cic.eclipse.p2.verifyPlan";
    private static final String PROP_PLAN_VERIFIER = "eclipse.p2.verifyPlan";
    private static final String CONFIGURATOR_ID = "org.eclipse.update.configurator";
    private static final String SIMPLE_CONFIGURATOR_ID = "org.eclipse.equinox.simpleconfigurator";
    private static final String OSGI_ID = "org.eclipse.osgi";
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    protected static final String PLATFORM_BASE = "platform:/base/";
    private static final String START = "start";
    private static final String P2_PROFILE_ID = "eclipse.p2.profile";
    private static final String P2_UPDATE_RECONCILE = "org.eclipse.update.reconcile";
    private static final String P2_EXCLUSIVE_INSTALL = "org.eclipse.equinox.simpleconfigurator.exclusiveInstallation";
    private static final String P2_DATA_AREA = "eclipse.p2.data.area";
    public static final String P2_RECONCILER_DROPINS_FOLDER = "org.eclipse.equinox.p2.reconciler.dropins.directory";
    private static final String DEFAULT_P2_AREA = "p2";
    private static final String LAUNCHER_ID = "org.eclipse.equinox.launcher";
    private static final String PLAN_VERIFIER_PLUGIN_ID = "com.ibm.cic.planverifier";
    private static int NO_INFO = -2;
    private static int DO_NOT_CREATE_SITE_POLICY = -1;
    Collection bundles = new HashSet();
    Collection removeBundles = new HashSet();
    boolean bundleSetChanged = false;
    File configurationLocation;
    File launcherLocation;
    File installLocation;
    boolean isAgentSelfConfiguration;
    boolean isP2Managed = false;
    boolean isModifyJob = false;
    String osgiFramework;
    String eclipseProduct;
    String osgiSplashPath;
    String osgiSplashLocation;
    int defaultStartLevel = 0;
    boolean usingSimpleConfigurator = false;
    Properties configProperties = new Properties();
    boolean configIniDirty = false;
    String vmLocation = null;
    ArrayList vmArgs = new ArrayList();
    ArrayList programArgs = new ArrayList();
    String launcherName = null;
    String oldLauncherName = null;
    String oldOsgiBundles = null;
    String oldP2ProfileId = null;
    boolean exeIniDirty = false;
    boolean pvDisabledDuringReconcile = false;
    int planVerifierState = 0;
    private static final int PLAN_VERIFIER_NOT_INSTALLED = 0;
    private static final int PLAN_VERIFIER_ENABLED = 1;
    private static final int PLAN_VERIFIER_DISABLED = 2;
    public boolean reconcilerError = false;
    protected IPlatformConfiguration platformXml;
    boolean platformXmlDirty = false;

    public String getLauncher() {
        File launcherFile;
        String launcher = this.launcherName;
        if (launcher == null) {
            launcher = DEFAULT_LAUNCHER_NAME;
        }
        if (!(launcherFile = new File(this.launcherLocation, launcher = String.valueOf(launcher) + PPSettings.getPolicy().getExeSuffix())).isFile()) {
            log.warning(Messages.ConfigurationEditor_Launche_Does_Not_Exist, new Object[]{launcherFile.getPath()});
        }
        return launcherFile.getPath();
    }

    public File getLauncherLocation() {
        return this.launcherLocation;
    }

    public File getInstallLocation() {
        return this.installLocation;
    }

    private IStatus deduceInstallLocation(File installLoc) {
        if (installLoc != null) {
            this.installLocation = installLoc;
            return Status.OK_STATUS;
        }
        String osgiInstallArea = null;
        osgiInstallArea = this.configProperties.getProperty(PROP_OSGI_INSTALL_AREA);
        if (osgiInstallArea == null) {
            for (String vmarg : this.vmArgs) {
                int valueIdx;
                if (!vmarg.startsWith("-Dosgi.install.area=") || (valueIdx = vmarg.indexOf(61) + 1) == 0 || valueIdx > vmarg.length()) continue;
                osgiInstallArea = vmarg.substring(valueIdx);
                break;
            }
        }
        if (osgiInstallArea != null) {
            this.installLocation = new File(this.buildURL(osgiInstallArea, false).getFile());
            return Status.OK_STATUS;
        }
        if (this.launcherLocation != null) {
            this.installLocation = PlatformUtils.deduceInstallLocation((File)this.launcherLocation);
            return Status.OK_STATUS;
        }
        String msg = NLS.bind((String)Messages.ConfigurationEditor_Eclipse_Install_Not_Found, (Object)this.configurationLocation, (Object)this.launcherLocation);
        return new Status(1, Agent.PI_AGENT, 1, msg, null);
    }

    private URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith(FILE_SCHEME);
        try {
            if (isFile) {
                return this.adjustFile(new File(spec.substring(5)), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return this.adjustFile(new File(spec), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private URL adjustFile(File file, boolean trailingSlash) throws MalformedURLException {
        URL url = FileURLUtil.toUnescapedFileURL((File)file);
        return file.isDirectory() ? this.adjustTrailingSlash(url, trailingSlash) : url;
    }

    private URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    public ConfigurationEditor(File configLocation, File launcherLocation, File installLocation) throws CoreException {
        this.configurationLocation = CicCommonSettings.isPortable() && !configLocation.isAbsolute() ? new File(launcherLocation, configLocation.getPath()) : configLocation;
        this.launcherLocation = launcherLocation;
        this.isAgentSelfConfiguration = PlatformUtils.deduceInstallLocation((File)launcherLocation).equals(Agent.getInstance().getAgentInstanceLocation());
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        status.add(this.loadConfigIni());
        status.add(this.loadExeIni());
        status.add(this.deduceInstallLocation(installLocation));
        if (this.installLocation != null) {
            status.add(this.loadPlatformXML());
        }
        this.spoofupConfigurationDataFromBundleList();
        if (status.isErrorOrCancel()) {
            throw new CoreException((IStatus)status);
        }
    }

    public void setAgentSelfConfiguration(boolean isAgentSelfConfiguration) {
        this.isAgentSelfConfiguration = isAgentSelfConfiguration;
    }

    public void setIsP2Managed(boolean isP2Managed) {
        this.isP2Managed = isP2Managed;
    }

    public void setIsModifyJob(boolean isModifyJob) {
        this.isModifyJob = isModifyJob;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("vmLocation").append('=').append(this.vmLocation).append('\n');
        ConfigurationEditor.appendList(sb, "programArgs", this.programArgs);
        ConfigurationEditor.appendList(sb, "vmArgs", this.vmArgs);
        SortedProperties properties = new SortedProperties(this.configProperties);
        this.addConfigProperties((Properties)properties, this.computeBundleList());
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = properties.getProperty(name);
            if (name.equals(PROP_BUNDLES)) {
                ConfigurationEditor.appendList(sb, name, ConfigurationEditor.getListFromString(value, 1));
                continue;
            }
            if (name.equals(PROP_BUNDLES_EXTRADATA)) {
                ConfigurationEditor.appendList(sb, name, ConfigurationEditor.getListFromString(value, 3));
                continue;
            }
            sb.append(name).append('=').append(value).append('\n');
        }
        sb.append(this.platformXml.getConfigurationLocation()).append(':').append('\n');
        sb.append(this.platformXml.toString());
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private IStatus loadPlatformXML() {
        File location = new File(this.configurationLocation, CONFIG_LOCATION);
        IStatus status = Status.OK_STATUS;
        try {
            this.platformXml = new PlatformConfiguration(FileURLUtil.toUnescapedFileURL((File)location.getCanonicalFile()), FileURLUtil.toUnescapedFileURL((File)this.installLocation.getCanonicalFile()), true, false);
            BundleInfo[] existingBundles = ConfigurationEditor.createBundleInfos(this.platformXml.getPluginPath());
            this.bundles.addAll(Arrays.asList(existingBundles));
        }
        catch (IOException ioe) {
            String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Reading, (Object)location, (Object)ioe);
            status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)ioe);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Reading, (Object)location, (Object)e);
            status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e);
        }
        return status;
    }

    private static BundleInfo[] createBundleInfos(URL[] plugins) {
        if (plugins == null) {
            return new BundleInfo[0];
        }
        BundleInfo[] bundles = new BundleInfo[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            String url = plugins[i].toExternalForm().trim();
            String[] nameAndVersion = ConfigurationEditor.getActualBundleNameAndVersion(url);
            String bundleName = nameAndVersion[0];
            String bundleVersion = nameAndVersion[1];
            if (bundleVersion == null) {
                bundleVersion = "0.0.0";
            }
            bundles[i] = new BundleInfo();
            bundles[i].setLocation(url);
            bundles[i].setSymbolicName(bundleName);
            bundles[i].setVersion(bundleVersion);
            ++i;
        }
        return bundles;
    }

    private void spoofupConfigurationDataFromBundleList() {
        if (this.configProperties.getProperty(PROP_BUNDLES) != null) {
            List bundleInfos = this.deserializeBundleList(this.configProperties.getProperty(PROP_BUNDLES), null);
            if (!this.bundles.isEmpty()) {
                this.bundles.removeAll(bundleInfos);
            }
            this.bundles.addAll(bundleInfos);
        }
    }

    public IStatus validateOsgiBundlesProperty(int severity, IProgressMonitor monitor) {
        monitor.beginTask("", 3);
        try {
            String osgiBundlesValue = this.configProperties.getProperty(PROP_BUNDLES);
            if (osgiBundlesValue == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            CicMultiStatus result = severity == 2 ? Statuses.WARNING.getMultiStatus(Messages.ConfigurationEditor_unusualOsgiBundlesPropertyWarning, new Object[]{this.configurationLocation}) : Statuses.ERROR.getMultiStatus(Messages.ConfigurationEditor_unusualOsgiBundlesPropertyError, new Object[]{this.configurationLocation});
            int configuratorStartLevel = -1;
            List bundleInfos = this.deserializeBundleList(osgiBundlesValue, null);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                result.add(Status.CANCEL_STATUS);
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            SubProgressMonitor sm = new SubProgressMonitor(monitor, 1);
            sm.beginTask("", bundleInfos.size());
            for (BundleInfo bundle : bundleInfos) {
                if (configuratorStartLevel == -1 && this.isActiveConfigurator(bundle)) {
                    configuratorStartLevel = bundle.getStartLevel();
                }
                sm.worked(1);
                if (!sm.isCanceled()) continue;
                result.add(Status.CANCEL_STATUS);
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            sm.done();
            if (configuratorStartLevel == -1) {
                result.add((IStatus)new Status(severity, Agent.PI_AGENT, 1, Messages.ConfigurationEditor_configuratorNotFound, null));
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            if (this.defaultStartLevel != 0 && this.defaultStartLevel <= configuratorStartLevel) {
                if (severity == 2) {
                    result.add((IStatus)Statuses.WARNING.get(Messages.ConfigurationEditor_unexpectedDefaultStartLevelWarning, new Object[]{String.valueOf(this.defaultStartLevel), String.valueOf(configuratorStartLevel)}));
                } else {
                    result.add((IStatus)Statuses.WARNING.get(Messages.ConfigurationEditor_unexpectedDefaultStartLevelError, new Object[]{String.valueOf(this.defaultStartLevel), String.valueOf(configuratorStartLevel)}));
                }
            }
            sm = new SubProgressMonitor(monitor, 1);
            sm.beginTask("", bundleInfos.size());
            for (BundleInfo bundle : bundleInfos) {
                if (bundle.expectedState() != 32) {
                    if (severity == 2) {
                        result.add((IStatus)Statuses.WARNING.get(Messages.ConfigurationEditor_unexpectedStateWarning, new Object[]{bundle.getSymbolicName(), bundle.getStartLevel(), configuratorStartLevel}));
                    } else {
                        result.add((IStatus)Statuses.ERROR.get(Messages.ConfigurationEditor_unexpectedStateError, new Object[]{bundle.getSymbolicName(), bundle.getStartLevel(), configuratorStartLevel}));
                    }
                }
                sm.worked(1);
                if (!sm.isCanceled()) continue;
                result.add(Status.CANCEL_STATUS);
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            sm.done();
            CicMultiStatus cicMultiStatus = MultiStatusUtil.convertToOKifNoChildren((CicMultiStatus)result);
            return cicMultiStatus;
        }
        finally {
            monitor.done();
        }
    }

    public File getConfigurationLocation() {
        return this.configurationLocation;
    }

    public boolean isRunning() {
        return EclipseUtil.isEclipseRunning((File)this.configurationLocation);
    }

    public boolean isDirty() {
        return this.platformXmlDirty || this.exeIniDirty || this.configIniDirty;
    }

    public boolean isPlatformXmlDirty() {
        return this.platformXmlDirty;
    }

    public void refreshPlatformConfiguration() {
        this.platformXml.refresh();
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        if (this.configProperties.containsKey(P2_PROFILE_ID) && this.configProperties.containsKey(P2_UPDATE_RECONCILE) && this.platformXmlDirty && !this.isP2Managed) {
            this.doSaveAndReconcile(monitor);
        } else {
            this.doSave();
        }
    }

    private void doSave() throws CoreException {
        if (this.platformXmlDirty && !this.isP2Managed) {
            this.savePlatformXML(this.bundles, this.removeBundles);
        }
        if (this.exeIniDirty) {
            this.saveExeIni();
        }
        if (this.configIniDirty) {
            this.saveConfigIni(this.computeBundleList());
        }
    }

    private boolean hasp2Fixup() {
        Version p2ReconcilerVersion = this.getPluginVersion("org.eclipse.equinox.p2.reconciler.dropins");
        return p2ReconcilerVersion != null && p2ReconcilerVersion.compareTo(new Version("1.0.5")) >= 0;
    }

    private void saveConfigurationFiles() {
        File savedConfigurationFolder = new File(this.getConfigurationLocation(), "cic.configuration.before.reconcile");
        FileUtil.delete((File)savedConfigurationFolder);
        savedConfigurationFolder.mkdir();
        try {
            FileUtil.copyFile((File)new File(this.getLauncherLocation(), String.valueOf(this.getLauncherName()) + LAUNCHER_SUFFIX), (File)new File(savedConfigurationFolder, String.valueOf(this.getLauncherName()) + LAUNCHER_SUFFIX));
            FileUtil.copyFile((File)new File(this.getConfigurationLocation(), "config.ini"), (File)new File(savedConfigurationFolder, "config.ini"));
            String bundlesInfo = "org.eclipse.equinox.simpleconfigurator/bundles.info";
            FileUtil.copyFile((File)new File(this.getConfigurationLocation(), bundlesInfo), (File)new File(savedConfigurationFolder, "bundles.info"));
            String platfrmXml = "org.eclipse.update/platform.xml";
            FileUtil.copyFile((File)new File(this.getConfigurationLocation(), platfrmXml), (File)new File(savedConfigurationFolder, "platform.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeSavedConfigurationFiles() {
        File savedConfigurationFolder = new File(this.getConfigurationLocation(), "cic.configuration.before.reconcile");
        this.deleteDir(savedConfigurationFolder);
    }

    private String versionizeFrameworkExtensions(String frameworkExtensionProperty) {
        String[] extensions;
        if (frameworkExtensionProperty == null || frameworkExtensionProperty.length() == 0) {
            return null;
        }
        ArrayList<BundleInfo> frameworkExtensions = new ArrayList<BundleInfo>();
        String versionedExtensionProperty = null;
        String[] stringArray = extensions = ConfigurationEditor.getArrayFromList(frameworkExtensionProperty, ",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension2 = stringArray[n2];
            String bundleName = extension2.endsWith(CicConstants.getJarFileDotExt()) ? (String)SplitIdVersionUtil.splitIdUnderscoreVersion((String)extension2.substring(0, extension2.length() - CicConstants.getJarFileDotExt().length()))[0] : (String)SplitIdVersionUtil.splitIdUnderscoreVersion((String)extension2)[0];
            BundleInfo extension = null;
            for (BundleInfo entry : this.bundles) {
                if (!entry.getSymbolicName().equals(bundleName)) continue;
                extension = entry;
                break;
            }
            if (extension == null) {
                log.warning(Messages.bind((String)Messages.ConfigurationEditor_FrameworkExtensionBundle_Not_Found, (Object)bundleName));
            } else if (!frameworkExtensions.contains(extension)) {
                String location = new Path(extension.getLocation()).lastSegment();
                frameworkExtensions.add(extension);
                versionedExtensionProperty = versionedExtensionProperty == null ? location : String.valueOf(versionedExtensionProperty) + ',' + location;
            }
            ++n2;
        }
        return versionedExtensionProperty;
    }

    private boolean hasUnversionedFrameworkExtensions() {
        String[] extensions;
        String frameworkExtensionProperty = this.configProperties.getProperty(PROP_FRAMEWORK_EXTENSIONS);
        if (frameworkExtensionProperty == null || frameworkExtensionProperty.length() == 0) {
            return true;
        }
        String[] stringArray = extensions = ConfigurationEditor.getArrayFromList(frameworkExtensionProperty, ",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            Object[] bundleInfo = extension.endsWith(CicConstants.getJarFileDotExt()) ? SplitIdVersionUtil.splitIdUnderscoreVersion((String)extension.substring(0, extension.length() - CicConstants.getJarFileDotExt().length())) : SplitIdVersionUtil.splitIdUnderscoreVersion((String)extension);
            if (bundleInfo[1] == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void doSaveAndReconcile(IProgressMonitor monitor) throws CoreException {
        IPath p2ReconcilerDropinsFolder;
        String frameworkExtensionProperty = null;
        if (!this.isModifyJob || !new File(this.configurationLocation, INI_FILE_LOCATION).exists() || this.hasUnversionedFrameworkExtensions()) {
            frameworkExtensionProperty = this.versionizeFrameworkExtensions((String)this.configProperties.remove(PROP_FRAMEWORK_EXTENSIONS));
        }
        if (this.platformXmlDirty) {
            this.savePlatformXML(this.bundles, this.removeBundles);
        }
        if (this.exeIniDirty) {
            this.saveExeIni();
        }
        if ((p2ReconcilerDropinsFolder = new Path(this.getConfigurationLocation().getAbsolutePath()).append("org.eclipse.update").append("com.ibm.cic.bootstrap.repository")).append(DEFAULT_P2_AREA).append("content.xml").toFile().exists()) {
            if (CicCommonSettings.isPortable()) {
                p2ReconcilerDropinsFolder = p2ReconcilerDropinsFolder.makeRelativeTo((IPath)new Path(this.installLocation.getAbsolutePath()));
            }
            this.configProperties.setProperty(P2_RECONCILER_DROPINS_FOLDER, p2ReconcilerDropinsFolder.toOSString());
        } else if (new File(String.valueOf(p2ReconcilerDropinsFolder.toOSString()) + "_1.0.0").exists()) {
            this.configProperties.setProperty(P2_RECONCILER_DROPINS_FOLDER, String.valueOf(p2ReconcilerDropinsFolder.toOSString()) + "_1.0.0");
        }
        boolean hasP2Fixup = this.hasp2Fixup();
        if (this.oldOsgiBundles == null || this.oldOsgiBundles.indexOf(SIMPLE_CONFIGURATOR_ID) <= 0 || hasP2Fixup) {
            this.saveConfigIni(this.computeBundleList());
        }
        this.saveConfigurationFiles();
        monitor.beginTask("", 2);
        SubProgressMonitor sm = new SubProgressMonitor(monitor, 1);
        sm.subTask(Messages.ConfigurationEditor_p2_Reconcile);
        int reconcileStatus = this.doReconcile(hasP2Fixup);
        sm.worked(1);
        sm.done();
        if (frameworkExtensionProperty != null) {
            this.configProperties.put(PROP_FRAMEWORK_EXTENSIONS, frameworkExtensionProperty);
            this.configProperties.put(P2_EXCLUSIVE_INSTALL, "false");
        }
        this.saveConfigIni(this.computeBundleList());
        this.saveExeIni();
        if (reconcileStatus == 0) {
            this.removeSavedConfigurationFiles();
            if (frameworkExtensionProperty != null || !hasP2Fixup) {
                IStatus status;
                if (!AgentUserOptions.CIC_AGENT_ECLIPSE_DO_NOT_DELETE_OSGI_FOLDER.isSet()) {
                    this.deleteDir(new File(this.configurationLocation, OSGI_ID));
                }
                if (!(status = this.runInitialize(4, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).isOK()) {
                    throw new CoreException(status);
                }
                this.saveExeIni();
            }
        }
        monitor.done();
    }

    private void cleanupP2Profiles() {
        if (AgentUserOptions.CIC_AGENT_ECLIPSE_DO_NOT_CLEAN_UP_P2_PROFILES.isSet()) {
            return;
        }
        File p2DataArea = this.getP2DataArea();
        if (p2DataArea == null || !p2DataArea.exists()) {
            return;
        }
        this.deleteDir(new File(p2DataArea, "org.eclipse.equinox.p2.core/cache"));
        this.deleteDir(new File(p2DataArea, "org.eclipse.equinox.p2.director/rollback"));
        this.deleteDir(new File(p2DataArea, "org.eclipse.equinox.p2.metadata.repository/cache"));
        File p2ProfilesPath = new File(p2DataArea, "org.eclipse.equinox.p2.engine/profileRegistry/" + this.configProperties.getProperty(P2_PROFILE_ID, "bootProfile") + ".profile");
        if (!p2ProfilesPath.exists()) {
            return;
        }
        File[] p2Profiles = p2ProfilesPath.listFiles();
        File p2Profile = null;
        File[] fileArray = p2Profiles;
        int n = p2Profiles.length;
        int n2 = 0;
        while (n2 < n) {
            File p2Profile2 = fileArray[n2];
            if (p2Profile2.isFile() && (p2Profile2.getName().endsWith(".profile") || p2Profile2.getName().endsWith(".profile.gz"))) {
                if (p2Profile == null) {
                    p2Profile = p2Profile2;
                } else {
                    try {
                        int extensionLength = 0;
                        int currentExtensionLength = 0;
                        if (p2Profile.getName().endsWith(".profile")) {
                            extensionLength = ".profile".length();
                        } else if (p2Profile.getName().endsWith(".profile.gz")) {
                            extensionLength = ".profile.gz".length();
                        }
                        if (p2Profile2.getName().endsWith(".profile")) {
                            currentExtensionLength = ".profile".length();
                        } else if (p2Profile2.getName().endsWith(".profile.gz")) {
                            currentExtensionLength = ".profile.gz".length();
                        }
                        long profileId = Long.parseLong(p2Profile.getName().substring(0, p2Profile.getName().length() - extensionLength));
                        long profileIdCurrent = Long.parseLong(p2Profile2.getName().substring(0, p2Profile2.getName().length() - currentExtensionLength));
                        if (profileId < profileIdCurrent) {
                            FileUtil.rm((File)p2Profile);
                            p2Profile = p2Profile2;
                        } else {
                            FileUtil.rm((File)p2Profile2);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++n2;
        }
    }

    private List getCustomIniLocations(UserOptions.StringOption option) {
        ArrayList<File> result = new ArrayList<File>(3);
        String optionValue = option.value();
        if (optionValue != null) {
            File file = new File(optionValue);
            result.add(file);
        }
        String optionName = option.getName();
        String iniFile = optionName.substring(optionName.indexOf("eclipse"));
        File agentLocation = Agent.getInstance().getAgentSelfLocation();
        File file = new File(agentLocation, iniFile);
        result.add(file);
        file = new File(System.getProperty("user.home"), iniFile);
        result.add(file);
        return result;
    }

    private void parseCustomIni(UserOptions.StringOption option, List programArgsList, List vmArgsList) {
        List locations = this.getCustomIniLocations(option);
        for (File file : locations) {
            if (!file.isFile()) continue;
            log.info(Messages.ConfigurationEditor_usingCustomIni, new Object[]{file.getPath()});
            IStatus status = ConfigurationEditor.parseLauncherIni(file, programArgsList, vmArgsList, null);
            log.statusNotOK(status);
            return;
        }
    }

    private void parseReconcilerIni(List programArgsList, List vmArgsList) {
        this.parseCustomIni(AgentUserOptions.CIC_ECLIPSE_RECONCILER_INI, programArgsList, vmArgsList);
    }

    private List buildVMArgList(boolean configIniIsSaved) {
        String osgiConfigurationAreaProperty;
        ArrayList<String> vmArgList = new ArrayList<String>();
        if (configIniIsSaved) {
            if (!this.configProperties.getProperty(PROP_BUNDLES_STARTLEVEL, "NotFound").equals("4")) {
                vmArgList.add("-Dosgi.bundles.defaultStartLevel=4");
            }
            if (this.configProperties.getProperty("osgi.bundlefile.limit") != null) {
                vmArgList.add("-Dosgi.bundlefile.limit=100");
            }
            if (!this.configProperties.getProperty(P2_EXCLUSIVE_INSTALL, "NotFound").equals("false")) {
                vmArgList.add("-Dorg.eclipse.equinox.simpleconfigurator.exclusiveInstallation=false");
            }
            if (this.configProperties.getProperty(P2_RECONCILER_DROPINS_FOLDER) != null) {
                vmArgList.add("-Dorg.eclipse.equinox.p2.reconciler.dropins.directory=" + this.configProperties.getProperty(P2_RECONCILER_DROPINS_FOLDER));
            }
        } else {
            vmArgList.add("-Dosgi.bundles.defaultStartLevel=4");
            vmArgList.add("-Dosgi.bundlefile.limit=100");
            vmArgList.add("-Dorg.eclipse.equinox.simpleconfigurator.exclusiveInstallation=false");
            vmArgList.add("-Dorg.eclipse.equinox.p2.reconciler.dropins.directory=" + this.configProperties.getProperty(P2_RECONCILER_DROPINS_FOLDER));
        }
        if ((osgiConfigurationAreaProperty = this.configProperties.getProperty(PROP_OSGI_CONFIGURATION_AREA)) != null) {
            File f = this.getConfigurationLocation();
            try {
                URL url = FileURLUtil.toUnescapedFileURL((File)f);
                vmArgList.add("-Dosgi.configuration.area=" + url.toString());
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
            }
        }
        if (AgentUserOptions.CIC_PLAN_VERIFIER_DISABLE_DURING_RECONCILE.isSet() || this.pvDisabledDuringReconcile) {
            vmArgList.add("-Declipse.p2.verifyPlan=false");
        }
        return vmArgList;
    }

    private int doReconcile(boolean hasP2Fixup) throws CoreException {
        if (AgentUserOptions.CIC_AGENT_ECLIPSE_DO_NOT_RECONCILE.isSet()) {
            return -1;
        }
        if (this.getLauncher() == null || !new File(this.getLauncher()).exists()) {
            log.warning(Messages.ConfigurationEditor_p2_Launcher_Not_Found);
            return -1;
        }
        this.cleanupP2Profiles();
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(this.getLauncher());
            cmdList.add("-application");
            cmdList.add("org.eclipse.equinox.p2.reconciler.application");
            cmdList.add("-product");
            cmdList.add("org.eclipse.equinox.p2.reconciler.dropins.product");
            cmdList.add("-nosplash");
            cmdList.add("--launcher.suppressErrors");
            List vmArgsList = this.buildVMArgList(hasP2Fixup);
            this.parseReconcilerIni(cmdList, vmArgsList);
            if (vmArgsList.size() != 0) {
                cmdList.add("-vmargs");
                cmdList.addAll(this.getVMArgList());
                cmdList.addAll(vmArgsList);
            }
            String[] cmdarray = cmdList.toArray(new String[cmdList.size()]);
            log.start(log.info(this.commandArrayToString(cmdarray)));
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            int status = PlatformUtils.runProcess((String[])cmdarray, null, (File)this.getInstallLocation(), (Writer)out, (Writer)err);
            String outString = out.toString();
            String errString = err.toString();
            if (outString.length() > 0) {
                log.info(outString);
            }
            if (errString.length() > 0) {
                log.error(Messages.ConfigurationEditor_p2_Reconcilation_Error, new Object[]{errString});
            }
            if (status != 0) {
                this.reconcilerError = true;
                String message = NLS.bind((String)Messages.ConfigurationEditor_p2_Reconcilation_Error_Status, (Object)status, (Object)this.getConfigurationLocation());
                log.error(message);
                if (hasP2Fixup) {
                    this.saveConfigIni(this.computeBundleList());
                    this.savePlatformXML(this.bundles, this.removeBundles);
                    this.saveExeIni();
                    this.deleteDir(new File(this.configurationLocation, OSGI_ID));
                    String doNotThrowException = System.getProperty("cic.continueInstallOnP2ReconcilerError");
                    if (doNotThrowException == null || !Boolean.valueOf(doNotThrowException).booleanValue()) {
                        throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, message, null));
                    }
                }
            }
            int n = status;
            return n;
        }
        finally {
            this.cleanupP2Profiles();
            log.stop();
        }
    }

    private void parseInitializeIni(List programArgsList, List vmArgsList) {
        this.parseCustomIni(AgentUserOptions.CIC_ECLIPSE_INITIALIZE_INI, programArgsList, vmArgsList);
    }

    public IStatus runInitialize(int severity, IProgressMonitor monitor) {
        int initializeStatus = this.doInitialize(monitor);
        if (initializeStatus != 0) {
            return new Status(severity, Agent.PI_AGENT, 1, Messages.bind((String)Messages.ConfigurationEditor_Eclipse_Initialize_Error_Status, (Object)String.valueOf(initializeStatus)), null);
        }
        return Status.OK_STATUS;
    }

    public int doInitialize() {
        return this.doInitialize((IProgressMonitor)new NullProgressMonitor());
    }

    public int doInitialize(IProgressMonitor monitor) {
        if (AgentUserOptions.CIC_AGENT_ECLIPSE_DO_NOT_INITIALIZE.isSet()) {
            return 0;
        }
        if (this.getLauncher() == null || !new File(this.getLauncher()).exists()) {
            log.warning(Messages.ConfigurationEditor_Launcher_Not_Found_For_Intialize);
            return 1;
        }
        monitor.beginTask("", 1);
        monitor.subTask(Messages.ConfigurationEditor_Eclipse_Initialize);
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(this.getLauncher());
            cmdList.add("-initialize");
            cmdList.add("-nosplash");
            cmdList.add("--launcher.suppressErrors");
            ArrayList<String> vmArgsList = new ArrayList<String>();
            String osgiConfigurationAreaProperty = this.configProperties.getProperty(PROP_OSGI_CONFIGURATION_AREA);
            if (osgiConfigurationAreaProperty != null) {
                File f = this.getConfigurationLocation();
                try {
                    URL url = FileURLUtil.toUnescapedFileURL((File)f);
                    vmArgsList.add("-Dosgi.configuration.area=" + url.toString());
                }
                catch (MalformedURLException e) {
                    log.error((Throwable)e);
                }
            }
            this.parseInitializeIni(cmdList, vmArgsList);
            if (vmArgsList.size() != 0) {
                cmdList.add("-vmargs");
                cmdList.addAll(this.getVMArgList());
                cmdList.addAll(vmArgsList);
            }
            String[] cmdarray = cmdList.toArray(new String[cmdList.size()]);
            log.start(log.info(this.commandArrayToString(cmdarray)));
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            int status = PlatformUtils.runProcess((String[])cmdarray, null, (File)this.getInstallLocation(), (Writer)out, (Writer)err);
            String outString = out.toString();
            String errString = err.toString();
            if (outString.length() > 0) {
                log.info(outString);
            }
            if (errString.length() > 0) {
                log.error(errString);
            }
            if (status != 0) {
                log.error(Messages.bind((String)Messages.ConfigurationEditor_Eclipse_Initialize_Error_Status, (Object)String.valueOf(status)));
            }
            int n = status;
            return n;
        }
        finally {
            this.cleanupP2Profiles();
            log.stop();
            monitor.worked(1);
            monitor.done();
        }
    }

    private String commandArrayToString(String[] cmdArray) {
        String cmdArrayStr = null;
        String[] stringArray = cmdArray;
        int n = cmdArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            cmdArrayStr = cmdArrayStr == null ? element : String.valueOf(cmdArrayStr) + " " + element;
            ++n2;
        }
        return cmdArrayStr;
    }

    public void add(BundleInfo bundle) {
        if (!this.bundles.add(bundle)) {
            this.bundles.remove(bundle);
            this.bundles.add(bundle);
        }
        this.removeBundles.remove(bundle);
        this.bundleSetChanged = true;
        this.platformXmlDirty = true;
        this.configIniDirty = true;
        if (OSGI_ID.equals(bundle.getSymbolicName())) {
            this.setFrameworkLocation(bundle.getLocation());
            return;
        }
    }

    public boolean configurationIsEmpty() {
        return this.platformXmlIsEmpty() && this.configIniIsEmpty() && this.exeIniIsEmpty();
    }

    private boolean platformXmlIsEmpty() {
        if (this.platformXml != null) {
            return this.bundles.size() == 0 && this.getFeatures().length == 0;
        }
        return true;
    }

    private boolean configIniIsEmpty() {
        return true;
    }

    private boolean exeIniIsEmpty() {
        return true;
    }

    private boolean launcherParameterSet() {
        return this.vmArgs != null && this.vmArgs.size() != 0 || this.vmLocation != null || this.programArgs != null && this.programArgs.size() != 0;
    }

    private void cleanupLauncherFile(String fileName) {
        File configFile;
        if (fileName != null && (configFile = new File(this.launcherLocation, String.valueOf(fileName) + LAUNCHER_SUFFIX)).exists()) {
            if (this.isEmptyLauncherFileExistedBefore()) {
                FileOutputStream writer = null;
                try {
                    writer = new FileOutputStream(configFile, false);
                    writer.close();
                }
                catch (IOException iOException) {}
            } else {
                configFile.delete();
            }
        }
    }

    protected boolean isEmptyLauncherFileExistedBefore() {
        return false;
    }

    public void saveExeIni() throws CoreException {
        if (this.launcherLocation == null) {
            return;
        }
        if (this.launcherName == null) {
            this.launcherName = DEFAULT_LAUNCHER_NAME;
        }
        if (this.oldLauncherName != null && !this.oldLauncherName.equals(this.launcherName)) {
            this.cleanupLauncherFile(this.oldLauncherName);
        }
        if (!this.launcherParameterSet()) {
            this.cleanupLauncherFile(this.launcherName);
            this.cleanupLauncherFile(this.configProperties.getProperty(PROP_LAUNCHER_NAME));
            return;
        }
        File configFile = new File(this.launcherLocation, String.valueOf(this.launcherName) + LAUNCHER_SUFFIX);
        if (CicCommonSettings.isPortable()) {
            int n = 0;
            while (n < this.programArgs.size()) {
                if (this.programArgs.get(n).equals("-install") && n + 1 < this.programArgs.size()) {
                    this.programArgs.set(n + 1, ".");
                }
                ++n;
            }
        }
        try {
            try {
                configFile.getParentFile().mkdirs();
                BufferedWriter writer = new BufferedWriter(Encodings.DEFAULT.writer(configFile));
                try {
                    if (this.vmLocation != null) {
                        writer.write("-vm");
                        writer.newLine();
                        writer.write(this.vmLocation);
                        writer.newLine();
                    }
                    Iterator iter = this.programArgs.iterator();
                    while (iter.hasNext()) {
                        writer.write((String)iter.next());
                        writer.newLine();
                    }
                    if (this.vmArgs.size() != 0) {
                        writer.write("-vmargs");
                        writer.newLine();
                        iter = this.vmArgs.iterator();
                        while (iter.hasNext()) {
                            writer.write(((String)iter.next()).trim());
                            writer.newLine();
                        }
                    }
                    writer.flush();
                    this.exeIniDirty = false;
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Writing, (Object)configFile);
                throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
            }
        }
        finally {
            if (!this.launcherName.equals(this.configProperties.getProperty(PROP_LAUNCHER_NAME))) {
                this.cleanupLauncherFile(this.configProperties.getProperty(PROP_LAUNCHER_NAME));
            }
        }
    }

    private List getPluginsList(String location) {
        if (location.equals(PLATFORM_BASE)) {
            location = this.installLocation.getAbsolutePath();
        } else if (location.startsWith(FILE_SCHEME)) {
            location = location.substring(FILE_SCHEME.length());
        }
        location = new Path(location).append(PLUGINS).toOSString();
        ArrayList<String> pluginsList = new ArrayList<String>();
        File[] plugins = new File(location).listFiles();
        int i = 0;
        while (plugins != null && i < plugins.length) {
            String name = plugins[i].getName();
            if (name.indexOf(95) > 0) {
                name = "plugins/" + name;
            }
            if (!name.endsWith(CicConstants.getJarFileDotExt())) {
                name = String.valueOf(name) + "/";
            }
            pluginsList.add(name);
            ++i;
        }
        return pluginsList;
    }

    private boolean isPlatformBase(IPlatformConfiguration.ISiteEntry entry) {
        return entry.getURL().toExternalForm().equals(PLATFORM_BASE);
    }

    private void removePluginsFromExclusion(IPlatformConfiguration.ISiteEntry entry, String[] keepPlugins, Collection toPersist, Collection toRemove) {
        ArrayList<String> removeList;
        List pluginsList = this.getPluginsList(entry.getURL().toExternalForm());
        if (this.isPlatformBase(entry) && this.usingSimpleConfigurator) {
            removeList = new ArrayList();
            for (String plugin : pluginsList) {
                if (!plugin.contains(LAUNCHER_ID)) continue;
                removeList.add(plugin);
            }
            pluginsList.removeAll(removeList);
        }
        removeList = new ArrayList<String>();
        String[] stringArray = keepPlugins;
        int n = keepPlugins.length;
        int plugin = 0;
        while (plugin < n) {
            String keepPlugin = stringArray[plugin];
            for (String plugin2 : pluginsList) {
                if (!plugin2.equals(keepPlugin)) continue;
                removeList.add(plugin2);
                break;
            }
            ++plugin;
        }
        pluginsList.removeAll(removeList);
        HashSet<String> exclusionList = new HashSet<String>();
        for (BundleInfo remove : toRemove) {
            IPlatformConfiguration.ISiteEntry entryForBundle = this.getSiteEntry(ConfigurationEditor.splitPath(remove.getLocation(), PLUGINS, true), DO_NOT_CREATE_SITE_POLICY);
            if (entryForBundle == null || !entryForBundle.equals(entry)) continue;
            exclusionList.add(ConfigurationEditor.splitPath(remove.getLocation(), PLUGINS, false));
        }
        block4: for (String plugin3 : pluginsList) {
            String[] pluginInfo = ConfigurationEditor.getActualBundleNameAndVersion(plugin3);
            for (BundleInfo persist : toPersist) {
                if (!pluginInfo[0].equals(persist.getSymbolicName())) continue;
                if (exclusionList.contains(plugin3)) continue block4;
                exclusionList.add(plugin3);
                continue block4;
            }
        }
        String[] plugins = new String[exclusionList.size()];
        entry.getSitePolicy().setList(exclusionList.toArray(plugins));
    }

    private String[] getPluginsForSite(IPlatformConfiguration.ISiteEntry site) {
        if (site.getSitePolicy().getType() == 1) {
            String[] excludedPlugins = site.getSitePolicy().getList();
            List pluginsList = this.getPluginsList(site.getURL().toExternalForm());
            pluginsList.removeAll(Arrays.asList(excludedPlugins));
            String[] plugins = new String[pluginsList.size()];
            pluginsList.toArray(plugins);
            return plugins;
        }
        if (site.getSitePolicy().getType() == 0) {
            return site.getSitePolicy().getList();
        }
        return site.getPlugins();
    }

    private Version getPluginVersion(String pluginId) {
        IPlatformConfiguration.ISiteEntry[] sites = this.platformXml.getConfiguredSites();
        Version highestPluginVersion = null;
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] plugins;
            IPlatformConfiguration.ISiteEntry site = iSiteEntryArray[n2];
            String[] stringArray = plugins = this.getPluginsForSite(site);
            int n3 = plugins.length;
            int n4 = 0;
            while (n4 < n3) {
                String plugin = stringArray[n4];
                if (plugin.indexOf("plugins/" + pluginId + "_") == 0) {
                    String pluginVersion = plugin.substring(plugin.indexOf("_") + 1);
                    pluginVersion = pluginVersion.endsWith(CicConstants.getJarFileDotExt()) ? pluginVersion.substring(0, pluginVersion.length() - CicConstants.getJarFileDotExt().length()) : pluginVersion.substring(0, pluginVersion.length() - 1);
                    Version version = new Version(pluginVersion);
                    if (highestPluginVersion == null || version.compareTo(highestPluginVersion) > 0) {
                        highestPluginVersion = version;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return highestPluginVersion;
    }

    private void addTransientFlagIfNecessary() {
        this.platformXml.isTransient(false);
        Version highestConfiguratorVersion = this.getPluginVersion(CONFIGURATOR_ID);
        if (highestConfiguratorVersion != null && highestConfiguratorVersion.compareTo(new Version("3.2.2.R32x_v20070109")) < 0) {
            this.platformXml.isTransient(true);
        }
    }

    private void savePlatformXML(Collection toPersist, Collection toRemove) throws CoreException {
        if (this.bundleSetChanged) {
            IPlatformConfiguration.ISiteEntry removeSite;
            IPlatformConfiguration.IFeatureEntry[] features = this.platformXml.getConfiguredFeatureEntries();
            IPlatformConfiguration.ISiteEntry[] removeSites = this.platformXml.getConfiguredSites();
            ArrayList<String> userExcludeSites = new ArrayList<String>();
            IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = removeSites;
            int n = removeSites.length;
            int n2 = 0;
            while (n2 < n) {
                removeSite = iSiteEntryArray[n2];
                if (removeSite.getSitePolicy().getType() == 1 && !this.isAgentSelfConfiguration) {
                    userExcludeSites.add(removeSite.getURL().toExternalForm());
                }
                this.platformXml.unconfigureSite(removeSite);
                ++n2;
            }
            for (BundleInfo persist : toPersist) {
                this.addPluginToSite(this.getSiteEntry(persist, userExcludeSites), persist);
            }
            iSiteEntryArray = features;
            n = features.length;
            int n3 = 0;
            while (n3 < n) {
                IPlatformConfiguration.ISiteEntry feature = iSiteEntryArray[n3];
                SiteEntry siteEntry = (SiteEntry)this.getSiteEntry(((FeatureEntry)feature).getSite().getURL().toExternalForm());
                siteEntry.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)feature);
                ++n3;
            }
            iSiteEntryArray = removeSites = this.platformXml.getConfiguredSites();
            n = removeSites.length;
            n3 = 0;
            while (n3 < n) {
                removeSite = iSiteEntryArray[n3];
                if (removeSite.getSitePolicy().getType() == 1) {
                    this.removePluginsFromExclusion(removeSite, removeSite.getSitePolicy().getList(), toPersist, toRemove);
                }
                ++n3;
            }
            try {
                if (!this.isAgentSelfConfiguration) {
                    File dropLocation = new File(this.configurationLocation, "..");
                    this.getSiteEntry(new URL(PLATFORM_BASE).toExternalForm(), 1);
                    new File(dropLocation, PLUGINS).mkdirs();
                    new File(dropLocation, FEATURES).mkdirs();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.addTransientFlagIfNecessary();
            this.deleteDir(new File(this.configurationLocation, OSGI_ID));
        }
        try {
            this.platformXml.save();
            this.platformXmlDirty = false;
            this.bundleSetChanged = false;
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Writing, (Object)this.platformXml.getConfigurationLocation());
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
        }
    }

    private void deleteDir(File sourceFile) {
        if (sourceFile != null && sourceFile.exists()) {
            if (sourceFile.isDirectory()) {
                File[] files;
                File[] fileArray = files = sourceFile.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        this.deleteDir(file);
                    } else {
                        FileUtil.delete((File)file);
                    }
                    ++n2;
                }
            }
            FileUtil.delete((File)sourceFile);
        }
    }

    private void addPluginToSite(IPlatformConfiguration.ISiteEntry siteEntry, BundleInfo persist) {
        String relativePath;
        String[] pluginList;
        if (siteEntry != null) {
            pluginList = siteEntry.getSitePolicy().getList();
            relativePath = ConfigurationEditor.splitPath(persist.getLocation(), PLUGINS, false);
            if (relativePath == null) {
                return;
            }
        } else {
            return;
        }
        String[] newPluginList = new String[pluginList.length + 1];
        System.arraycopy(pluginList, 0, newPluginList, 1, pluginList.length);
        newPluginList[0] = relativePath;
        siteEntry.getSitePolicy().setList(newPluginList);
    }

    private IPlatformConfiguration.ISiteEntry getSiteEntry(String site) {
        return this.getSiteEntry(site, 0);
    }

    private IPlatformConfiguration.ISiteEntry getSiteEntry(BundleInfo bundle, List excludeSiteLocations) {
        String filePath;
        String site = ConfigurationEditor.splitPath(bundle.getLocation(), PLUGINS, true);
        if (site == null) {
            return null;
        }
        if (excludeSiteLocations.contains(site)) {
            return this.getSiteEntry(site, 1);
        }
        if (site.startsWith(FILE_SCHEME) && this.installLocation.equals(new File(filePath = site.substring(5)))) {
            if (excludeSiteLocations.contains(PLATFORM_BASE)) {
                return this.getSiteEntry(PLATFORM_BASE, 1);
            }
            if (this.isAgentSelfConfiguration) {
                return this.getSiteEntry(PLATFORM_BASE, 0);
            }
        }
        return this.getSiteEntry(site, 0);
    }

    private IPlatformConfiguration.ISiteEntry findSiteEntry(BundleInfo bundle) {
        IPlatformConfiguration.ISiteEntry siteEntry;
        String location = bundle.getLocation();
        if (ConfigurationUtil.isPlatformBaseLocation(location, this.installLocation)) {
            siteEntry = this.getSiteEntry(PLATFORM_BASE, DO_NOT_CREATE_SITE_POLICY);
        } else {
            String site = ConfigurationEditor.splitPath(location, PLUGINS, true);
            if (site == null) {
                return null;
            }
            siteEntry = this.getSiteEntry(site, DO_NOT_CREATE_SITE_POLICY);
        }
        return siteEntry;
    }

    public boolean isManagedBundle(BundleInfo bundle) {
        if (this.isP2Managed) {
            return true;
        }
        IPlatformConfiguration.ISiteEntry siteEntry = this.findSiteEntry(bundle);
        if (siteEntry == null) {
            return false;
        }
        return siteEntry.getSitePolicy().getType() != 1;
    }

    private IPlatformConfiguration.ISiteEntry getSiteEntry(String site, int sitePolicyPreference) {
        URL siteURL = null;
        try {
            siteURL = new URL(site);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        IPlatformConfiguration.ISiteEntry result = this.platformXml.findConfiguredSite(siteURL);
        if (result != null || sitePolicyPreference == DO_NOT_CREATE_SITE_POLICY) {
            return result;
        }
        result = this.platformXml.createSiteEntry(siteURL, this.platformXml.createSitePolicy(sitePolicyPreference, new String[0]));
        ((SiteEntry)result).noPlugins();
        ((SiteEntry)result).initialized();
        if (sitePolicyPreference == 0) {
            try {
                if (site.equals(FileURLUtil.toUnescapedFileURL((File)CacheManager.getDefaultInstance().getCacheLocation()).toExternalForm())) {
                    ((SiteEntry)result).setUpdateable(false);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.platformXml.configureSite(result);
        return result;
    }

    private boolean isActiveConfigurator(BundleInfo bundle) {
        if (bundle.expectedState() != 32) {
            return false;
        }
        String id = bundle.getSymbolicName();
        return CONFIGURATOR_ID.equals(id) || SIMPLE_CONFIGURATOR_ID.equals(id);
    }

    private Collection computeBundleList() {
        List bundlesToAdd;
        HashMap<Integer, ArrayList<BundleInfo>> bundlesByStartLevel = new HashMap<Integer, ArrayList<BundleInfo>>(5);
        int configuratorStartLevel = -1;
        for (BundleInfo entry : this.bundles) {
            ArrayList<BundleInfo> toAdd;
            int startLevel = entry.getStartLevel();
            if (configuratorStartLevel == -1 && this.isActiveConfigurator(entry)) {
                configuratorStartLevel = startLevel;
            }
            if ((toAdd = (ArrayList<BundleInfo>)bundlesByStartLevel.get(startLevel)) == null) {
                toAdd = new ArrayList<BundleInfo>();
                bundlesByStartLevel.put(startLevel, toAdd);
            }
            toAdd.add(entry);
        }
        if (configuratorStartLevel == -1) {
            return this.bundles;
        }
        ArrayList toBundleList = new ArrayList();
        if (this.defaultStartLevel != 0 && this.defaultStartLevel < configuratorStartLevel && (bundlesToAdd = (List)bundlesByStartLevel.remove(this.defaultStartLevel)) != null) {
            toBundleList.addAll(bundlesToAdd);
        }
        for (Map.Entry entry : bundlesByStartLevel.entrySet()) {
            int currentStartLevel = (Integer)entry.getKey();
            if (currentStartLevel > configuratorStartLevel || currentStartLevel == -1) continue;
            toBundleList.addAll((List)entry.getValue());
        }
        HashMap<String, BundleInfo> uniqueBundles = new HashMap<String, BundleInfo>(5);
        for (BundleInfo bundle : toBundleList) {
            String bundleId = bundle.getSymbolicName();
            if (!uniqueBundles.containsKey(bundleId)) {
                uniqueBundles.put(bundleId, bundle);
                continue;
            }
            String bundleLocation = bundle.getLocation();
            if (!ConfigurationUtil.isPlatformBaseLocation(bundleLocation, this.installLocation)) continue;
            uniqueBundles.put(bundleId, bundle);
        }
        return uniqueBundles.values();
    }

    private void relativizePathProperties(Properties props) throws URISyntaxException {
        String[] pathPropertyNames;
        String[] stringArray = pathPropertyNames = new String[]{PROP_FRAMEWORK, P2_RECONCILER_DROPINS_FOLDER};
        int n = pathPropertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String keyName = stringArray[n2];
            String oldValue = props.getProperty(keyName);
            if (oldValue != null) {
                props.setProperty(keyName, this.makeRelativeToInstallLocation(oldValue));
            }
            ++n2;
        }
    }

    private String makeRelativeToInstallLocation(String propertyPath) throws URISyntaxException {
        URI relativeUri;
        URI propertyPathUri = URIUtil.fromString((String)propertyPath);
        if (!propertyPathUri.isAbsolute()) {
            return propertyPath;
        }
        URI installUri = this.installLocation.toURI();
        URI uRI = relativeUri = URIUtil.isFileURI((URI)propertyPathUri) ? URIUtil.makeRelative((URI)propertyPathUri, (URI)installUri) : URIUtil.makeRelative((URI)new File(propertyPath).toURI(), (URI)installUri);
        if (URIUtil.isFileURI((URI)propertyPathUri)) {
            return String.format("%s:%s", propertyPathUri.getScheme(), URIUtil.toUnencodedString((URI)relativeUri));
        }
        return relativeUri.toString();
    }

    private void saveConfigIni(Collection toPersist) throws CoreException {
        File configIni = new File(this.configurationLocation, INI_FILE_LOCATION);
        this.addConfigProperties(this.configProperties, toPersist);
        try {
            if (CicCommonSettings.isPortable()) {
                this.relativizePathProperties(this.configProperties);
            }
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(configIni));
            try {
                this.configProperties.store(output, "");
                this.configIniDirty = false;
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)output).close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Writing, (Object)configIni);
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Writing, (Object)configIni);
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
        }
    }

    private boolean isOsgiFrameworkLocationRelative() {
        File file;
        if (this.osgiFramework == null) {
            return true;
        }
        return this.osgiFramework.startsWith(FILE_SCHEME) && !(file = new File(this.osgiFramework.substring(FILE_SCHEME.length()))).isAbsolute() && PLUGINS.equals(file.getParent());
    }

    private void addConfigProperties(Properties properties, Collection toPersist) {
        if (this.osgiFramework != null) {
            if (this.isP2Managed) {
                properties.put(PROP_FRAMEWORK, this.osgiFramework);
            } else {
                String framework = ConfigurationUtil.computeOsgiFramework(this.bundles.toArray(new BundleInfo[0]), this.installLocation);
                if (framework != null) {
                    this.osgiFramework = framework;
                }
                if (!ConfigurationUtil.isPlatformBaseLocation(this.osgiFramework, this.installLocation)) {
                    properties.put(PROP_FRAMEWORK, this.osgiFramework);
                } else if (this.configProperties.containsKey(P2_PROFILE_ID) && this.configProperties.containsKey(P2_UPDATE_RECONCILE)) {
                    int i = this.osgiFramework.indexOf(OSGI_ID);
                    this.osgiFramework = "file:plugins/" + this.osgiFramework.substring(i);
                    properties.put(PROP_FRAMEWORK, this.osgiFramework);
                } else {
                    properties.remove(PROP_FRAMEWORK);
                    this.osgiFramework = null;
                }
            }
        }
        if (this.eclipseProduct != null) {
            properties.put(PROP_ECLIPSE_PRODUCT, this.eclipseProduct);
        }
        if (this.osgiSplashPath != null) {
            properties.put(PROP_SPLASH_PATH, this.osgiSplashPath);
        }
        if (this.osgiSplashLocation != null) {
            properties.put(PROP_SPLASH_LOCATION, this.osgiSplashLocation);
        }
        if (this.launcherName != null) {
            properties.put(PROP_LAUNCHER_NAME, this.launcherName);
        }
        if (this.launcherLocation != null) {
            String relOrAbsLauncherLocation = CicCommonSettings.isPortable() ? "." : this.launcherLocation.getAbsolutePath();
            properties.put(PROP_LAUNCHER_PATH, relOrAbsLauncherLocation);
        }
        this.changePlanVerifierProperties(properties);
        if (this.isP2Managed) {
            if (this.oldOsgiBundles != null) {
                properties.put(PROP_BUNDLES, this.oldOsgiBundles);
            }
        } else if (toPersist != null) {
            String[] bundlesInfo = this.serializeBundleList(toPersist);
            properties.put(PROP_BUNDLES, bundlesInfo[0]);
            if (bundlesInfo[1].length() != 0 && !CicCommonSettings.isPortable()) {
                properties.put(PROP_BUNDLES_EXTRADATA, bundlesInfo[1]);
            } else {
                properties.remove(PROP_BUNDLES_EXTRADATA);
            }
        }
        if (this.isP2Managed && this.oldP2ProfileId != null) {
            properties.put(P2_PROFILE_ID, this.oldP2ProfileId);
        }
    }

    private void changePlanVerifierProperties(Properties properties) {
        if (AgentUserOptions.CIC_PLAN_VERIFIER_SET_DISABLED.isSet()) {
            properties.remove(PROP_CIC_PLAN_VERIFIER);
            properties.put(PROP_PLAN_VERIFIER, CommonDef.False);
        } else if (AgentUserOptions.CIC_PLAN_VERIFIER_SET_ENABLED.isSet()) {
            properties.put(PROP_CIC_PLAN_VERIFIER, CommonDef.True);
            properties.remove(PROP_PLAN_VERIFIER);
        } else {
            switch (this.planVerifierState) {
                case 1: {
                    properties.put(PROP_CIC_PLAN_VERIFIER, CommonDef.True);
                    properties.remove(PROP_PLAN_VERIFIER);
                    break;
                }
                case 2: {
                    properties.remove(PROP_CIC_PLAN_VERIFIER);
                    properties.put(PROP_PLAN_VERIFIER, CommonDef.False);
                    break;
                }
                default: {
                    properties.remove(PROP_CIC_PLAN_VERIFIER);
                    properties.remove(PROP_PLAN_VERIFIER);
                }
            }
        }
    }

    private String[] serializeBundleList(Collection toPersist) {
        StringBuffer bundleList = new StringBuffer();
        StringBuffer bundleListExtraData = new StringBuffer();
        for (BundleInfo toWrite : toPersist) {
            boolean start;
            String location = toWrite.getLocation();
            if (location == null || OSGI_ID.equals(toWrite.getSymbolicName())) continue;
            int startLevel = toWrite.getStartLevel();
            int expected = toWrite.expectedState();
            if (CicCommonSettings.isPortable()) {
                bundleList.append(String.valueOf(toWrite.getSymbolicName()) + "_" + toWrite.getVersion());
            } else if (this.isOsgiFrameworkLocationRelative() && ConfigurationUtil.isPlatformBaseLocation(location, this.installLocation)) {
                if (this.usingSimpleConfigurator) {
                    int i = location.indexOf(toWrite.getSymbolicName());
                    bundleList.append("reference:file:" + location.substring(i));
                } else {
                    bundleList.append(toWrite.getSymbolicName());
                }
                location = null;
            } else {
                bundleList.append(REFERENCE_SCHEME + location);
            }
            boolean level = startLevel != -1 && startLevel != NO_INFO;
            boolean bl = start = expected == 32;
            if (level || start) {
                bundleList.append('@');
                if (level) {
                    bundleList.append(startLevel);
                    if (start) {
                        bundleList.append(':');
                    }
                }
                if (start) {
                    bundleList.append(START);
                }
            }
            bundleList.append(',');
            if (location == null) continue;
            bundleListExtraData.append(location).append(',').append(toWrite.getSymbolicName()).append(',').append(toWrite.getVersion()).append(',');
        }
        if (bundleList.length() > 0) {
            bundleList.setLength(bundleList.length() - 1);
        }
        if (bundleListExtraData.length() > 0) {
            bundleListExtraData.setLength(bundleListExtraData.length() - 1);
        }
        return new String[]{bundleList.toString(), bundleListExtraData.toString()};
    }

    private List deserializeBundleList(String bundleList, String additionalData) {
        String[] osgiBundles = ConfigurationEditor.getArrayFromList(bundleList, ",");
        ArrayList<BundleInfo> bundleInfos = new ArrayList<BundleInfo>(osgiBundles.length);
        String[] stringArray = osgiBundles;
        int n = osgiBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String verifiedLocation;
            String osgiBundle = stringArray[n2];
            BundleInfo toAdd = new BundleInfo();
            int index = osgiBundle.indexOf(64);
            if (index >= 0) {
                int startIndex = osgiBundle.indexOf(58, index);
                if (startIndex > 0 && osgiBundle.substring(startIndex + 1).equalsIgnoreCase(START)) {
                    toAdd.setExpectedState(32);
                    toAdd.setStartLevel(Integer.parseInt(osgiBundle.substring(index + 1, startIndex)));
                } else {
                    startIndex = osgiBundle.length();
                    if (osgiBundle.substring(index + 1).equalsIgnoreCase(START)) {
                        toAdd.setExpectedState(32);
                        toAdd.setStartLevel(NO_INFO);
                    } else {
                        toAdd.setStartLevel(Integer.parseInt(osgiBundle.substring(index + 1)));
                        toAdd.setExpectedState(4);
                    }
                }
            } else {
                index = osgiBundle.length();
                toAdd.setStartLevel(NO_INFO);
            }
            String location = osgiBundle.substring(0, index);
            try {
                URL foundLocation = BundleSearch.searchForBundle(location, this.pluginFolder());
                verifiedLocation = foundLocation != null ? foundLocation.toExternalForm() : location;
            }
            catch (MalformedURLException malformedURLException) {
                verifiedLocation = location;
            }
            toAdd.setLocation(verifiedLocation);
            String[] nameAndVersion = ConfigurationEditor.getActualBundleNameAndVersion(verifiedLocation);
            toAdd.setSymbolicName(nameAndVersion[0]);
            toAdd.setVersion(nameAndVersion[1]);
            bundleInfos.add(toAdd);
            ++n2;
        }
        return this.correctBundleList(bundleInfos);
    }

    private List correctBundleList(List bundleInfos) {
        if (!this.isAgentSelfConfiguration) {
            return bundleInfos;
        }
        HashMap<String, BundleInfo> map = new HashMap<String, BundleInfo>(bundleInfos.size());
        for (BundleInfo bundleInfo : bundleInfos) {
            map.put(bundleInfo.getSymbolicName(), bundleInfo);
        }
        for (BundleInfo bundle : this.bundles) {
            BundleInfo bundleInfo = (BundleInfo)map.get(bundle.getSymbolicName());
            if (bundleInfo == null) continue;
            bundleInfo.setLocation(bundle.getLocation());
            bundleInfo.setVersion(bundle.getVersion());
        }
        return bundleInfos;
    }

    private static String[] getActualBundleNameAndVersion(String location) {
        int end = location.length();
        if (location.endsWith(CicConstants.getJarFileDotExt())) {
            end -= 4;
        } else if (location.charAt(end - 1) == '/') {
            --end;
        }
        int start = location.lastIndexOf(47, end - 1);
        if (start == -1) {
            start = location.lastIndexOf(92, end - 1);
        }
        String nameAndVersionText = location.substring(start + 1, end);
        Object[] nameAndVersion = BundleSearch.getActualBundleNameAndVersion(nameAndVersionText);
        String name = (String)nameAndVersion[0];
        Version version = (Version)nameAndVersion[1];
        return new String[]{name, version == null ? null : version.toString()};
    }

    private String pluginFolder() {
        if (this.isOsgiFrameworkLocationRelative()) {
            return new File(this.getInstallLocation(), "plugins/").toString();
        }
        if (this.osgiFramework.startsWith(FILE_SCHEME)) {
            File file = new File(this.osgiFramework.substring(FILE_SCHEME.length()));
            if (file.isAbsolute()) {
                return file.getParent();
            }
            return new File(this.getInstallLocation(), file.getParent()).toString();
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private IStatus loadConfigIni() {
        block19: {
            configIni = new File(this.configurationLocation, ConfigurationEditor.INI_FILE_LOCATION);
            inputStream = null;
            status = Status.OK_STATUS;
            if (configIni.exists()) {
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(configIni));
                    this.configProperties.load(inputStream);
                }
                catch (FileNotFoundException fnfe) {
                    msg = NLS.bind((String)Messages.ConfigurationEditor_File_Not_Found, (Object)configIni);
                    status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)fnfe);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException v0) {}
                    }
                    break block19;
                }
                catch (IOException ioe) {
                    try {
                        msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Reading, (Object)configIni);
                        status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)ioe);
                        ** if (inputStream == null) goto lbl-1000
                    }
                    catch (Throwable var6_9) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var6_9;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            inputStream.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block19;
                    }
                }
                if (inputStream == null) break block19;
                try {
                    inputStream.close();
                }
                catch (IOException v3) {}
            }
        }
        this.osgiFramework = this.configProperties.getProperty("osgi.framework");
        this.eclipseProduct = this.configProperties.getProperty("eclipse.product");
        this.osgiSplashPath = this.configProperties.getProperty("osgi.splashPath");
        this.osgiSplashLocation = this.configProperties.getProperty("osgi.splashLocation");
        this.defaultStartLevel = Integer.parseInt(this.configProperties.getProperty("osgi.bundles.defaultStartLevel", "4"));
        this.launcherName = this.configProperties.getProperty("osgi.launcherIni");
        this.oldOsgiBundles = this.configProperties.getProperty("osgi.bundles");
        this.oldP2ProfileId = this.configProperties.getProperty("eclipse.p2.profile");
        this.oldLauncherName = this.launcherName;
        if (this.launcherLocation == null && (launcherPath = this.configProperties.getProperty("osgi.launcherPath")) != null) {
            this.launcherLocation = new File(launcherPath);
        }
        this.checkForSimpleConfigurator(this.configProperties);
        return status;
    }

    private void checkForSimpleConfigurator(Properties properties) {
        this.usingSimpleConfigurator = properties.getProperty(P2_PROFILE_ID) != null && Boolean.toString(false).equals(properties.getProperty(P2_UPDATE_RECONCILE)) && properties.getProperty(PROP_BUNDLES) != null && properties.getProperty(PROP_BUNDLES).indexOf(SIMPLE_CONFIGURATOR_ID) >= 0 || AgentUserOptions.CIC_MOCK_USING_SIMPLE_CONFIGURATOR.isSet();
    }

    private IStatus loadExeIni() {
        File iniFile = null;
        IStatus status = Status.OK_STATUS;
        if (this.launcherName == null) {
            File[] candidates = null;
            final File possibleLauncherLocation = this.getLauncherLocation();
            candidates = possibleLauncherLocation.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.isFile()) {
                        return false;
                    }
                    String fileName = pathname.getName();
                    return fileName.endsWith(ConfigurationEditor.LAUNCHER_SUFFIX) && ConfigurationEditor.hasLauncher(possibleLauncherLocation, fileName.substring(0, fileName.length() - ConfigurationEditor.LAUNCHER_SUFFIX.length()));
                }
            });
            if (candidates == null || candidates.length == 0) {
                return status;
            }
            iniFile = candidates[0];
            String candidateName = candidates[0].getName();
            this.launcherName = candidateName.substring(0, candidateName.length() - LAUNCHER_SUFFIX.length());
        } else {
            iniFile = new File(this.launcherLocation, String.valueOf(this.launcherName) + LAUNCHER_SUFFIX);
        }
        if (iniFile.exists()) {
            String[] vmLocationRef = new String[1];
            status = ConfigurationEditor.parseLauncherIni(iniFile, this.programArgs, this.vmArgs, vmLocationRef);
            if (vmLocationRef[0] != null) {
                this.vmLocation = vmLocationRef[0];
            }
        }
        return status;
    }

    private static boolean hasLauncher(File root, final String launcherName) {
        File[] found = root.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                return file.isFile() && (name.equals(launcherName) || name.equals(String.valueOf(launcherName) + ".exe") || name.equals(String.valueOf(launcherName) + ".app"));
            }
        });
        return found != null && found.length != 0;
    }

    private static String[] getArrayFromList(String prop, String separator) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    public void remove(BundleInfo toRemove) {
        this.bundles.remove(toRemove);
        this.removeBundles.add(toRemove);
        this.bundleSetChanged = true;
        this.platformXmlDirty = true;
        this.configIniDirty = true;
    }

    public void setFrameworkLocation(String path) {
        this.osgiFramework = path;
        this.configIniDirty = true;
    }

    public void setProperty(String key, String value) {
        this.configProperties.put(key, value);
        this.configIniDirty = true;
        if (PROP_LAUNCHER_NAME.equals(key)) {
            this.exeIniDirty = true;
        }
    }

    public Properties getProperties() {
        Properties properties = (Properties)this.configProperties.clone();
        this.addConfigProperties(properties, null);
        this.removeManagedProperties(properties);
        return properties;
    }

    private void removeManagedProperties(Properties properties) {
        properties.remove(PROP_BUNDLES);
        properties.remove(PROP_BUNDLES_EXTRADATA);
        properties.remove(PROP_FRAMEWORK);
        if (this.isP2Managed) {
            properties.remove(P2_PROFILE_ID);
        }
    }

    public static HashSet getWriteOncePropertyKeys() {
        return new HashSet<String>(Arrays.asList(PROP_ECLIPSE_PRODUCT, PROP_SPLASH_LOCATION, PROP_LAUNCHER_NAME, PROP_LAUNCHER_PATH));
    }

    public static HashSet getListPropertyKeys() {
        return new HashSet<String>(Arrays.asList(PROP_SPLASH_PATH, PROP_FRAMEWORK_EXTENSIONS));
    }

    public void setProperties(Properties properties) {
        String launcherPath;
        this.removeManagedProperties(properties);
        this.oldLauncherName = this.configProperties.getProperty(PROP_LAUNCHER_NAME);
        String newLauncherName = properties.getProperty(PROP_LAUNCHER_NAME);
        if (newLauncherName != null && !newLauncherName.equals(this.oldLauncherName)) {
            this.exeIniDirty = true;
        }
        if (this.eclipseProduct == null || this.eclipseProduct.equals(this.configProperties.getProperty(PROP_ECLIPSE_PRODUCT))) {
            this.eclipseProduct = properties.getProperty(PROP_ECLIPSE_PRODUCT);
        }
        if (this.osgiSplashPath == null || this.osgiSplashPath.equals(this.configProperties.getProperty(PROP_SPLASH_PATH))) {
            this.osgiSplashPath = properties.getProperty(PROP_SPLASH_PATH);
        }
        if (this.osgiSplashLocation == null || this.osgiSplashLocation.equals(this.configProperties.getProperty(PROP_SPLASH_LOCATION))) {
            this.osgiSplashLocation = properties.getProperty(PROP_SPLASH_LOCATION);
        }
        if (this.launcherName == null || this.launcherName.equals(this.oldLauncherName)) {
            this.launcherName = newLauncherName;
        }
        if ((this.launcherLocation == null || this.launcherLocation.getAbsolutePath().equals(this.configProperties.getProperty(PROP_LAUNCHER_PATH))) && (launcherPath = properties.getProperty(PROP_LAUNCHER_PATH)) != null) {
            this.launcherLocation = new File(launcherPath);
        }
        this.configProperties = properties;
        this.configIniDirty = true;
    }

    public void setEclipseProduct(String id) {
        this.eclipseProduct = id;
        this.configIniDirty = true;
    }

    public void setSplashPath(String path) {
        this.osgiSplashPath = path;
        this.configIniDirty = true;
    }

    public void setSplashLocation(String path) {
        this.osgiSplashLocation = path;
        this.configIniDirty = true;
    }

    public void addVMArg(String arg) {
        this.vmArgs.add(arg);
        this.exeIniDirty = true;
    }

    public void removeVMArg(String arg) {
        this.vmArgs.remove(arg);
        this.exeIniDirty = true;
    }

    public String[] getVMArgs() {
        return this.vmArgs.toArray(new String[this.vmArgs.size()]);
    }

    public ArrayList getVMArgList() {
        return this.vmArgs;
    }

    public void setVMArgList(ArrayList list) {
        assert (list != null);
        this.vmArgs = list;
        this.exeIniDirty = true;
    }

    public void setVMLocation(String path) {
        File vmFilePath;
        this.vmLocation = path;
        this.exeIniDirty = true;
        if (this.vmLocation != null && CicCommonSettings.isPortable() && (vmFilePath = new File(this.vmLocation)).isAbsolute()) {
            this.vmLocation = FileUtil.getRelativePath((File)this.installLocation, (File)vmFilePath);
        }
    }

    public String getVMLocation() {
        return this.vmLocation;
    }

    public void setInitialStartLevel() {
        throw new UnsupportedOperationException();
    }

    public String getLauncherName() {
        return this.launcherName;
    }

    public void setLauncherName(String name) {
        this.launcherName = name;
        this.exeIniDirty = true;
    }

    protected boolean isLauncherNameDefault() {
        return DEFAULT_LAUNCHER_NAME.equals(this.launcherName);
    }

    public void addProgramArgument(String arg, String value) {
        this.programArgs.add(arg);
        if (value != null) {
            this.programArgs.add(value);
        }
        this.exeIniDirty = true;
    }

    public void removeProgramArgument(String argument, boolean removeAssociatedValue) {
        boolean argumentFound = false;
        for (String toRemove : this.programArgs) {
            if (argumentFound && removeAssociatedValue) {
                this.programArgs.remove(toRemove);
                return;
            }
            if (!argument.equals(toRemove)) continue;
            this.programArgs.remove(toRemove);
            this.exeIniDirty = true;
            if (!removeAssociatedValue) {
                return;
            }
            argumentFound = true;
        }
    }

    public String[] getProgramArguments() {
        return this.programArgs.toArray(new String[this.programArgs.size()]);
    }

    public ArrayList getProgramArgumentList() {
        return this.programArgs;
    }

    public void setProgramArgumentList(ArrayList programArgs) {
        assert (programArgs != null);
        this.programArgs = programArgs;
        this.exeIniDirty = true;
    }

    public void setDefaultStartLevel(int defaultStartLevel) {
        this.defaultStartLevel = defaultStartLevel;
        this.configIniDirty = true;
    }

    public File getP2DataArea() {
        if (this.isP2Managed) {
            return null;
        }
        if (!this.usingSimpleConfigurator) {
            this.checkForSimpleConfigurator(this.configProperties);
        }
        if (!this.usingSimpleConfigurator) {
            return null;
        }
        String p2DataArea = (String)this.configProperties.get(P2_DATA_AREA);
        if (p2DataArea != null && p2DataArea.length() != 0) {
            String configDir = "@config.dir";
            int index = p2DataArea.indexOf(configDir);
            if (index == 0) {
                return new File(this.configurationLocation, p2DataArea.substring(index + configDir.length()));
            }
            if (index < 0 && new File(p2DataArea).isAbsolute()) {
                return new File(p2DataArea);
            }
        }
        return new File(this.installLocation, DEFAULT_P2_AREA);
    }

    public BundleInfo[] getBundles() {
        return this.bundles.toArray(new BundleInfo[this.bundles.size()]);
    }

    public long getChangeStamp() {
        return this.platformXml.getChangeStamp();
    }

    public void setPlanVerifierState(boolean planVerifierInstalled, boolean shouldBeEnabled) {
        this.planVerifierState = planVerifierInstalled ? (shouldBeEnabled ? 1 : 2) : 0;
    }

    public void setPlanVerifierDisabledDuringReconcile(boolean disabled) {
        this.pvDisabledDuringReconcile = disabled;
        if (log.isDebugLoggable()) {
            if (disabled) {
                log.debug("Plan Verifier will be disabled during reconcile");
            } else {
                log.debug("Plan Verifier will not be disabled during reconcile");
            }
        }
    }

    public void addFeature(String featureName, String version, String featureLocation, String pluginId, String pluginVersion, boolean primary, String application) {
        if (featureLocation == null) {
            return;
        }
        String site = ConfigurationEditor.splitPath(featureLocation, FEATURES, true);
        String relativePath = ConfigurationEditor.splitPath(featureLocation, FEATURES, false);
        if (site == null || relativePath == null) {
            return;
        }
        IPlatformConfiguration.IFeatureEntry toAdd = this.platformXml.createFeatureEntry(featureName, version, pluginId, pluginVersion, primary, application, null);
        ((FeatureEntry)toAdd).setURL(relativePath);
        this.getSiteEntry(site);
        this.platformXml.configureFeatureEntry(toAdd);
        this.platformXmlDirty = true;
    }

    public void removeFeature(String featureName, String version, String location) {
        URL featureLocation;
        if (location == null) {
            return;
        }
        try {
            featureLocation = new URL(location);
        }
        catch (MalformedURLException e1) {
            log.error((Throwable)e1);
            return;
        }
        if (this.installLocation.equals(new File(featureLocation.getFile()))) {
            try {
                featureLocation = new URL(PLATFORM_BASE);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        IPlatformConfiguration.IFeatureEntry toRemove = this.platformXml.createFeatureEntry(featureName, version, null, false, null, new URL[]{featureLocation});
        this.platformXml.unconfigureFeatureEntry(toRemove);
        this.platformXmlDirty = true;
    }

    public FeatureInfo[] getFeatures() {
        IPlatformConfiguration.ISiteEntry[] siteEntries = this.platformXml.getConfiguredSites();
        ArrayList<FeatureInfo> result = new ArrayList<FeatureInfo>();
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = siteEntries;
        int n = siteEntries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry[] featureEntries;
            IPlatformConfiguration.ISiteEntry siteEntrie = iSiteEntryArray[n2];
            SiteEntry siteEntry = (SiteEntry)siteEntrie;
            URL siteUrl = siteEntry.getResolvedURL();
            FeatureEntry[] featureEntryArray = featureEntries = siteEntry.getFeatureEntries();
            int n3 = featureEntries.length;
            int n4 = 0;
            while (n4 < n3) {
                FeatureEntry featureEntry = featureEntryArray[n4];
                FeatureInfo info = new FeatureInfo();
                info.setSymbolicName(featureEntry.getFeatureIdentifier());
                info.setVersion(featureEntry.getFeatureVersion());
                try {
                    URL location = new URL(siteUrl, featureEntry.getURL().toString());
                    info.setLocation(location.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                info.setPluginId(featureEntry.getFeaturePluginIdentifier());
                info.setPluginVersion(featureEntry.getFeaturePluginVersion());
                info.setPrimary(featureEntry.canBePrimary());
                info.setApplication(featureEntry.getApplication());
                result.add(info);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new FeatureInfo[result.size()]);
    }

    public Version findFeatureVersion(String id) {
        IPlatformConfiguration.IFeatureEntry entry = this.platformXml.findConfiguredFeatureEntry(id);
        return entry == null ? null : new Version(entry.getFeatureVersion());
    }

    public String findBundleLocation(String id) {
        for (BundleInfo entry : this.bundles) {
            if (!entry.getSymbolicName().equals(id)) continue;
            return entry.getLocation();
        }
        return null;
    }

    public List findLauncherLibraryBundleIds() {
        ArrayList<String> result = new ArrayList<String>();
        String launcherLibraryPluginIdPrefix = "org.eclipse.equinox.launcher.";
        for (BundleInfo entry : this.bundles) {
            String suffix;
            String[] segments;
            String id = entry.getSymbolicName();
            if (!id.startsWith(launcherLibraryPluginIdPrefix) || (segments = (suffix = id.substring(launcherLibraryPluginIdPrefix.length())).split("\\.")).length != 3 || result.contains(id)) continue;
            result.add(id);
        }
        return result;
    }

    public boolean isPlanVerifierInstalled() {
        return this.findBundleLocation(PLAN_VERIFIER_PLUGIN_ID) != null;
    }

    private static String splitPath(String path, String segment, boolean before) {
        String search = String.valueOf('/') + segment + '/';
        int i = path.lastIndexOf(search) + 1;
        if (i == 0) {
            log.error(Messages.ConfigurationEditor_Did_Not_Find, new Object[]{search, path});
            return null;
        }
        if (before) {
            return path.substring(0, i);
        }
        return path.substring(i);
    }

    private static List getListFromString(String value, int num) {
        String[] elements = ConfigurationEditor.getArrayFromList(value, ",");
        if (elements.length % num != 0) {
            throw new AssertionError((Object)("expected multiple of " + num + " elements: " + value));
        }
        ArrayList<String> result = new ArrayList<String>(elements.length / num);
        int i = 0;
        while (i < elements.length) {
            StringBuilder sb = new StringBuilder();
            sb.append(elements[i++]);
            int j = 1;
            while (j < num) {
                sb.append(' ').append(elements[i++]);
                ++j;
            }
            result.add(sb.toString());
        }
        Collections.sort(result);
        return result;
    }

    private static void appendList(StringBuffer sb, String name, List value) {
        if (name != null) {
            sb.append(name).append(':').append('\n');
        }
        Iterator i = value.iterator();
        while (i.hasNext()) {
            sb.append(' ').append(i.next()).append('\n');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IStatus parseLauncherIni(File iniFile, List programArgs, List vmArgs, String[] vmLocationRef) {
        IStatus status = Status.OK_STATUS;
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = new BufferedReader(Encodings.DEFAULT.reader(iniFile));
                boolean readingVmArgs = false;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    if ((line = line.trim()).equals("-vm") && vmLocationRef != null) {
                        String vmLoc = reader.readLine();
                        if (vmLoc == null) {
                            return status;
                        }
                        vmLocationRef[0] = vmLoc.trim();
                        continue;
                    }
                    if (line.equals("-vmargs")) {
                        readingVmArgs = true;
                        continue;
                    }
                    if (readingVmArgs) {
                        vmArgs.add(line);
                        continue;
                    }
                    programArgs.add(line);
                }
                return status;
            }
            catch (FileNotFoundException fnfe) {
                String msg = NLS.bind((String)Messages.ConfigurationEditor_File_Not_Found, (Object)iniFile);
                status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)fnfe);
                if (reader == null) return status;
                try {
                    reader.close();
                    return status;
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
                return status;
            }
            catch (IOException ioe) {
                String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Reading, (Object)iniFile);
                status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)ioe);
                if (reader == null) return status;
                try {
                    reader.close();
                    return status;
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
                return status;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.bundles.isEmpty() && (!this.isP2Managed || !this.configProperties.containsKey(P2_PROFILE_ID));
    }
}

