/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.framework.Version;

public class BundleSearch {
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String FILE_PROTOCOL = "file";

    public static URL searchForBundle(String name, String parent) throws MalformedURLException {
        Object result;
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        if (parent != null) {
            try {
                new URL(name);
                url = new URL(FileURLUtil.toUnescapedFileURL((File)new File(parent)), name);
            }
            catch (MalformedURLException malformedURLException) {
                File child = new File(name);
                fileLocation = child.isAbsolute() ? child : new File(parent, name);
                url = new URL(REFERENCE_PROTOCOL, null, FileURLUtil.toUnescapedFileURL((File)fileLocation).toExternalForm());
                reference = true;
            }
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File child;
                reference = true;
                String baseSpec = url.getFile();
                baseURL = baseSpec.startsWith("file:") ? FileURLUtil.toUnescapedFileURL((File)((child = new File(baseSpec.substring(5))).isAbsolute() ? child : new File(parent, child.getPath()))) : new URL(baseSpec);
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(parent, fileLocation.toString());
            }
        }
        if (reference) {
            result = BundleSearch.searchFor(fileLocation.getName(), new File(fileLocation.getParent()).getAbsolutePath());
            if (result == null) {
                return null;
            }
            url = FileURLUtil.toUnescapedFileURL((File)new File((String)result));
        }
        if (url.getProtocol().equals(FILE_PROTOCOL)) {
            try {
                fileLocation = new File(url.getPath()).getCanonicalFile();
            }
            catch (IOException iOException) {
                fileLocation = new File(url.getPath());
            }
            return fileLocation.exists() ? FileURLUtil.toUnescapedFileURL((File)fileLocation) : null;
        }
        try {
            result = url.openConnection();
            ((URLConnection)result).connect();
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String searchFor(String target, String start) {
        String[] candidates = new File(start).list();
        if (candidates == null) {
            return null;
        }
        File result = null;
        Version maxVersion = null;
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate2 = stringArray[n2];
            File candidate = new File(start, candidate2);
            if (candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_")) {
                Object[] nameAndVersion;
                Version currentVersion;
                String candidateName = candidate.getName();
                if (candidateName.endsWith(CicConstants.getJarFileDotExt())) {
                    candidateName = candidateName.substring(0, candidateName.length() - 4);
                }
                if ((currentVersion = (Version)(nameAndVersion = BundleSearch.getActualBundleNameAndVersion(candidateName))[1]) != null) {
                    if (maxVersion == null) {
                        result = candidate;
                        maxVersion = currentVersion;
                    } else if (currentVersion.compareTo(maxVersion) > 0) {
                        result = candidate;
                        maxVersion = currentVersion;
                    }
                } else if (result == null) {
                    result = candidate;
                }
            }
            ++n2;
        }
        if (result == null) {
            return null;
        }
        return String.valueOf(result.getAbsolutePath().replace(File.separatorChar, '/')) + (result.isDirectory() ? "/" : "");
    }

    public static Object[] getActualBundleNameAndVersion(String nameAndVersion) {
        return SplitIdVersionUtil.splitIdUnderscoreVersion((String)nameAndVersion);
    }
}

