/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UserFeedback;
import com.ibm.cic.agent.internal.eclipse.qualification.NewProfileQualificationOperation;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class NewProfileInitializationOperation {
    private final Profile profile;
    private ConfigurationEditor configurationEditor = null;
    private static final Logger log = Logger.getLogger(NewProfileQualificationOperation.class);

    public NewProfileInitializationOperation(Profile profile) {
        this.profile = profile;
    }

    public IStatus initializeNewProfile() {
        IStatus status = Status.OK_STATUS;
        String contextId = this.profile.getData("eclipseContext");
        if (contextId == null) {
            return status;
        }
        String eclipseLocation = this.profile.getEclipseLocation();
        if (eclipseLocation == null) {
            return status;
        }
        File existingEclipseLocation = new File(eclipseLocation);
        if (!existingEclipseLocation.isDirectory()) {
            return status;
        }
        File configurationLocation = new File(eclipseLocation, "configuration");
        if (!configurationLocation.isDirectory()) {
            return status;
        }
        try {
            this.configurationEditor = new ConfigurationEditor(configurationLocation, PlatformUtils.getLauncherLocation((File)existingEclipseLocation), null);
        }
        catch (CoreException ce) {
            log.error((Throwable)ce);
            return ce.getStatus();
        }
        if (this.configurationEditor != null) {
            IStatus locStatus = this.checkVmLocation();
            if (!locStatus.isOK()) {
                return locStatus;
            }
            int initializeStatus = this.configurationEditor.doInitialize();
            if (initializeStatus != 0) {
                status = new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.EclipseQualificationOperation_eclipseCouldNotbeInitialized, (Object)this.configurationEditor.getInstallLocation()), null);
            }
        }
        return status;
    }

    private IStatus checkVmLocation() {
        String javaHome = this.profile.getData("existing.jre.for.eclipse.ide.java.home");
        if (this.configurationEditor.getVMLocation() != null || this.isJreSubDir(javaHome)) {
            return Status.OK_STATUS;
        }
        String iniFileName = String.valueOf(this.configurationEditor.getLauncherName()) + ".ini";
        ICicStatus locStatus = Statuses.ERROR.get(Messages.NewProfileInitializationOperation_missingVmArgument, new Object[]{this.configurationEditor.getInstallLocation(), iniFileName});
        if (javaHome != null) {
            File binDir = new File(javaHome, "bin");
            CicMultiStatus continueStatus = Statuses.INFO.getMultiStatus(Messages.NewProfileInitializationOperation_addMissingVmArgument, new Object[]{this.configurationEditor.getInstallLocation(), iniFileName, binDir.getPath()});
            CicMultiStatus childStatus = Statuses.INFO.getMultiStatus(Messages.NewProfileInitializationOperation_addMissingVmArgumentDetails, new Object[]{iniFileName});
            continueStatus.add((IStatus)childStatus);
            childStatus.add((IStatus)Statuses.INFO.get("-vm", new Object[0]));
            childStatus.add((IStatus)Statuses.INFO.get(binDir.getPath(), new Object[0]));
            boolean okToContinue = UserFeedback.isOkToContinue((IStatus)continueStatus, (boolean)true, (boolean)false);
            if (okToContinue) {
                try {
                    this.configurationEditor.setVMLocation(binDir.getPath());
                    this.configurationEditor.saveExeIni();
                    locStatus = Status.OK_STATUS;
                }
                catch (CoreException e) {
                    log.status(e.getStatus());
                }
            }
        }
        return locStatus;
    }

    private boolean isJreSubDir(String javaHome) {
        if (javaHome == null) {
            return false;
        }
        File eclipseDir = this.configurationEditor.getInstallLocation();
        File jreSubDir = new File(eclipseDir, "jre");
        File javaHomeDir = new File(javaHome);
        return FileUtil.filesAreSame((File)jreSubDir, (File)javaHomeDir);
    }
}

