#!/bin/sh

########################################################################
#
#       Licensed Materials - Property of IBM
#
#       (C) Copyright IBM Corp. 2011. All Rights Reserved
#
#       US Government Users Restricted Rights - Use, duplication
#       or disclosure restricted by GSA ADP Schedule Contract
#       with IBM Corp.
#
#       ========================================================
#       Module Information:
#
#       DESCRIPTION:
#       set_ibm_jre.sh
#
########################################################################

###################################################
# Find nco_common
NCO_COMMON=`dirname $0`/../../bin/nco_common

# Check for nco_common, and load if found
if [ ! -f "$NCO_COMMON" ]; then
        echo "Cannot find nco_common" 1>&2
        exit 1
fi
. $NCO_COMMON

# 
# Set NCO_PROBE_JRE to the path of the highest available in JRE available in $NCHOME
#
if [ -n "$NCHOME" ]; then
	BASE_JRE_DIR="${NCHOME}/platform/${ARCH}"
	
	NCO_PROBE_JRE=""
  	JRE_VERSION=""
  	for jre in ${BASE_JRE_DIR}/jre_[0-9].[0-9].[0-9]
    	do
			if [ -f "$jre/jre/bin/java" ]; then
				# JRE found
				NCO_PROBE_JRE="$jre/jre"
				JRE_VERSION=`echo $jre | sed 's/.*\/jre_\([0-9].[0-9].[0-9]\)$/\1/g'`
			fi
  	done 
		
	if [ -z "$NCO_PROBE_JRE" ] ; then
		# Could not find a JRE under NCHOME
		echo "Unable to locate a valid JRE under NCHOME=$NCHOME. Exiting"
		exit 1
	elif [ ! -x "$NCO_PROBE_JRE/bin/java" ]; then
		# Found a JRE under NCHOME, but the 'java' binary does not have 'execute' permission
		echo "IBM JRE cannot be used as $NCO_PROBE_JRE/bin/java does not have 'execute' permission. Exiting."
		exit 1
	fi
	
	export NCO_PROBE_JRE
	export JRE_VERSION
	
else
	# NCHOME not set, cannot carry on
	echo "NCHOME is not set, cannot proceed"
	exit 1	
fi
