#!/bin/sh
#
# Licensed Materials - Property of IBM
# Restricted Materials of IBM
#
# 5724O4800
#
# (C) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
#
script=`basename $0`
synopsis="$script responseFile acceptLicense"

omnibus_silent_update=true
export omnibus_silent_update

usage()
{
    cat <<EOF
NAME
       $script - wrapper script to do a silent update of Netcool/OMNIbus 8.1 on Unix-like OS

SYNOPSIS
       $synopsis

DESCRIPTION
       $script is used to update Netcool/OMNIbus 8.1 on Unix-like system using the details from the responseFile.xml

       Unless the --help or -h options is given, the following arguments are required

       responseFile: path to the xml file with the update details to use
       acceptLicense: acceptance of the Netcool/OMNIbus install conditions
       

EXAMPLE:

    $script /opt/IBM/tivoli/responsefiles/silentInstall_unix.xml

EOF
}
showError()
{
    help="Try \`$script --help\` for more information"
    msg=`cat <<EOF
$1

Usage: $synopsis
$help
EOF`
    error "$msg" $2
}


# Usage/Help
# -------------------------------------------
if [ $# -lt 1 ]; then
    if [ "$1" = "-h" -o "$1" = "-help" -o "$1" = "--help" ]; then
        usage
        exit 0
    else
      echo
      echo  ERROR: Insufficient parameters used.
      echo
      usage
      exit 0
    fi
fi


responseFile="$1"
acceptLicense="$2"
shift

if [ -f responseFile ] ; then
   usage
   exit 0
fi
if [ "${acceptLicense}" != "acceptLicense" ]; then
    echo
    echo ERROR: License must be accepted to continue
    echo
    usage
    exit 1
fi

CURRENT_DIR=`dirname $0`
OS=`uname`
CPUTYPE=`uname -m`
BITMODE=`getconf LONG_BIT`
DIRNAME=""
ERRORMSG="ERROR: Installation Manager is not supported on this platform."

case "$OS" in
   AIX)
       DIRNAME="im.aix.ppc"
       ;;

   HP-UX)
       DIRNAME="im.hpux.ia64_32"
       ;;

   Linux)
       ZLINUX=`echo $CPUTYPE | grep -c 390`
       if [ $ZLINUX -eq 1 ] ; then
           ZLINUX64=`echo $CPUTYPE | grep -c s390x`

           if [ $ZLINUX64 -eq 1 ] ; then
               DIRNAME=im.linux.s390
           else
               echo $ERRORMSG
               exit 13
           fi
       fi

       if [ $ZLINUX -ne 1 ] ; then
           case $BITMODE in
              64)
                  DIRNAME="im.linux.x86"
                  ;;
              *)
                  if [ $CPUTYPE="x86_64" ]; then
                      DIRNAME="im.linux.x86"
                  else
                      echo $ERRORMSG
                      exit 13
                   fi
                  ;;
            esac
        fi
        ;;

    SunOS)
        DIRNAME="im.solaris.sparc"
        ;;

    *)  #Unsupported OS
        echo $ERRORMSG
        exit 1
     ;;

esac

isroot=false
if [ "`id -u`" = "0" ]; then
    isroot=true
fi

MATCH="<\/profile>";
INSERT="<data key=\'user.silentInstall\' value=\'true\'\/>"
ISSILENT=`cat $responseFile|grep -c user.silentInstall`
if [ $ISSILENT -eq 0 ] ; then
    sed -i "s/$MATCH/$INSERT\n$MATCH/g" $responseFile
fi

# If user is root, check for existence of file  /etc/.ibm/registry/InstallationManager.dat
if $isroot; then
        imRegistry=/etc/.ibm/registry/InstallationManager.dat
        imInstalled=false
        if [ -f $imRegistry ]; then
            imLocation=`grep location= $imRegistry|cut -f2 -d=`
            if [ -d $imLocation ]; then
                imInstalled=true
            fi
        else
            # If we can't find a registry in the expected location it could be due to the old install_gui.sh script
            #  that did a userinst instead of an administrator install. Check the other location too:-
            imRegistry=$HOME/etc/.ibm/registry/InstallationManager.dat
            if [ -f $imRegistry ]; then
                imLocation=`grep location= $imRegistry|cut -f2 -d=`
                if [ -d $imLocation ]; then
                    imInstalled=true
	        fi
            fi
        fi
        echo imLocation=$imLocation
        echo imInstalled=$imInstalled

        if $imInstalled; then
            $imLocation/eclipse/tools/imcl -silent input $responseFile -acceptLicense
            exit $?

        else
               echo "This Netcool/OMNIbus Fix Pack requires access to the IBM Installation Manager used to install the base Netcool/OMNIbus install."
               exit 1 
        fi

# If user is not root, check for existence of file  ~/etc/.ibm/registry/InstallationManager.dat
else
        imRegistry=$HOME/etc/.ibm/registry/InstallationManager.dat
        imInstalled=false
        if [ -f $imRegistry ]; then
                  imLocation=`grep location= $imRegistry|cut -f2 -d=`
                  if [ -d $imLocation ]; then
                       imInstalled=true
                  fi
        fi
        echo imLocation=$imLocation
        echo imInstalled=$imInstalled

        if $imInstalled; then # Using IM ON_MACHINE                          
             $imLocation/eclipse/tools/imcl -silent input $responseFile -acceptLicense
             exit $?
        else      
             echo "This Netcool/OMNIbus Fix Pack requires access to the IBM Installation Manager used to install the base Netcool/OMNIbus install."
             exit 1
        fi
fi

exit $?
