/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core.postsession;

import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.api.IPostSessionContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.api.PostSessionExtender;
import com.ibm.cic.common.core.model.IOffering;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Migrate
extends PostSessionExtender {
    private ILogger logger = IMLogger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());
    private static final String omnibusID = "com.ibm.tivoli.omnibus.core";
    private static final String MIGRATE_STATUS = "migrate.status";

    public IStatus runPostInstall(IPostSessionContext context, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (context.getAgent().isSkipInstall()) {
            return status;
        }
        for (IAgentJob job : context.getJobs()) {
            IOffering offering = job.getOffering();
            if (offering == null || !offering.getIdentity().getId().startsWith(omnibusID) || !this.jobComplete(job) || !job.isInstall()) continue;
            this.checkAndMigrate(context);
        }
        return status;
    }

    private void checkAndMigrate(IPostSessionContext context) {
        String omnibusUserPrefix = "user.omnibus.core.";
        String migrateStatus = context.getProfile().getUserData(omnibusUserPrefix + MIGRATE_STATUS);
        String oldOmnihome = context.getProfile().getUserData(omnibusUserPrefix + "old.OMNIHOME");
        String migrateSrc = context.getProfile().getUserData(omnibusUserPrefix + "migrate.src");
        int exitcode = 0;
        this.logger.debug("Checking migration values [{0}][{1}]", (Object)migrateStatus, (Object)migrateSrc);
        if (migrateSrc != null && migrateStatus == null) {
            String[] args = null;
            if (System.getProperty("os.name").indexOf("Windows") != -1) {
                args = new String[]{"wscript", context.getProfile().getInstallLocation() + "\\omnibus\\upgrade\\nco_win_migrate.wsf", "/save:" + migrateSrc + "\\omnibus", "/new:" + context.getProfile().getInstallLocation() + "\\omnibus", "/old:" + oldOmnihome, "/messagelog:" + context.getProfile().getInstallLocation() + "\\omnibus\\log\\migrate.log"};
            } else {
                try {
                    File migrateScript = File.createTempFile("nco_migration_", ".sh");
                    FileWriter migrateWriter = new FileWriter(migrateScript);
                    String installLoc = context.getProfile().getInstallLocation();
                    migrateWriter.write("#!/bin/sh" + System.getProperty("line.separator"));
                    migrateWriter.write("\"" + installLoc + "/omnibus/upgrade/UPGRADE.SH\"" + " -old " + "\"" + migrateSrc + "\"" + " -new " + "\"" + installLoc + "/omnibus\"" + " > \"" + installLoc + "/omnibus/log/migrate.log\" 2>&1");
                    migrateWriter.close();
                    migrateScript.setExecutable(true);
                    args = new String[]{migrateScript.getCanonicalPath()};
                    migrateScript.deleteOnExit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Runtime runtime = Runtime.getRuntime();
                Process proc = runtime.exec(args);
                this.readStreamInThread(proc.getErrorStream(), "ERROR");
                this.readStreamInThread(proc.getInputStream(), "STDOUT");
                exitcode = proc.waitFor();
            }
            catch (InterruptedException ie) {
                this.logger.warning(ie.toString());
            }
            catch (IOException ioe) {
                this.logger.warning(ioe.toString());
            }
            this.logger.debug("Migration exited with exit code " + exitcode);
            context.getProfile().setUserData(omnibusUserPrefix + MIGRATE_STATUS, "Complete");
        } else {
            this.logger.debug("Migration not required based current values");
        }
    }

    private boolean jobComplete(IAgentJob job) {
        IOffering jobOffering;
        if (job.isUninstall()) {
            return true;
        }
        IProfile profile = job.getAssociatedProfile();
        IOffering profileOffering = profile.findOffering((jobOffering = job.getOffering()).getIdentity().getId());
        return profileOffering != null && jobOffering.getVersion().equals((Object)profileOffering.getVersion());
    }

    private void readStreamInThread(final InputStream in, final String type) {
        new Thread(){
            InputStreamReader isReader;
            BufferedReader reader;
            StringBuffer sb;
            String line;
            {
                this.isReader = new InputStreamReader(in);
                this.reader = new BufferedReader(this.isReader);
                this.sb = new StringBuffer();
                this.line = null;
            }

            @Override
            public void run() {
                try {
                    while ((this.line = this.reader.readLine()) != null) {
                        this.sb.append(this.line);
                    }
                }
                catch (IOException ioe) {
                    Migrate.this.logger.warning(ioe.getMessage());
                }
                if (this.sb.length() > 0) {
                    if (type.equals("ERROR")) {
                        Migrate.this.logger.error(this.sb.toString());
                    } else {
                        Migrate.this.logger.debug(this.sb.toString());
                    }
                }
            }
        }.start();
    }
}

