/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core.custompanel;

import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.custompanel.api.TemplateCheckBox;
import com.ibm.cic.agent.core.custompanel.api.TemplateConstants;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateLabel;
import com.ibm.cic.agent.core.custompanel.api.TemplateText;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.tivoli.omnibus.core.custompanel.Messages;
import com.ibm.tivoli.omnibus.core.custompanel.Utility;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class MigratePanel
extends TemplateCustomPanel {
    private final int indentSize = 30;
    private final String OMNIBUS = "omnibus.core.";
    private final String MIGRATION_SOURCE = "user.omnibus.core.migrate.src";
    private final TemplateCustomPanel.UserData dirUserData = this.createUserData("user.dirUserData", "Directory description");
    private final TemplateCustomPanel.UserData migrateOMNIbusData = (TemplateCustomPanel.UserData)this.createUserData("user.migratedata", "Migrate OMNIbus data").defaultValue("false");
    TemplateCheckBox migrateData = null;
    private ILogger logger = IMLogger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());
    File logFile = null;
    File installDir = null;
    TemplateLabel sourceLabel = null;
    TemplateLabel targetLabel = null;
    TemplateLabel logLabel = null;
    TemplateWidgetContainer container = null;

    public MigratePanel() {
        super(Messages.MigrateDataPanelName);
        File omnibus = new File("omnibus");
        File log = new File(omnibus, "log");
        this.logFile = new File(log, "migrate.log");
    }

    public void createWidgets(TemplateWidgetContainer parentContainer) {
        String msgMigrateSource = null;
        String msgDirectory = null;
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            msgMigrateSource = Messages.MigrateFromAnotherInstall;
            msgDirectory = Messages.MigrateEnterPreviousDir;
        } else {
            msgMigrateSource = Messages.MigrateFromDataStore;
            msgDirectory = Messages.MigrateEnterDataStore;
        }
        this.migrateData = (TemplateCheckBox)((TemplateCheckBox)parentContainer.createCheckBox(this.migrateOMNIbusData, msgMigrateSource, "true").deselectedValue("false").consoleKey('M')).triggerUpdate(true);
        this.container = (TemplateWidgetContainer)this.migrateData.createContainer().enabled(false);
        this.container.createLabel(msgDirectory).enabled(false);
        ((TemplateText)((TemplateText)this.container.createText(this.dirUserData).style(TemplateConstants.TextStyle.DIRECTORY).description(msgDirectory).consoleKey('D')).enabled(false)).triggerUpdate(true);
        this.container.createLabel("");
        this.container.createLabel(Messages.MigrationInformation).enabled(false);
        this.sourceLabel = (TemplateLabel)((TemplateLabel)this.container.createLabel(NLS.bind((String)Messages.MigrationSourceDirectory, (Object)"")).enabled(false)).indent(30);
        this.targetLabel = (TemplateLabel)((TemplateLabel)this.container.createLabel("").enabled(false)).indent(30);
        this.logLabel = (TemplateLabel)((TemplateLabel)this.container.createLabel("").enabled(false)).indent(30);
    }

    public void updateWidgets(TemplateCustomPanel.UserData userData) {
        if (userData.equals(this.migrateOMNIbusData)) {
            if (Boolean.valueOf(this.migrateOMNIbusData.getValue()).booleanValue()) {
                this.container.enabled(true);
            } else {
                this.container.enabled(false);
            }
        }
        if (userData.equals(this.dirUserData)) {
            this.sourceLabel.displayLabel(NLS.bind((String)Messages.MigrationSourceDirectory, (Object)this.dirUserData.getValue().trim()));
        }
    }

    public void validate(IProgressMonitor monitor) {
        ICustomPanelData cpdata = this.getCustomPanelData();
        String boxChecked = this.migrateOMNIbusData.getValue();
        if (Boolean.valueOf(boxChecked).booleanValue()) {
            String textValue = this.dirUserData.getValue();
            if (textValue == null || textValue.isEmpty()) {
                this.dirUserData.error(Messages.MigrateMissingDirValue, new Object[0]);
            } else {
                String migrationSourceError = Utility.checkMigrationSource(textValue, this.logger);
                if (migrationSourceError != null) {
                    this.dirUserData.error(migrationSourceError, new Object[0]);
                } else {
                    cpdata.getProfile().setUserData("user.omnibus.core.migrate.src", textValue);
                }
            }
        } else {
            cpdata.getProfile().removeUserData("user.omnibus.core.migrate.src");
        }
    }

    public boolean canAddPanelToWizard() {
        return !this.getCustomPanelData().getAgent().isConsoleMode();
    }

    public boolean shouldSkip() {
        if (this.targetLabel != null || this.logLabel != null) {
            this.installDir = new File(this.getCustomPanelData().getProfile().getInstallLocation());
            if (this.targetLabel != null) {
                this.targetLabel.displayLabel(NLS.bind((String)Messages.MigrationTargetDirectory, (Object)this.installDir.toString()));
            }
            if (this.logLabel != null) {
                this.logLabel.displayLabel(NLS.bind((String)Messages.MigrationLogFile, (Object)(this.installDir.toString() + File.separator + this.logFile)));
            }
        }
        return false;
    }
}

