#!/bin/sh

########################################################################
#
#       Licensed Materials - Property of IBM
#
#       (C) Copyright IBM Corp. 2011, 2018. All Rights Reserved
#
#       US Government Users Restricted Rights - Use, duplication
#       or disclosure restricted by GSA ADP Schedule Contract
#       with IBM Corp.
#
#       ========================================================
#       Module Information:
#
#       DESCRIPTION:
#       set_ibm_jre.sh
#
########################################################################

###################################################
# Find nco_common
NCO_COMMON=`dirname $0`/../../bin/nco_common

# Check for nco_common, and load if found
if [ ! -f "$NCO_COMMON" ]; then
        echo "Cannot find nco_common" 1>&2
        exit 1
fi
. $NCO_COMMON

# 
# Set NCO_PROBE_JRE to the path of the highest available in JRE available in $NCHOME
#
if [ -n "$NCHOME" ]; then
	NCO_PROBE_JRE=${NCO_JRE_64_32}
	JRE_VERSION=`echo ${NCO_JRE_64_32} | sed 's/.*\/jre.*_\([0-9]*.[0-9]*.[0-9]*\).*$/\1/'`

	if [ -z "$NCO_PROBE_JRE" ] ; then
		# Could not find a JRE under NCHOME
		echo "Unable to locate a valid JRE under NCHOME=$NCHOME. Exiting"
		exit 1
	elif [ ! -x "$NCO_PROBE_JRE/bin/java" ]; then
		# Found a JRE under NCHOME, but the 'java' binary does not have 'execute' permission
		echo "IBM JRE cannot be used as $NCO_PROBE_JRE/bin/java does not have 'execute' permission. Exiting."
		exit 1
	fi
	
	export NCO_PROBE_JRE
	export JRE_VERSION
else
	# NCHOME not set, cannot carry on
	echo "NCHOME is not set, cannot proceed"
	exit 1	
fi
